var Ventasapp=function(){
	this.baseUrl=null;
	this.config=null;
	this.setUrl=function(url){
		this.baseUrl=url;
	},
	this.setConfig=function(conf){
		this.config=conf;
	},
	this.validador={
		productos:function(){
			return {
				result:$("#nueva-venta-app-productos-wrapper table tr").size()>0,
				msg:"Por favor agregue productos a la lista",
				type:1,
				action:function(){
					$("#nueva-venta-app-producto-sku").focus();
				}
			}
		},
		documentosTransitorioCredito:function(){
			return {
				result:($("#nueva-venta-app-documento").val()==1 || $("#nueva-venta-app-documento").val()==2 || $("#nueva-venta-app-documento").val()==3?true:false),
				msg:"Los documento transitorios estan permitidos solo para ventas al cr&eacute;dito, por favor seleccione otro tipo de documento",
				type:1,
				action:function(){
					$("#nueva-venta-app-documento").focus();
				}
			}
		},
		documentosFacturadosContado:function(){
			return {
				result:($("#nueva-venta-app-documento").val()!=1 && $("#nueva-venta-app-documento").val()!=2 && $("#nueva-venta-app-documento").val()!=3?true:false),
				msg:"Los documento de facturacion definitiva estan permitidos solo para ventas al contado, por favor seleccione otro tipo de documento",
				type:1,
				action:function(){
					$("#nueva-venta-app-documento").focus();
				}
			}
		},
		cliente:function(){
			return {
				result:($.trim($("#nueva-venta-app-cliente").val())!=''?true:false),
				msg:"Por favor seleccione un cliente",
				type:1,
				action:function(){
					$("#nueva-venta-app-cliente-buscar-btn").focus();
				}
			}
		},
		clienteNombre:function(){
			return {
				result:($.trim($("#nueva-venta-app-cliente-text").val())!=""?true:false),
				msg:"Por favor ingrese un nombre o seleccione un cliente",
				type:1,
				action:function(){
					$("#nueva-venta-app-cliente-text").focus();
				}
			}
		},
		clienteNRC:function(){
			return {
				result:($.trim($("#nueva-venta-cliente-nrc").val())!=""?true:false),
				msg:"Por favor ingrese el N&uacute;mero de Registro Comercial (NRC)",
				type:2,
				action:function(){
					$('#nueva-venta-cliente-docs').on('shown.bs.modal', function () {
						$("#nueva-venta-cliente-nrc").focus();
					});
					$('#nueva-venta-cliente-docs').modal("show");
					$("#nueva-venta-cliente-nrc").focus();
				}
			}
		},
		clienteDUIoNIT:function(){
			return {
				result:($.trim($("#nueva-venta-cliente-dui").inputmask('unmaskedvalue')).length == 9 || $.trim($("#nueva-venta-cliente-nit").inputmask('unmaskedvalue')).length == 14?true:false),
				msg:"Por favor ingrese el N&uacute;mero de Documento Unico de Identidad (DUI) 0 el N&uacute;mero de Identificaci&oacute;n tributaria (NIT) v&aacute;lido",
				type:2,
				action:function(){
					$('#nueva-venta-cliente-docs').on('shown.bs.modal', function () {
						$("#nueva-venta-cliente-dui").focus();
					});
					$('#nueva-venta-cliente-docs').modal("show");
					$("#nueva-venta-cliente-dui").focus();
				}
			}
		},
		creditoAutorizado:function(){
			return {
				result:($("#nueva-venta-app-cliente-text").attr('data-credito')=='1'?true:false),
				msg:"El cliente seleccionado no posee cr&eacute;ditos autorizados",
				type:1
			}
		},
		creditoMontoAutorizado:function(){
			var disponible=0;
			jQuery.ajaxSetup({async:false});
			$.get(window.location.protocol+"//"+window.location.host+"/"+window.location.pathname.split('/')[1]+'/clientes/getcreditodisponible',{cliente:$.trim($("#nueva-venta-app-cliente").val())},function(disp){
				disponible=parseFloat(disp);
			},'text');
			jQuery.ajaxSetup({async:true});
			return {
				result:(parseFloat($('#nueva-venta-app-totales-wrapper .totalval').attr('data-value')) <= disponible?true:false),
				msg:"El monto de esta transacci&oacute;n supera el cr&eacute;dito disponible ($ "+disponible+") para el cliente seleccionado",
				type:1
			}
		}
	}
	this.test=function(){
		console.log('La clase Ventasapp ha sido instanciado correctamente');
	}
	this.cargarTrans=function(){
		var tableTrans = $('#ventas-table').DataTable();
		tableTrans.ajax.reload();
		setTimeout(function () { $('div.dataTables_filter input').focus(); }, 100);
	 }
	 this.validarVenta=function($sender){
		if($sender){
			$sender.attr('disabled','disabled');
		}
		var _this=this;
		var reglas={productos:this.validador.productos(),clienteNombre:this.validador.clienteNombre()}
		var reglasTipo1=2;
		var reglasTipo2=0;
		/*Contado en documento transitorios*/
		if($("#nueva-venta-app-condicion").val()==0 && this.config.transacciones_validar_credito_transitorios){
			reglas.documentosTransitorioCredito=this.validador.documentosTransitorioCredito();
			reglasTipo1+=1;
		}		
		/*Contado en documento transitorios*/
		if($("#nueva-venta-app-condicion").val()==1 && this.config.transacciones_validar_contado_facturados){
			reglas.documentosFacturadosContado=this.validador.documentosFacturadosContado();
			reglasTipo1+=1;
		}
		/*Venta credito nivel 1*/
		if($("#nueva-venta-app-condicion").val()==1){
			reglas.cliente=this.validador.cliente();
			reglas.creditoAutorizado=this.validador.creditoAutorizado();
			reglas.creditoMontoAutorizado=this.validador.creditoMontoAutorizado();
			delete reglas.clienteNombre;
			reglasTipo1+=2;
		}
		/*Venta con CCF*/
		if($("#nueva-venta-app-documento").val()==2){
			reglas.clienteNRC=this.validador.clienteNRC();
			reglasTipo2+=1;
		}
		/*Venta mayor a 200 Factura*/
		if(parseFloat($('#nueva-venta-app-totales-wrapper .totalTotal .totalval').attr('data-value'))>=200.00 && $("#nueva-venta-app-documento").val()==1){
			reglas.clienteDUI=this.validador.clienteDUIoNIT();
			reglasTipo2+=1;
		}
		/*Venta mayor a 200 Ticket*/
		if(parseFloat($('#nueva-venta-app-totales-wrapper .totalTotal .totalval').attr('data-value'))>=200.00 && $("#nueva-venta-app-documento").val()==3){
			reglas.clienteDUI=this.validador.clienteDUIoNIT();
			reglasTipo2+=1;
		}
		
		var valid=true;
		var reglasCountTipo1=0;
		var reglasCountTipo2=0;
		var errorInType=null;
		$.each(reglas,function(i,regla){
			if(regla.type){
				if(regla.type==1)
					reglasCountTipo1+=1;
				else if(regla.type==2)
					reglasCountTipo2+=1;
			}
			if(!regla.result){
				valid=regla.result;
				if(regla.msg)
					_this.showMsgVenta('error',regla.msg);
				if(regla.action)
					regla.action();
				if(regla.type)
					errorInType=regla.type;
			}else{
				if(reglasCountTipo2==reglasTipo2)
					$('#nueva-venta-cliente-docs').modal("hide");
			}
			return valid;
		});
		if(valid){
			$("#nueva-venta-confirm-total").text(parseFloat($('#nueva-venta-app-totales-wrapper .totalTotal .totalval').attr('data-value')));
			$('#nueva-venta-confirmar').on('shown.bs.modal',function(){
				$("#nueva-venta-confirmar-guardar-btn").focus();
				$("#guardar-venta-app-btn").attr('disabled','disabled');
			});
			$("#nueva-venta-confirmar").modal({backdrop: 'static', keyboard: false});
			$("#nueva-venta-confirmar").modal("show"); 
		}
		else{
			if(errorInType==1)
				$("#guardar-venta-app-btn").removeAttr('disabled');
			else if(errorInType==2)
				$("#nueva-venta-doc-guardar-btn").removeAttr('disabled');
		}
	}
	 this.cancelarValidarVenta=function(){
		$("#guardar-venta-app-btn").removeAttr('disabled');
		$("#nueva-venta-doc-guardar-btn").removeAttr('disabled');
		$("#nueva-venta-confirmar-guardar-btn").removeAttr('disabled');
		$("#nueva-venta-cancelar-guardar-btn").removeAttr('disabled');
	}
	
	this.processVenta=function(){
		var _this=this;
		$("#nueva-venta-confirmar-guardar-btn").attr('disabled','disabled');
		$("#nueva-venta-cancelar-guardar-btn").attr('disabled','disabled');
		$("#nueva-venta-procesar-status-text").text('Guardando venta...');
		$("#nueva-venta-procesar-status-icon").html("<i class='fa fa-spinner fa-5x'></i>");
		
		var productos=[];
		var totales=[];
		var products=$("#nueva-venta-app-productos-wrapper table tr");
		var totals=$("#nueva-venta-app-totales-wrapper tr");
		$.each(products,function(index,product){
			productos.push({descarga:true,id:$(product).attr('data-id'),pre:$(product).attr('data-pre'),uequiv:$(product).attr('data-uequiv'),desc:$(product).find('.table-desc').attr('data-value'),cant:$(product).find('.table-cant').attr('data-value'),costo:$(product).find('.table-precio').attr('data-value'),tipoventa:$(product).find('.table-tipoventa').attr('data-value')});
		});
		$.each(totals,function(index,total){
			switch($(total).attr('class')){
				case 'totalSumas':totales.push({totalSumas:$(total).find('.totalval').attr('data-value')});break;
				case 'totalGrabadas':totales.push({totalGrabadas:$(total).find('.totalval').attr('data-value')});break;
				case 'totalIVA':totales.push({totalIVA:$(total).find('.totalval').attr('data-value')});break;
				case 'totalIVApercibido':totales.push({totalIVApercibido:$(total).find('.totalval').attr('data-value')});break;
				case 'totalIVAretenido':totales.push({totalIVAretenido:$(total).find('.totalval').attr('data-value')});break;
				case 'totalSubtotal':totales.push({totalSubtotal:$(total).find('.totalval').attr('data-value')});break;
				case 'totalNS':totales.push({totalNS:$(total).find('.totalval').attr('data-value')});break;
				case 'totalExento':totales.push({totalExento:$(total).find('.totalval').attr('data-value')});break;
				case 'totalTotal':totales.push({totalTotal:$(total).find('.totalval').attr('data-value')});break;
			}
		});
		$.post(_this.baseUrl+'transacciones/guardarventaapp', {idventa:$("#id-ventaapp").val(),cliente:$('#nueva-venta-app-cliente').val(),clientetxt:$.trim($("#nueva-venta-app-cliente-text").val()),dui:$.trim($("#nueva-venta-cliente-dui").val()),nit:$.trim($("#nueva-venta-cliente-nit").val()),nrc:$.trim($("#nueva-venta-cliente-nrc").val()),condicion:$('#nueva-venta-app-condicion').val(),documento:$('#nueva-venta-app-documento').val(),vendedor:$('#nueva-venta-app-vendedor').val(),productos:JSON.stringify(productos),totales:JSON.stringify(totales)})
		.done(function(venta) {
				$("#nueva-venta-procesar-status-text").html('¡La venta se ha guardado! <br> <strong style="font-size:32px">'+venta+'</strong>');
				$("#nueva-venta-procesar-status-icon").html("<i style='color:#1AB394;' class='fa fa-check-circle fa-5x'></i>");
				$("#nueva-venta-confirmar-guardar-btn").hide();
				$("#nueva-venta-cancelar-guardar-btn").hide();
				$("#nueva-venta-confirmar-salir-btn").show();
				$("#nueva-venta-confirmar-salir-btn").focus();
			});
	}
	this.facturar=function(id){
		var _this=this;
		Custombox.open({
			target:_this.baseUrl+'transacciones/facturacionapp?ventatrans='+id, 
			effect: 'fadein',
			overlayClose:false,
			complete:function(){
				/* $(".modal-body input:text").first().focus(); */
			}
		});
	}
	this.modificar=function(id){
		var _this=this;
		Custombox.open({
            target:_this.baseUrl+"transacciones/venta_nueva?id="+id,
            effect: 'fadein',
			overlayClose:false,
			complete:function(){
					$(".modal-body input:text").first().focus();
				}
        });
	}
	this.eliminar=function(id){
		alert('eliminar');
	}
	this.showMsgVenta=function(tipo, mensaje){
		toastr.options = {
			"closeButton": true,
			"progressBar": true,
			"positionClass": "toast-top-right"
		}
		toastr[tipo](mensaje);
	}
}
var ventasapp = new Ventasapp();