<?php
	$this->load->library('fpdf');
	
	$GLOBALS['dataArray'] = array(
        'Empresa' => $configs['NombreEmpresa'],
        'Direccion' => $configs['DireccionEmpresa'],
        'Logo' => base_url($configs['LogoEmpresa'])
    );
	
	class PDF extends FPDF{
    
        function Header(){
            global $dataArray;
			
            $this->Image($dataArray['Logo'],15,5,35);
        }
        
        function Footer(){
            $this->SetY(170);
            $this->SetFont('Arial','I',7);
            $this->Cell(200,6,utf8_decode('Pagina '.$this->PageNo().'/{nb}'),0,0,'L');
            $this->Cell(60,6,utf8_decode(gmdate('d-m-Y H:i:s', strtotime('- 6 hours'))),0,1,'R');
            $this->Cell(60,6,utf8_decode('Miracle v1.5 - Todos los Derechos Reservados 2012 - '.date('Y').' - Xypnos Soluciones Tecnologicas'),0,1,'L');
        }
    }
	
	$pdf = new PDF();
    $pdf->AliasNbPages(); 
    $pdf->setTitle('Reporte de Ventas');
    $pdf->setAuthor('Miracle v1.5 - Xypnos');
    $pdf->AddPage('P','Letter');
    $pdf->SetFont('Arial','',12);

    $pdf->Rect(10,10,125,175);

    $pdf->Rect(100,15,30,15);
    $pdf->SetXY(100,15);
    $pdf->Cell(30,6,utf8_decode('Factura'),0,1,'C');
    $pdf->SetFont('Arial','B',12);
    $pdf->SetX(100);
    $pdf->Cell(30,6,utf8_decode($venta->num_documento_venta),0,1,'C');
    $pdf->Ln(8);

    $pdf->SetX(15);
    $pdf->SetFont('Arial','',10);
    $pdf->Cell(30,6,utf8_decode('Fecha:'),0,0,'L');
    $pdf->SetFont('Arial','B',10);
    $pdf->Cell(85,6,utf8_decode($venta->fecha_venta),0,1,'L');
    $pdf->SetX(15);
    $pdf->SetFont('Arial','',10);
    $pdf->Cell(30,6,utf8_decode('Tienda:'),0,0,'L');
    $pdf->SetFont('Arial','B',10);
    $pdf->Cell(85,6,utf8_decode($configs['NombreEmpresa']),0,1,'L');
    $pdf->SetX(15);
    $pdf->SetFont('Arial','',10);
    $pdf->Cell(30,6,utf8_decode('Cliente:'),0,0,'L');
    $pdf->SetFont('Arial','B',10);
    $pdf->Cell(85,6,utf8_decode($venta->nombre_cliente),0,1,'L');

    $pdf->SetX(15);
    $pdf->SetFont('Arial','B',10);
	$pdf->Cell(10,6,utf8_decode('Cant'),1,0,'C');
	$pdf->Cell(60,6,utf8_decode('Ref / Prod'),1,0,'C');
	$pdf->Cell(15,6,utf8_decode('Costo'),1,0,'C');
	$pdf->Cell(15,6,utf8_decode('Desc'),1,0,'C');
	$pdf->Cell(15,6,utf8_decode('Total'),1,1,'C');
    $pdf->SetFont('Arial','',8);

    $total=$descuento=0;

    foreach($venta->productos as $producto):
        $pdf->SetX(15);
        $pdf->Cell(10,6,(float)$producto->cant_salida,0,0,'L');
        $pdf->Cell(60,6,utf8_decode($producto->ref_presentacion." ".$producto->desc_presentacion),0,0,'L');
        $pdf->Cell(2,6,utf8_decode('$'),0,0,'L');
        $pdf->Cell(13,6,number_format($producto->costo_salida,2),0,0,'R');
        $pdf->Cell(2,6,utf8_decode('$'),0,0,'L');
        $pdf->Cell(13,6,number_format($producto->descuento_salida,2),0,0,'R');
        $pdf->Cell(2,6,utf8_decode('$'),0,0,'L');
        $pdf->Cell(13,6,number_format(($producto->cant_salida*$producto->costo_salida) - $producto->descuento_salida,2),0,1,'R');
        $total+=number_format($producto->cant_salida*$producto->costo_salida,2);
        $descuento+=number_format($producto->descuento_salida,2);
    endforeach;
    $pdf->Ln(8);

    $pdf->SetFont('Arial','',10);
    $pdf->SetX(15);
    $pdf->Cell(100,6,"Subtotal",0,0,'R');
    $pdf->Cell(2,6,utf8_decode('$'),0,0,'L');
    $pdf->Cell(13,6,number_format($total,2),0,1,'R');
    $pdf->SetX(15);
    $pdf->Cell(100,6,"Descuentos",0,0,'R');
    $pdf->Cell(2,6,utf8_decode('$'),0,0,'L');
    $pdf->Cell(13,6,number_format($descuento,2),0,1,'R');
    $pdf->SetX(15);
    $pdf->Cell(100,6,"Total",0,0,'R');
    $pdf->Cell(2,6,utf8_decode('$'),0,0,'L');
    $pdf->Cell(13,6,number_format($total-$descuento,2),0,1,'R');

	/*Exportamos el PDF*/
    $pdf->Output('Reporte de Venta.pdf','I');
?>