<?php
	$this->load->library('fpdf');
	
	$GLOBALS['dataArray'] = array(
        'Empresa' => $configs['NombreEmpresa'],
        'Direccion' => $configs['DireccionEmpresa'],
        'Logo' => base_url($configs['LogoEmpresa']),
        'Grupo' => $groupname,
        'Subgrupo' => $subgroupname,
    );
	
	class PDF extends FPDF{
    
        function Header(){
            global $dataArray;
            $this->Image($dataArray['Logo'],250,5,25);
            $this->SetFont('Arial','B',15);
            $this->SetY(6);
            $this->Cell(0,8,utf8_decode('Reporte de Lista de Precios'),0,1,'C');
            $this->SetFont('Arial','B',12);
            $this->SetY(12);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Empresa'])),0,1,'C');
            $this->SetY(17);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Direccion'])),0,1,'C');
            $this->Ln(3);
			
			$this->SetFont('Arial','',12);
            $this->Cell(20,8,'Grupo',0,0,'L');
			$this->SetFont('Arial','B',12);
            $this->Cell(60,8,utf8_decode($dataArray['Grupo']),0,0,'L');
			
			$this->SetFont('Arial','',12);
            $this->Cell(30,8,'Subgrupo',0,0,'L');
			$this->SetFont('Arial','B',12);
            $this->Cell(30,8,$dataArray['Subgrupo'],0,1,'L');
			$this->Ln(3);
            
             /*Header Tabla*/
            $this->Cell(15,8,'SKU',1,0,'C');
            $this->Cell(110,8,'Producto',1,0,'C');
            $this->Cell(20,8,'Precio 1',1,0,'C');
            $this->Cell(20,8,'Precio 2',1,0,'C');
            $this->Cell(20,8,'Precio 3',1,0,'C');
            $this->Cell(20,8,'Precio 4',1,0,'C');
            $this->Cell(20,8,'Precio 5',1,0,'C');
            $this->Cell(20,8,'Precio 6',1,0,'C');
            $this->Cell(15,8,'Exist',1,1,'C');
            $this->SetFont('Arial','',10);
        }
        
        function Footer(){
            $this->SetY(-15);
            $this->SetFont('Arial','I',7);
            $this->Cell(200,6,utf8_decode('Pagina '.$this->PageNo().'/{nb}'),0,0,'L');
            $this->Cell(60,6,utf8_decode(gmdate('d-m-Y H:i:s', strtotime('- 6 hours'))),0,1,'R');
            $this->Cell(60,6,utf8_decode('Miracle v1.5 - Todos los Derechos Reservados 2012 - '.date('Y').' - Xypnos Soluciones Tecnologicas'),0,1,'L');
        }
    }
	
	$pdf = new PDF();
    $pdf->AliasNbPages(); 
    $pdf->setTitle('Reporte de Inventario');
    $pdf->setAuthor('Miracle v1.5 - Xypnos');
    $pdf->AddPage('L','Letter');
    
    /*Cuerpo del Documento*/
    if(isset($productos) && count($productos) > 0):
		$total = 0;
		$pdf->SetFillColor(255, 255, 126);
        foreach($productos as $producto):
            $pdf->Cell(15,8,utf8_decode(ucwords($producto->sku)),1,0,'L');
            $pdf->Cell(110,8,utf8_decode(ucwords(substr($producto->nombre,0,50))),1,0,'L');
            $pdf->Cell(20,8,utf8_decode(ucwords($producto->precio1)),1,0,'R');
            $pdf->Cell(20,8,utf8_decode(ucwords($producto->precio2)),1,0,'R');
            $pdf->Cell(20,8,utf8_decode(ucwords($producto->precio3)),1,0,'R');
            $pdf->Cell(20,8,utf8_decode(ucwords($producto->precio4)),1,0,'R');
            $pdf->Cell(20,8,utf8_decode(ucwords($producto->precio5)),1,0,'R');
            $pdf->Cell(20,8,utf8_decode(ucwords($producto->precio6)),1,0,'R');
            $pdf->Cell(15,8,utf8_decode(ucwords((float)$producto->existencias)),1,1,'R');
        endforeach;
    endif;
    
    /*Exportamos el PDF*/
    $pdf->Output('Reporte de Inventario','I');
?>