<?php
	$this->load->library('fpdf');
	
	$GLOBALS['dataArray'] = array(
        'Empresa' => $configs['NombreEmpresa'],
        'Direccion' => $configs['DireccionEmpresa'],
        'Logo' => base_url($configs['LogoEmpresa'])
    );
	
	class PDF extends FPDF{
    
        function Header(){
            global $dataArray;
            $this->Image($dataArray['Logo'],250,5,25);
            $this->SetFont('Arial','B',15);
            $this->SetY(6);
            $this->Cell(0,8,utf8_decode('Inventario de Productos'),0,1,'C');
            $this->SetFont('Arial','B',12);
            $this->SetY(12);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Empresa'])),0,1,'C');
            $this->SetY(17);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Direccion'])),0,1,'C');
            $this->Ln(3);
            
            /*Header Tabla*/
            $this->Cell(30,8,'SKU',1,0,'C');
            $this->Cell(70,8,'Producto',1,0,'C');
            $this->Cell(30,8,'Precio 1',1,0,'C');
            $this->Cell(30,8,'Precio 2',1,0,'C');
            $this->Cell(30,8,'Precio 3',1,0,'C');
            $this->Cell(30,8,'Costo',1,0,'C');
            $this->Cell(20,8,'Exist',1,0,'C');
            $this->Cell(20,8,'Contador',1,1,'C');
            $this->SetFont('Arial','',11);
        }
        
        function Footer(){
            $this->SetY(-15);
            $this->SetFont('Arial','I',7);
            $this->Cell(200,6,utf8_decode('Pagina '.$this->PageNo().'/{nb}'),0,0,'L');
            $this->Cell(60,6,utf8_decode(gmdate('d-m-Y H:i:s', strtotime('- 6 hours'))),0,1,'R');
            $this->Cell(60,6,utf8_decode('Miracle v1.5 - Todos los Derechos Reservados 2012 - '.date('Y').' - Xypnos Soluciones Tecnologicas'),0,1,'L');
        }
    }
	
	$pdf = new PDF();
    $pdf->AliasNbPages(); 
    $pdf->setTitle('Reporte de Inventario');
    $pdf->setAuthor('Miracle v1.5 - Xypnos');
    $pdf->AddPage('L','Letter');
    
    /*Cuerpo del Documento*/
    if(isset($productos) && count($productos) > 0):
		$total = 0;
		$pdf->SetFillColor(255, 255, 126);
        foreach($productos as $producto):
            $pdf->Cell(30,8,utf8_decode(ucwords($producto->sku)),1,0,'L');
            $pdf->Cell(70,8,utf8_decode(ucwords(substr($producto->nombre,0,27))),1,0,'L');
            $pdf->Cell(30,8,utf8_decode(ucwords((float)$producto->precio1)),1,0,'R');
            $pdf->Cell(30,8,utf8_decode(ucwords((float)$producto->precio2)),1,0,'R');
            $pdf->Cell(30,8,utf8_decode(ucwords((float)$producto->precio3)),1,0,'R');
			if(is_array($producto->costo)){
				if($producto->costo[0]->costo_entrada > 0){
					$pdf->Cell(30,8,(float)$producto->costo[0]->costo_entrada,1,0,'R');		
				}else{
					$pdf->Cell(30,8,(float)$producto->costo[0]->costo_entrada,1,0,'R',true);		
				}
				if($producto->existencias > 0):
				$total+= $producto->existencias * $producto->costo[0]->costo_entrada;
				endif;
			}else{
				$pdf->Cell(30,8,'0',1,0,'R',true);	
				$total+= 0;
			}
            $pdf->Cell(20,8,utf8_decode(ucwords($producto->existencias)),1,0,'R');
            $pdf->Cell(20,8,'',1,1,'C');
        endforeach;
        $pdf->SetFont('Arial','B',12);
        $pdf->SetX($pdf->GetX()+160);
        $pdf->Cell(60,8,'Valor Inventario',1,0,'C');
        $pdf->Cell(40,8,(float)$total,1,1,'C');
    endif;
    
    /*Exportamos el PDF*/
    $pdf->Output('Reporte de Inventario','I');
?>