<?php
    $this->load->library('PHPExcel');
    $this->load->library("App_utilities");
	$PadillaApp = new App_utilities();
    
    $excel = new PHPExcel();

    $styleArrayHeader = array(
        'font'  => array(
            'bold'  => true,
            'color' => array('rgb' => '000000'),
            'size'  => 14
        )
    ); 
    
    $styleArraySubheader = array(
        'font'  => array(
            'bold'  => false,
            'color' => array('rgb' => '000000'),
            'size'  => 13
        )
    ); 
    
    $styleArrayBorders = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN
            )
        ),
        'font'  => array(
            'bold'  => true,
            'color' => array('rgb' => '000000'),
            'size'  => 13
        )
    );

    $styleArrayBordersBody = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN
            )
        ),
        'font'  => array(
            'bold'  => true,
            'color' => array('rgb' => '000000'),
            'size'  => 12
        )
    );
    
    $counterCell = 8;

    $excel->
        getProperties()
            ->setCreator('Xypnos - Miracle')
            ->setLastModifiedBy('Xypnos')
            ->setTitle('Reportes Miracle')
            ->setSubject('Consumos')
            ->setDescription('Documento generado con PHPExcel y Miracle')
            ->setKeywords('Reportes Miracle - Xypnos')
            ->setCategory('Reportes Miracle');

    $objDrawing = new PHPExcel_Worksheet_Drawing();
    $objDrawing->setName('Logo');
    $objDrawing->setDescription('Logo');
    $objDrawing->setPath('./codigologo.png');
    $objDrawing->setOffsetX(5);
    $objDrawing->setOffsetY(5);
    $objDrawing->setHeight(125);
    $objDrawing->setWidth(125);
    $objDrawing->setWorksheet($excel->getActiveSheet());

    $excel->setActiveSheetIndex(0)
                ->setCellValue('A1', $PadillaApp->fechaHoraElSalvador(gmdate('d-m-Y H:i:s', strtotime('- 6 hours')),0))
                ->setCellValue('A2', 'Inventario de Productos con Existencias')
                ->setCellValue('A3', $configs['NombreEmpresa'])
                ->setCellValue('A4', $configs['DireccionEmpresa'])
                ->setCellValue('A7', 'Referencia')
                ->setCellValue('B7', 'SKU')
                ->setCellValue('C7', 'Descripcion')
                ->setCellValue('D7', 'Existencias')
                ->setCellValue('E7', 'Minimas')
                ->setCellValue('F7', 'Maximas')
                ->setCellValue('G7', 'Costo')
                ->setCellValue('H7', 'Precio')
                ->setCellValue('I7', 'Diferencia');
            
    $sheet = $excel->getActiveSheet();
    $pageMargins = $sheet->getPageMargins();
    $margin = 0.5 / 2.54;
    $pageMargins->setTop($margin);
    $pageMargins->setBottom($margin);
    $pageMargins->setLeft($margin);
    $pageMargins->setRight($margin);

    /*Cuerpo del Documento*/
    if(isset($productos)):
        foreach($productos as $producto):
            $excel->setActiveSheetIndex(0)
                ->setCellValue('A'.$counterCell, $producto->ref_presentacion)
                ->setCellValue('B'.$counterCell, $producto->sku_presentacion)
                ->setCellValue('C'.$counterCell, $producto->desc_presentacion)
                ->setCellValue('D'.$counterCell, $producto->exist_act_producto)
                ->setCellValue('E'.$counterCell, $producto->exist_min_producto)
                ->setCellValue('F'.$counterCell, $producto->exist_max_producto)
                ->setCellValue('G'.$counterCell, $producto->ultimocosto_producto)
                ->setCellValue('H'.$counterCell, $producto->precio_presentacion)
                ->setCellValue('I'.$counterCell, $producto->diferencia_producto);
            $counterCell++;
        endforeach;
    endif;

    //$excel->getActiveSheet()->getColumnDimension('A')->setWidth(10);

    $excel->getActiveSheet()->mergeCells('A1:I1');
    $excel->getActiveSheet()->mergeCells('A2:I2');
    $excel->getActiveSheet()->mergeCells('A3:I3');
    $excel->getActiveSheet()->mergeCells('A4:I4');
    $excel->getActiveSheet()->mergeCells('A5:I5');
    $excel->getActiveSheet()->getStyle('A1:I1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
    $excel->getActiveSheet()->getStyle('A2:I2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $excel->getActiveSheet()->getStyle('A3:I3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $excel->getActiveSheet()->getStyle('A4:I4')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $excel->getActiveSheet()->getStyle('A7:I7')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $excel->getActiveSheet()->getStyle('A2')->applyFromArray($styleArrayHeader);
    $excel->getActiveSheet()->getStyle('A3:I5')->applyFromArray($styleArraySubheader);
    $excel->getActiveSheet()->getStyle('A7:I7')->getAlignment()->setWrapText(true); 
    $excel->getActiveSheet()->getStyle('A7:I7')->applyFromArray($styleArrayBorders);
    $excel->getActiveSheet()->getStyle('C8:C'.$counterCell)->getNumberFormat()->setFormatCode("_(* #,##0.00_);_(* \(#,##0.00\);_(* \"-\"??_);_(@_)");
    $excel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
    $excel->getActiveSheet()->getStyle('B1:B'.$counterCell)->getNumberFormat()->setFormatCode('0');

    $excel->getActiveSheet()->getPageSetup()->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_LETTER);
    $excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_PORTRAIT);
    $excel->getActiveSheet()->getPageSetup()->setFitToPage(true);
    $excel->getActiveSheet()->getPageSetup()->setFitToWidth(1);
    $excel->getActiveSheet()->getPageSetup()->setFitToHeight(0);
    $excel->setActiveSheetIndex(0);

    // Código nuevo que me solucionó el problema
    $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel5');
    $uniqid = uniqid();
    $objWriter->save('./assets/files/Inventario_' . $uniqid . '.xls');
    redirect(base_url('/assets/files/Inventario_' . $uniqid . '.xls'));
?>