<?php
	$this->load->library('fpdf');
	
	$GLOBALS['dataArray'] = array(
        'Empresa' => $configs['NombreEmpresa'],
        'Direccion' => $configs['DireccionEmpresa'],
        'Logo' => base_url($configs['LogoEmpresa'])
    );
	
	class PDF extends FPDF{
    
        function Header(){
            global $dataArray;
            $this->Image($dataArray['Logo'],250,5,25);
            $this->SetFont('Arial','B',15);
            $this->SetY(6);
            $this->Cell(0,8,utf8_decode('Reporte de Ganancias'),0,1,'C');
            $this->SetFont('Arial','B',12);
            $this->SetY(12);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Empresa'])),0,1,'C');
            $this->SetY(17);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Direccion'])),0,1,'C');
            $this->Ln(3);
            
            /*Header Tabla*/
            $this->Cell(50,8,'SKU',1,0,'C');
            $this->Cell(60,8,'Producto',1,0,'C');
            $this->Cell(30,8,'Transacciones',1,0,'C');
            $this->Cell(30,8,'Cantidad',1,0,'C');
            $this->Cell(30,8,'Ventas',1,0,'C');
            $this->Cell(30,8,'Costo',1,0,'C');
            $this->Cell(30,8,'Ganancia',1,1,'C');
            $this->SetFont('Arial','',11);
        }
        
        function Footer(){
            $this->SetY(-15);
            $this->SetFont('Arial','I',7);
            $this->Cell(200,6,utf8_decode('Pagina '.$this->PageNo().'/{nb}'),0,0,'L');
            $this->Cell(60,6,utf8_decode(gmdate('d-m-Y H:i:s', strtotime('- 6 hours'))),0,1,'R');
            $this->Cell(60,6,utf8_decode('Miracle v1.5 - Todos los Derechos Reservados 2012 - '.date('Y').' - Xypnos Soluciones Tecnologicas'),0,1,'L');
        }
    }
	
	$pdf = new PDF();
    $pdf->AliasNbPages(); 
    $pdf->setTitle('Reporte de Ganancias');
    $pdf->setAuthor('Miracle v1.5 - Xypnos');
    $pdf->AddPage('L','Letter');
    
    /*Cuerpo del Documento*/
	if(isset($ventas) && count($ventas) > 0):
		$totaltransacciones = 0;
		$totalcantidades = 0;
		$totalventas = 0;
		$totalcostos = 0;
        foreach($ventas as $venta):
            $pdf->Cell(50,8,utf8_decode(ucwords($venta->sku_presentacion)),1,0,'L');
			
			if($pdf->GetStringWidth($venta->desc_presentacion) >= 60){
				//$fontSize = 9;
				//$pdf->SetFontSize($fontSize -= 0.5);
				$H = $pdf->GetY();
				$pdf->MultiCell(60,4,utf8_decode(strtoupper(substr($venta->desc_presentacion,0,30)."...")),1,'L');
				$pdf->SetXY($pdf->GetX()+110,$H);
			}else{
			   $pdf->Cell(60,8,utf8_decode(strtoupper($venta->desc_presentacion)),1,0,'L');
			}
			//$pdf->SetFontSize(11);
			
            //$pdf->Cell(60,8,utf8_decode(ucwords($venta->desc_presentacion)),1,0,'L');
            $pdf->Cell(30,8,utf8_decode(ucwords($venta->transacciones)),1,0,'R');
            $pdf->Cell(30,8,utf8_decode(ucwords($venta->cantidades)),1,0,'R');
            $pdf->Cell(30,8,utf8_decode(ucwords($venta->ventas)),1,0,'R');
			if($venta->costo > 0){
				$pdf->SetFillColor(255, 255, 126);
				$pdf->Cell(30,8,number_format($venta->costo,2),1,0,'R');
			}else{
				$pdf->Cell(30,8,number_format($venta->costo,2),1,0,'R',true);	
			}
			if($venta->ventas - $venta->costo <= 0){
				$pdf->SetFillColor(255, 150, 150);
				$pdf->Cell(30,8,number_format($venta->ventas - $venta->costo,2),1,1,'R',true);	
			}else{
				$pdf->Cell(30,8,number_format($venta->ventas - $venta->costo,2),1,1,'R');				
			}
			$totaltransacciones+= $venta->transacciones;
			$totalcantidades+= $venta->cantidades;
			$totalventas+= $venta->ventas;
			$totalcostos+= $venta->costo;
        endforeach;
        $pdf->SetFont('Arial','B',12);
        $pdf->Cell(110,8,'Totales',1,0,'C');
        $pdf->Cell(30,8,(float)$totaltransacciones,1,0,'R');
        $pdf->Cell(30,8,(float)$totalcantidades,1,0,'R');
        $pdf->Cell(30,8,number_format($totalventas,2),1,0,'R');
        $pdf->Cell(30,8,number_format($totalcostos,2),1,0,'R');
        $pdf->Cell(30,8,number_format($totalventas - $totalcostos,2),1,0,'R');
    endif;
    
    /*Exportamos el PDF*/
    $pdf->Output('Reporte de Ganancias','I');
?>