<?php
	$this->load->library('fpdf');
	
	$GLOBALS['dataArray'] = array(
        'Empresa' => $configs['NombreEmpresa'],
        'Direccion' => $configs['DireccionEmpresa'],
        'Logo' => base_url($configs['LogoEmpresa']),
		'FechaDesde' => $fechadesde,
        'FechaHasta' => $fechahasta
    );

	class PDF extends FPDF{
    
        function Header(){
            global $dataArray;
			$fechadesde = new DateTime($dataArray['FechaDesde']);
			$fechahasta = new DateTime($dataArray['FechaHasta']);
            $this->Image($dataArray['Logo'],188,5,22);
            $this->SetFont('Arial','B',12);
            $this->SetY(6);
            $this->Cell(0,8,utf8_decode('Reporte de Caja Chica'),0,1,'C');
            $this->SetFont('Arial','B',9);
            $this->SetY(12);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Empresa'])),0,1,'C');
            $this->SetY(17);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Direccion'])),0,1,'C');
            $this->Ln(3);
			
			$this->SetFont('Arial','',9);
            $this->Cell(20,8,'Periodo',0,0,'L');
			$this->SetFont('Arial','B',9);
            $this->Cell(50,8,$fechadesde->format('d-m-Y H:i:s').' - '.$fechahasta->format('d-m-Y H:i:s'),0,1,'L');
			$this->Ln(3);
        }
        
        function Footer(){
            $this->SetY(-15);
            $this->SetFont('Arial','I',7);
            $this->Cell(135,6,utf8_decode('Pagina '.$this->PageNo().'/{nb}'),0,0,'L');
            $this->Cell(60,6,utf8_decode(gmdate('d-m-Y H:i:s', strtotime('- 6 hours'))),0,1,'R');
            $this->Cell(60,6,utf8_decode('Miracle v1.5 - Todos los Derechos Reservados 2012 - '.date('Y').' - Xypnos Soluciones Tecnologicas'),0,1,'L');
        }
    }
	
	$pdf = new PDF();
    $pdf->AliasNbPages(); 
    $pdf->setTitle('Reporte de Caja Chica');
    $pdf->setAuthor('Miracle v1.5 - Xypnos');
    $pdf->AddPage('P','Letter');
	
	$total = 0;
	$total_ingresos_gastos=0;
	$total_ingresos_docs=0;
	$show_total_ingresos=false;
	$show_total_ingresos_docs=false;
	
	$totalxgastos=0;
	$totalxingresos=0;
	$totalxingresossd=0;
	$totalxingresosfac=0;
	$totalxingresosccf=0;
	$totalxingresostick=0;
	$pdf->SetFont('Arial','B',9);
	if($ingresos_resumen){
		if(isset($gastosDataResumen) && count($gastosDataResumen)){
			$pdf->SetFont('Arial','B',9);
			$pdf->Cell(5,6,'',0,0,'L');
			$pdf->Cell(60,6,'GASTOS',0,1,'L');
			
			$pdf->SetFont('Arial','',9);
			$pdf->Cell(150,6,'Total Gastos',1,0,'L');
			$pdf->Cell(6,6,"$","TLB",0,'R');
			$pdf->Cell(40,6,"(".utf8_decode(ucwords(number_format($gastosDataResumen[0]->Total,2))).")","TRB",1,'R');
			$total-= $gastosDataResumen[0]->Total;
			$total_ingresos_gastos-= $gastosDataResumen[0]->Total;
			$show_total_ingresos=true;
			$pdf->Ln(10);
		}
		
		if(isset($ingresosDataResumen) && count($ingresosDataResumen)){
			$pdf->SetFont('Arial','B',9);
			$pdf->Cell(5,6,'',0,0,'L');
			$pdf->Cell(60,6,'INGRESOS',0,1,'L');
			
			$pdf->SetFont('Arial','',9);
			$pdf->Cell(150,6,'Total Ingresos',1,0,'L');
			$pdf->Cell(6,6,"$","TLB",0,'R');
			$pdf->Cell(40,6,utf8_decode(ucwords(number_format($ingresosDataResumen[0]->Total,2))),"TRB",1,'R');
			$total+= $ingresosDataResumen[0]->Total;
			$total_ingresos_gastos+= $ingresosDataResumen[0]->Total;
			$show_total_ingresos=true;
			$pdf->Ln(10);
		}
		
		if($show_total_ingresos){
			$pdf->SetFont('Arial','B',9);
			$pdf->Cell(150,6,'Total Ingresos y Gastos',"T",0,'L');
			$pdf->Cell(6,6,"$","T",0,'R');
			$pdf->Cell(40,6,utf8_decode(ucwords(number_format($total_ingresos_gastos,2))),"T",1,'R');
			$pdf->Ln(10);
		}
	}else{
		if(isset($gastosData) && count($gastosData)){
			$pdf->SetFont('Arial','B',9);
			$pdf->Cell(5,6,'',0,0,'L');
			$pdf->Cell(60,6,'GASTOS',0,1,'L');
			
			$pdf->Cell(160,6,'CONCEPTO',"LTB",0,'C');
			$pdf->Cell(36,6,'MONTO',"TRB",1,'C');
			$pdf->SetFont('Arial','',9);
			foreach($gastosData as $gasto):
				$pdf->Cell(40,6,$gasto->fecha_transaccion,0,0,'L');
				$pdf->Cell(120,6,$gasto->concepto_transaccion,0,0,'L');
				$pdf->Cell(6,6,"$",0,0,'C');
				$pdf->Cell(30,6,$gasto->monto_transaccion,0,1,'R');
				$total-= $gasto->monto_transaccion;
				$totalxgastos-= $gasto->monto_transaccion;
				$total_ingresos_gastos-= $gasto->monto_transaccion;
			endforeach;
			$pdf->Cell(160,6,'Total Gastos',"T",0,'L');
			$pdf->Cell(6,6,"$","T",0,'C');
			$pdf->Cell(30,6,"(".utf8_decode(ucwords(number_format($totalxgastos,2))).")","T",1,'R');
			$show_total_ingresos=true;
			$pdf->Ln(10); 
		}
		
		if(isset($ingresosData) && count($ingresosData)){
			$pdf->SetFont('Arial','B',9);
			$pdf->Cell(5,6,'',0,0,'L');
			$pdf->Cell(60,6,'INGRESOS',0,1,'L');
			
			$pdf->Cell(160,6,'CONCEPTO',"LTB",0,'C');
			$pdf->Cell(36,6,'MONTO',"TRB",1,'C');
			$pdf->SetFont('Arial','',9);
			foreach($ingresosData as $ingreso):
				$pdf->Cell(40,6,$ingreso->fecha_transaccion,0,0,'L');
				$pdf->Cell(120,6,$ingreso->concepto_transaccion,0,0,'L');
				$pdf->Cell(6,6,"$",0,0,'C');
				$pdf->Cell(30,6,$ingreso->monto_transaccion,0,1,'R');
				$total+= $ingreso->monto_transaccion;
				$totalxingresos+= $ingreso->monto_transaccion;
				$total_ingresos_gastos+= $ingreso->monto_transaccion;
			endforeach;
			$pdf->Cell(160,6,'Total Ingresos',"T",0,'L');
			$pdf->Cell(6,6,"$","T",0,'C');
			$pdf->Cell(30,6,utf8_decode(ucwords(number_format($totalxingresos,2))),"T",1,'R');
			$show_total_ingresos=true;
			$pdf->Ln(10); 
		}
		
		if($show_total_ingresos){
			$pdf->SetFont('Arial','B',9);
			$pdf->Cell(160,6,'Total Ingresos y Gastos',"T",0,'L');
			$pdf->Cell(6,6,"$","T",0,'C');
			$pdf->Cell(30,6,utf8_decode(ucwords(number_format($total_ingresos_gastos,2))),"T",1,'R');
			$pdf->Ln(10);
		}
	}
	
	if($ingresos_doc_resumen){
		if(isset($ingresosSDdataResumen) && count($ingresosSDdataResumen)){
			$pdf->SetFont('Arial','B',9);
			$pdf->Cell(5,6,'',0,0,'L');
			$pdf->Cell(60,6,'VENTAS SIN DOCUMENTO',0,1,'L');
			
			$pdf->SetFont('Arial','',9);
			$pdf->Cell(150,6,'Total Ventas sin Documento',1,0,'L');
			$pdf->Cell(6,6,"$","TLB",0,'R');
			$pdf->Cell(40,6,utf8_decode(ucwords(number_format($ingresosSDdataResumen[0]->Total,2))),"TRB",1,'R');
			$total+= $ingresosSDdataResumen[0]->Total;
			$total_ingresos_docs+= $ingresosSDdataResumen[0]->Total;
			$show_total_ingresos_docs=true;
			$pdf->Ln(10);
		}
		
		if(isset($ingresosFACdataResumen) && count($ingresosFACdataResumen)){
			$pdf->SetFont('Arial','B',9);
			$pdf->Cell(5,6,'',0,0,'L');
			$pdf->Cell(60,6,'VENTAS CON FACTURA',0,1,'L');
			
			$pdf->SetFont('Arial','',9);
			$pdf->Cell(150,6,'Total Ventas con Factura',1,0,'L');
			$pdf->Cell(6,6,"$","TLB",0,'R');
			$pdf->Cell(40,6,utf8_decode(ucwords(number_format($ingresosFACdataResumen[0]->Total,2))),"TRB",1,'R');
			$total+= $ingresosFACdataResumen[0]->Total;
			$total_ingresos_docs+= $ingresosFACdataResumen[0]->Total;
			$show_total_ingresos_docs=true;
			$pdf->Ln(10);
		}
		
		if(isset($ingresosCCFdataResumen) && count($ingresosCCFdataResumen)){
			$pdf->SetFont('Arial','B',9);
			$pdf->Cell(5,6,'',0,0,'L');
			$pdf->Cell(60,6,'VENTAS CON CCF',0,1,'L');
			
			$pdf->SetFont('Arial','',9);
			$pdf->Cell(150,6,'Total Ventas con CCF',1,0,'L');
			$pdf->Cell(6,6,"$","TLB",0,'R');
			$pdf->Cell(40,6,utf8_decode(ucwords(number_format($ingresosCCFdataResumen[0]->Total,2))),"TRB",1,'R');
			$total+= $ingresosCCFdataResumen[0]->Total;
			$total_ingresos_docs+= $ingresosCCFdataResumen[0]->Total;
			$show_total_ingresos_docs=true;
			$pdf->Ln(10);
		}
		
		if(isset($ingresosTICKdataResumen) && count($ingresosTICKdataResumen)){
			$pdf->SetFont('Arial','B',9);
			$pdf->Cell(5,6,'',0,0,'L');
			$pdf->Cell(60,6,'VENTAS CON TICKETS',0,1,'L');
			
			$pdf->SetFont('Arial','',9);
			$pdf->Cell(150,6,'Total Ventas con Tickets',1,0,'L');
			$pdf->Cell(6,6,"$","TLB",0,'R');
			$pdf->Cell(40,6,utf8_decode(ucwords(number_format($ingresosTICKdataResumen[0]->Total,2))),"TRB",1,'R');
			$total+= $ingresosTICKdataResumen[0]->Total;
			$total_ingresos_docs+= $ingresosTICKdataResumen[0]->Total;
			$show_total_ingresos_docs=true;
			$pdf->Ln(10);
		}
		
		if($show_total_ingresos_docs){
			$pdf->SetFont('Arial','B',9);
			$pdf->Cell(150,6,'Total Documentos',"T",0,'L');
			$pdf->Cell(6,6,"$","T",0,'R');
			$pdf->Cell(40,6,utf8_decode(ucwords(number_format($total_ingresos_docs,2))),"T",1,'R');
			$pdf->Ln(10);
		}
	}else{
		if(isset($ingresosSDdata) && count($ingresosSDdata)){
			$pdf->SetFont('Arial','B',9);
			$pdf->Cell(5,6,'',0,0,'L');
			$pdf->Cell(60,6,'VENTAS SIN DOCUMENTO',0,1,'L');
			
			$pdf->Cell(15,6,'DOC',"LTB",0,'C');
			$pdf->Cell(115,6,'CONCEPTO',"TB",0,'C');
			$pdf->Cell(30,6,'EXISTENCIA',"TRB",0,'C');
			$pdf->Cell(36,6,'MONTO',"TB",1,'C');
			$pdf->SetFont('Arial','',9);
			foreach($ingresosSDdata as $ingresosd):
				$pdf->Cell(15,6,$ingresosd->num_doc_salida,0,0,'L');
				$pdf->Cell(115,6,substr($ingresosd->desc_presentacion,0,60),0,0,'L');
				$totalproducto=number_format($ingresosd->cant_salida*$ingresosd->costo_salida,2);
				$pdf->Cell(30,6,(float)$ingresosd->exist_act_producto,0,0,'C');
				$pdf->Cell(6,6,"$",0,0,'C');
				$pdf->Cell(30,6,$totalproducto,0,1,'R');
				$total+= $totalproducto;
				$totalxingresossd+= $totalproducto;
				$total_ingresos_docs+= $totalproducto;
			endforeach;
			$pdf->Cell(160,6,'Total Ventas sin Documento',"T",0,'L');
			$pdf->Cell(6,6,"$","T",0,'C');
			$pdf->Cell(30,6,utf8_decode(ucwords(number_format($totalxingresossd,2))),"T",1,'R');
			$show_total_ingresos_docs=true;
			$pdf->Ln(10); 
		}
		
		if(isset($ingresosFACdata) && count($ingresosFACdata)){
			$pdf->SetFont('Arial','B',9);
			$pdf->Cell(5,6,'',0,0,'L');
			$pdf->Cell(60,6,'VENTAS CON FACTURA',0,1,'L');
			
			$pdf->Cell(15,6,'DOC',"LTB",0,'C');
			$pdf->Cell(115,6,'CONCEPTO',"TB",0,'C');
			$pdf->Cell(30,6,'EXISTENCIA',"TRB",0,'C');
			$pdf->Cell(36,6,'MONTO',"TB",1,'C');
			$pdf->SetFont('Arial','',9);
			foreach($ingresosFACdata as $ingresofac):
				$pdf->Cell(15,6,$ingresofac->num_doc_salida,0,0,'L');
				$pdf->Cell(115,6,substr($ingresofac->desc_presentacion,0,60),0,0,'L');
				$totalproducto=number_format($ingresofac->cant_salida*$ingresofac->costo_salida,2);
				$pdf->Cell(30,6,(float)$ingresofac->exist_act_producto,0,0,'C');
				$pdf->Cell(6,6,"$",0,0,'C');
				$pdf->Cell(30,6,$totalproducto,0,1,'R');
				$total+= $totalproducto;
				$totalxingresosfac+= $totalproducto;
				$total_ingresos_docs+= $totalproducto;
			endforeach;
			$pdf->Cell(160,6,'Total Ventas con Factura',"T",0,'L');
			$pdf->Cell(6,6,"$","T",0,'C');
			$pdf->Cell(30,6,utf8_decode(ucwords(number_format($totalxingresosfac,2))),"T",1,'R');
			$show_total_ingresos_docs=true;
			$pdf->Ln(10); 
		}
		
		if(isset($ingresosCCFdata) && count($ingresosCCFdata)){
			$pdf->SetFont('Arial','B',9);
			$pdf->Cell(5,6,'',0,0,'L');
			$pdf->Cell(60,6,'VENTAS CON CCF',0,1,'L');
			
			$pdf->Cell(15,6,'DOC',"LTB",0,'C');
			$pdf->Cell(115,6,'CONCEPTO',"TB",0,'C');
			$pdf->Cell(30,6,'EXISTENCIA',"TRB",0,'C');
			$pdf->Cell(36,6,'MONTO',"TB",1,'C');
			$pdf->SetFont('Arial','',9);
			foreach($ingresosCCFdata as $ingresoccf):
				$pdf->Cell(15,6,$ingresoccf->num_doc_salida,0,0,'L');
				$pdf->Cell(115,6,substr($ingresoccf->desc_presentacion,0,60),0,0,'L');
				$totalproducto=number_format(($ingresoccf->cant_salida*$ingresoccf->costo_salida)+(($ingresoccf->cant_salida*$ingresoccf->costo_salida)*0.13),2);
				$pdf->Cell(30,6,(float)$ingresoccf->exist_act_producto,0,0,'C');
				$pdf->Cell(6,6,"$",0,0,'C');
				$pdf->Cell(30,6,$totalproducto,0,1,'R');
				$total+= $totalproducto;
				$totalxingresosccf+= $totalproducto;
				$total_ingresos_docs+= $totalproducto;
			endforeach;
			$pdf->Cell(160,6,'Total Ventas con CCF',"T",0,'L');
			$pdf->Cell(6,6,"$","T",0,'C');
			$pdf->Cell(30,6,utf8_decode(ucwords(number_format($totalxingresosccf,2))),"T",1,'R');
			$show_total_ingresos_docs=true;
			$pdf->Ln(10); 
		}
		
		if(isset($ingresosTICKdata) && count($ingresosTICKdata)){
			$pdf->SetFont('Arial','B',9);
			$pdf->Cell(5,6,'',0,0,'L');
			$pdf->Cell(60,6,'VENTAS CON TICKETS',0,1,'L');
			
			$pdf->Cell(15,6,'DOC',"LTB",0,'C');
			$pdf->Cell(115,6,'CONCEPTO',"TB",0,'C');
			$pdf->Cell(30,6,'EXISTENCIA',"TRB",0,'C');
			$pdf->Cell(36,6,'MONTO',"TB",1,'C');
			$pdf->SetFont('Arial','',9);
			foreach($ingresosTICKdata as $ingresotick):
				$pdf->Cell(15,6,$ingresotick->num_doc_salida,0,0,'L');
				$pdf->Cell(115,6,substr($ingresotick->desc_presentacion,0,60),0,0,'L');
				$totalproducto=number_format($ingresotick->cant_salida*$ingresotick->costo_salida,2);
				$pdf->Cell(30,6,(float)$ingresotick->exist_act_producto,0,0,'C');
				$pdf->Cell(6,6,"$",0,0,'C');
				$pdf->Cell(30,6,$totalproducto,0,1,'R');
				$total+= $totalproducto;
				$totalxingresostick+= $totalproducto;
				$total_ingresos_docs+= $totalproducto;
			endforeach;
			$pdf->Cell(160,6,'Total Ventas con Tickets',"T",0,'L');
			$pdf->Cell(6,6,"$","T",0,'C');
			$pdf->Cell(30,6,utf8_decode(ucwords(number_format($totalxingresostick,2))),"T",1,'R');
			$show_total_ingresos_docs=true;
			$pdf->Ln(10); 
		}
		
		if($show_total_ingresos_docs){
			$pdf->SetFont('Arial','B',9);
			$pdf->Cell(160,6,'Total Documentos',"T",0,'L');
			$pdf->Cell(6,6,"$","T",0,'C');
			$pdf->Cell(30,6,utf8_decode(ucwords(number_format($total_ingresos_docs,2))),"T",1,'R');
			$pdf->Ln(10);
		}
	}
	
	$pdf->SetFont('Arial','B',9);
	$pdf->Cell(196,2,'',"T",1,'L');
	$pdf->Cell(160,6,'Total',"T",0,'L');
	$pdf->Cell(6,6,"$","T",0,'C');
	$pdf->Cell(30,6,utf8_decode(ucwords(number_format($total,2))),"T",1,'R');
	
	/*Exportamos el PDF*/
    $pdf->Output('Reporte de Caja Chica','I');
?>