<?php
	$this->load->library('printer');
	$this->load->library('enletras');
	
	$phpPrinter = new Printer();
	$phpInletters = new EnLetras();
	
	$phpPrinter->resetAcum();
	$acum = 0;
	
	/*Init*/
	switch($copias):
		case "0":
			$printer = printer_open("EPSON TM-U950 Receipt");
		break;
		case "1":
			$printer = printer_open("EPSON TM-U950 Receipt Single");
		break;
		case "2":
			$printer = printer_open("EPSON TM-U950 Journal");
		break;
	endswitch;

	printer_set_option($printer, PRINTER_MODE, 'RAW');

	printer_start_doc($printer, 'Ticket Numero: '.$doc_numero);

	printer_start_page($printer);
	
	/*Body*/
	
	$font = printer_create_font('Arial', 10, 8, PRINTER_FW_BOLD, false, false, false, 0);	
	printer_select_font($printer, $font);
	
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode($nombre_empresa)),28),1,$printer,$acum,10,10);
	
	printer_delete_font($font);
	
	$font = printer_create_font('Arial', 10, 8, PRINTER_FW_THIN, false, false, false, 0);	
	printer_select_font($printer, $font);
	
	$phpPrinter->tabPrinter($acum,10);
	
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode($rsocial_empresa)),28),1,$printer,$acum,10,10);
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode($direcion_empresa)),28),1,$printer,$acum,10,10);
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('NRC: '.$nrc_empresa)),28),1,$printer,$acum,10,10);
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('NIT: '.$nit_empresa)),28),1,$printer,$acum,10,10);
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('Autorizacion segun Resolucion')),28),1,$printer,$acum,10,10);
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('No '.$doc_resolucion)),28),1,$printer,$acum,10,10);
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('Del '.$doc_desde)),28),1,$printer,$acum,10,10);
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('Al '.$doc_hasta)),28),1,$printer,$acum,10,10);
	$phpPrinter->printString($phpPrinter->cutString(utf8_decode('TICKET '.$doc_numero),28),1,$printer,$acum,10,10);
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('Caja: '.$caja)),28),1,$printer,$acum,10,10);
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('Vendedor: '.$vendedor)),28),1,$printer,$acum,10,10);
	
	$phpPrinter->tabPrinter($acum,10);
	
	$phpPrinter->printString(strtoupper(utf8_decode('fecha: ')),2,$printer,$acum,10,10,0);
	$phpPrinter->printString(strtoupper(utf8_decode($fecha)),2,$printer,$acum,10,0,80);
	
	$phpPrinter->tabPrinter($acum,10);
	
	$phpPrinter->printString(strtoupper(utf8_decode('Cant')),2,$printer,$acum,10,10,0);
	$phpPrinter->printString(strtoupper(utf8_decode('Desc')),2,$printer,$acum,10,0,70);
	$phpPrinter->printString(strtoupper(utf8_decode('P/U')),2,$printer,$acum,10,0,200);
	$phpPrinter->printString(strtoupper(utf8_decode('Total')),2,$printer,$acum,10,0,270);
	
	$phpPrinter->tabPrinter($acum,5);
	
	foreach($productos_normal as $producto){
		$phpPrinter->printString($producto->cant,2,$printer,$acum,10,10,0);
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode(addslashes($producto->desc))),12),2,$printer,$acum,10,0,50);
		$phpPrinter->printString($producto->costo,2,$printer,$acum,10,0,200);
		$phpPrinter->printString($producto->cant * $producto->costo,2,$printer,$acum,10,0,270);
		$phpPrinter->tabPrinter($acum,3);
	}
	$phpPrinter->printString("______________________________",2,$printer,$acum,10,10,0);
	$phpPrinter->printString("G=Gravado E=Exento NS=No Sujeto",2,$printer,$acum,10,10,0);
	$phpPrinter->tabPrinter($acum,20);
	
	$phpPrinter->printString(strtoupper(utf8_decode('TOTAL GRAVADO')),2,$printer,$acum,10,10,50);
	$phpPrinter->printString($totales['totalGrabadas'],2,$printer,$acum,10,0,270);
	$phpPrinter->printString(strtoupper(utf8_decode('TOTAL EXENTO')),2,$printer,$acum,10,10,50);
	$phpPrinter->printString($totales['totalExento'],2,$printer,$acum,10,0,270);
	$phpPrinter->printString(strtoupper(utf8_decode('TOTAL NO SUJETO')),2,$printer,$acum,10,10,50);
	$phpPrinter->printString($totales['totalNS'],2,$printer,$acum,10,0,270);
	$phpPrinter->printString(strtoupper(utf8_decode('TOTAL')),2,$printer,$acum,10,10,50);
	$phpPrinter->printString($totales['totalTotal'],2,$printer,$acum,10,0,270);
	$phpPrinter->printString(strtoupper(utf8_decode('EFECTIVO')),2,$printer,$acum,10,10,50);
	$phpPrinter->printString($efectivo,2,$printer,$acum,10,0,270);
	$phpPrinter->printString(strtoupper(utf8_decode('CAMBIO')),2,$printer,$acum,10,10,50);
	$phpPrinter->printString(($efectivo - $totales['totalTotal']),2,$printer,$acum,10,0,270);
	
	$phpPrinter->tabPrinter($acum,10);
	
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('F:__________________________')),28),1,$printer,$acum,10,10);
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode($cliente)),28),1,$printer,$acum,10,10);

	if($dui_cliente!=""):
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('DUI: '.$dui_cliente)),28),1,$printer,$acum,10,10);
	endif;
	if($nit_cliente!=""):
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('NIT: '.$nit_cliente)),28),1,$printer,$acum,10,10);
	endif;
	if($nrc_cliente!=""):
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('NRC: '.$nrc_cliente)),28),1,$printer,$acum,10,10);
	endif;
	$phpPrinter->tabPrinter($acum,10);
	
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode($mensaje_ticket)),28),1,$printer,$acum,10,10);
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode("Ref:".$referencia)),28),1,$printer,$acum,10,10);
	
	printer_delete_font($font);
	
	printer_end_page($printer);

	printer_end_doc($printer);

	printer_close($printer);
?>