<?php
	$this->load->library('printer');
	$this->load->library('enletras');
	
	$phpPrinter = new Printer();
	$phpInletters = new EnLetras();
	
	$phpPrinter->resetAcum();
	$acum = 0;
	
	/*Init*/
	$printer = printer_open("EPSON LX-350");

	printer_set_option($printer, PRINTER_MODE, 'RAW');

	printer_start_doc($printer, 'Factura Numero: '.$doc_numero);

	printer_start_page($printer);
	
	/*Body*/
	
	$font = printer_create_font('Arial', 9, 7, PRINTER_FW_THIN, false, false, false, 0);	
	printer_select_font($printer, $font);
	
	/*Ghost*/
	$phpPrinter->printString(strtoupper(utf8_decode(substr(" ",0,24))),2,$printer,$acum,13,11,70);
	$phpPrinter->tabPrinter($acum,95);
	
	//$fecha = explode("-",$fecha);
	//$fechadia = explode(" ",$fecha[2]);
	$phpPrinter->printString($fecha,2,$printer,$acum,15,11,185);
	$phpPrinter->printString(strtoupper(utf8_decode(substr($nit_cliente,0,20))),2,$printer,$acum,13,0,520);
	$phpPrinter->tabPrinter($acum,8);
	$phpPrinter->printString(strtoupper(utf8_decode($cliente)),2,$printer,$acum,13,11,200);
	$phpPrinter->tabPrinter($acum,5);
	$phpPrinter->printString(strtoupper(utf8_decode(substr($direccion_cliente,0,50))),2,$printer,$acum,13,11,210);
	$phpPrinter->tabPrinter($acum,5);
	$phpPrinter->printString(strtoupper(utf8_decode(substr($vendedor,0,50))),2,$printer,$acum,13,11,280);
	$phpPrinter->tabPrinter($acum,27);
	
	/*Body*/
	foreach($productos_normal as $producto){
		$phpPrinter->printString(number_format($producto->cant,1),2,$printer,$acum,13,11,120);
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode(addslashes($producto->desc))),26),2,$printer,$acum,13,0,190,17);
		$phpPrinter->printString(number_format($producto->costo,2),2,$printer,$acum,13,0,460);
		$phpPrinter->printString(number_format($producto->cant * $producto->costo,2),2,$printer,$acum,13,0,605);
		$phpPrinter->tabPrinter($acum,7);
	}
	
	/*Footer*/
	printer_draw_text($printer,$phpInletters->ValorEnLetras($totales['totalTotal'],""), 150, 432);
	printer_draw_text($printer,"Ref:".$referencia." - Casa Matriz", 130, 455);
	printer_draw_text($printer,number_format($totales['totalGrabadas'],2), 605, 430);
	printer_draw_text($printer,number_format("0.00",2), 605, 445);
	printer_draw_text($printer,number_format($totales['totalGrabadas'],2), 605, 465);
	printer_draw_text($printer,number_format($totales['totalExento'],2), 605, 480);
	printer_draw_text($printer,number_format($totales['totalNS'],2), 605, 495);
	printer_draw_text($printer,number_format($totales['totalTotal'],2), 605, 510);
	
	printer_delete_font($font);
	
	printer_end_page($printer);

	printer_end_doc($printer);

	printer_close($printer);
?>