<?php
	$this->load->library('printer');
	$this->load->library('enletras');
	
	$phpPrinter = new Printer();
	$phpInletters = new EnLetras();
	
	$phpPrinter->resetAcum();
	$acum = 0;
	
	/*Init*/
	$printer = printer_open("EPSON LX-350");

	printer_set_option($printer, PRINTER_MODE, 'RAW');

	printer_start_doc($printer, 'Factura Numero: '.$doc_numero);

	printer_start_page($printer);
	
	/*Body*/
	
	$font = printer_create_font('Arial', 9, 7, PRINTER_FW_THIN, false, false, false, 0);	
	printer_select_font($printer, $font);
	
	/*Ghost*/
	$phpPrinter->printString(strtoupper(utf8_decode(substr(" ",0,24))),2,$printer,$acum,13,11,70);
	$phpPrinter->tabPrinter($acum,130);
	
	//$fecha = explode("-",$fecha);
	//$fechadia = explode(" ",$fecha[2]);
	$phpPrinter->printString($fecha,2,$printer,$acum,13,11,500);
	$phpPrinter->tabPrinter($acum,8);
	$phpPrinter->printString(strtoupper(utf8_decode($cliente)),2,$printer,$acum,13,11,200);
	$phpPrinter->tabPrinter($acum,5);
	$phpPrinter->printString(strtoupper(utf8_decode(substr($direccion_cliente,0,100))),2,$printer,$acum,13,11,210);
	$phpPrinter->tabPrinter($acum,26);
	
	/*Body*/
	foreach($productos_normal as $producto){
		$phpPrinter->printString(number_format($producto->cant,1),2,$printer,$acum,13,11,120);
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode(addslashes($producto->desc))),26),2,$printer,$acum,13,0,185,15);
		$phpPrinter->printString(number_format($producto->costo,2),2,$printer,$acum,13,0,525);
		$phpPrinter->printString(number_format($producto->cant * $producto->costo,2),2,$printer,$acum,13,0,605);
		$phpPrinter->tabPrinter($acum,6);
	}
	
	/*Footer*/
	printer_draw_text($printer,$phpInletters->ValorEnLetras($totales['totalTotal'],""), 190, 515);
	printer_draw_text($printer,"Ref:".$referencia." - Casa Matriz", 190, 530);
	printer_draw_text($printer,"Total:", 525, 515);
	printer_draw_text($printer,number_format($totales['totalGrabadas'],2), 605, 515);
	
	printer_delete_font($font);
	
	printer_end_page($printer);

	printer_end_doc($printer);

	printer_close($printer);
?>