<?php
class Transacciones extends CI_Controller{
	function __construct(){
		parent::__construct();
		$this->is_logged_in();
		$this->session_ = $this->session->userdata('userInfo');
		$this->caja=$this->get_caja($this->session_['hostdir']);
		$this->permisos=$this->Generic_model->get('usuarios','permisos_usuario',array('id_usuario'=>$this->session_['userid']));
		$this->permisos=unserialize(base64_decode($this->permisos[0]->permisos_usuario));
		/*usuario*/
		$this->usuario=$this->Generic_model->get('usuarios','nombre_usuario as nombre,username_usuario as username, thumb_usuario as thumbnail',array('id_usuario'=>$this->session_['userid']));
		$this->usuario=$this->usuario[0];
	}
	/**/
	function index(){echo "Transacciones! ".$this->session_['tienda'];}
	/*------------------------- FACTURACION ----------------------*/
	function facturacion(){
		$UIData['user_info']=$this->usuario;
		$UIData['main_view']="transacciones_facturacion_view";
		$UIData['section_title']="Facturaci&oacute;n";
		$UIData['jsfiles']=array(
			"miracle.transacciones.tools",
			"miracle.key",
			"miracle.transacciones_facturacion_app",
			"miracle.ventas",
			"miracle.devoluciones",
			"miracle.transacciones_devolucion_app",
			"miracle.transacciones_cortes_app",
			"miracle.clientes",
			"miracle.clientes_lista_mini.min",
			"miracle.productos_inventario_buscar",
			"miracle.transacciones_pago_credito_app");
		$UIData['plugins']=array(
			array(
				"nombre"=>"datatables",
				"css"=> array('dataTables.bootstrap','dataTables.responsive','dataTables.tableTools.min'),
				"js"=> array('jquery.dataTables','dataTables.bootstrap.min','dataTables.responsive','dataTables.tableTools.min')
			),
			array(
				"nombre"=>"chosen",
				"css"=> array('chosen'),
				"js"=> array('chosen.jquery')
			),
			array(
				"nombre"=>"iCheck",
				"css"=>array('custom'),
				"js"=>array('icheck.min')
			),
			array(
				"nombre"=>"datapicker",
				"css"=>array('datepicker3'),
				"js"=>array('bootstrap-datepicker','locales/bootstrap-datepicker.es')
			),
			array(
				"nombre"=>"jquery_form",
				"js"=> array('jquery.form.min')
			),
			array(
				"nombre"=>"input-mask",
				"js"=> array('jquery.inputmask')
			)
		);
		if($this->caja){
			/*Ultimos cortes*/
			$lastCorteXI=$this->Generic_model->get('cortes','fecha_corte as fecha',array('id_caja'=>$this->caja->id_caja,'tipo_corte'=>0),array('fecha_corte'=>'DESC'),'','',1);
			$lastCorteXI=$lastCorteXI[0];
			if(isset($lastCorteXI->fecha)){$lastCorteXI=$lastCorteXI->fecha;}else{$lastCorteXI='N/A';}
			$lastCorteXP=$this->Generic_model->get('cortes','fecha_corte as fecha',array('id_caja'=>$this->caja->id_caja,'tipo_corte'=>1),array('fecha_corte'=>'DESC'),'','',1);
			$lastCorteXP=$lastCorteXP[0];
			if(isset($lastCorteXP->fecha)){$lastCorteXP=$lastCorteXP->fecha;}else{$lastCorteXP='N/A';}
			$lastCorteZ=$this->Generic_model->get('cortes','fecha_corte as fecha',array('id_caja'=>$this->caja->id_caja,'tipo_corte'=>2),array('fecha_corte'=>'DESC'),'','',1);
			$lastCorteZ=$lastCorteZ[0];
			if(isset($lastCorteZ->fecha)){$lastCorteZ=$lastCorteZ->fecha;}else{$lastCorteZ='N/A';}
			$UIData['caja']=$this->caja;
			$UIData['lastCorteZ']=$lastCorteZ;
			$UIData['lastCorteXI']=$lastCorteXI;
			$UIData['lastCorteXP']=$lastCorteXP;
		}
		
		$UIData['app_facturacion_window_mode']=$this->Generic_model->get('configuraciones','valor_config',array('campo_config'=>'app_facturacion_window_mode'));
		$UIData['app_facturacion_window_mode']=intval($UIData['app_facturacion_window_mode'][0]->valor_config);
		
		$this->load->view('template', $UIData);
	}
		/*------- APLICACION DE  VENTA/FACTURACION-------*/
		function facturacionapp(){
			if($this->input->get("windowmode") && $this->input->get("windowmode")=="popup"){
				$template="template_popup";
			}else{
				$UIDataWindow["close_button"]=true;
				$UIDataWindow["id"]="facturacion-app-modal";
				$template="template_modal";
			}
							
			if(!$this->caja){/*Validacion de caja*/
				$UIDataWindow["content_view"]="error_nocaja_view";
				$UIDataWindow["title"]="Error: Caja desconocida";
			}else{
				if($this->caja->estado_caja==0){/*Validacion de estado de caja*/
					$UIDataWindow["content_view"]="error_caja_inactiva_view";
					$UIDataWindow["title"]="Error: Caja inactiva";
				}else{
					$UIDataWindow["title"]="Facturaci&oacute;n";
					if(!filter_var($this->permisos['facturacion']['transacciones-facturacion'],FILTER_VALIDATE_BOOLEAN)){/*Validacion de estado de permiso*/
						$UIDataWindow['content_view']="error_noacceso_view";
					}else{
						$UIDataWindow["content_view"]="transacciones_facturacion_app_view";
						$UIDataWindow["caja"]=$this->caja->id_caja;
						$UIDataWindow["clientes"]=$this->Generic_model->get('clientes','id_cliente,nombre_cliente,razonsocial_cliente,clasificacion_cliente,credito_cliente','',array('nombre_cliente'=>'ASC'));
						/*Cargar Información*/
						$ventaId=$this->input->get('venta');
						$ventatempId=$this->input->get('ventatrans');
						$cotizacionId=$this->input->get('cotizacion');
						if($ventaId || $ventatempId || $cotizacionId){
							$info=array();
							if($ventatempId){
								$trans="ventatemp";
								$id=$ventatempId;
							}
							if($cotizacionId){
								$trans="cotizacion";
								$id=$cotizacionId;
							}
							$transaccion=$this->cargartransaccion($trans,$id,false);
							$UIDataWindow["load_info"]=(object)$transaccion["load_info"];
							$UIDataWindow["load_productos"]=(object)$transaccion["load_productos"];
						}
						/*USUARIOS*/
						$UIDataWindow["usuarios"]=$this->Generic_model->get("usuarios","*",array("estado_usuario"=>0,"vendedor_usuario"=>1));
						$UIDataWindow["productos"]=$this->Generic_model->get("presentaciones","*",array("estado_presentacion"=>1));
						/*Modo de ventana*/
						if($this->input->get("windowmode") && $this->input->get("windowmode")=="popup"){
							$template="template_popup";
							$UIDataWindow['jsfiles']=array(
								"miracle.transacciones.tools",
								"miracle.key",
								"miracle.transacciones_facturacion_app",
								"miracle.ventas",
								"miracle.clientes",
								"miracle.clientes_lista_mini.min",
								"miracle.productos_inventario_buscar",
							);
							$UIDataWindow['plugins']=array(
								array(
									"nombre"=>"iCheck",
									"css"=>array('custom'),
									"js"=>array('icheck.min')
								),
								array(
									"nombre"=>"datapicker",
									"css"=>array('datepicker3'),
									"js"=>array('bootstrap-datepicker','locales/bootstrap-datepicker.es')
								),
								array(
									"nombre"=>"input-mask",
									"js"=> array('jquery.inputmask')
								),
								array(
									"nombre"=>"jquery_form",
									"js"=> array('jquery.form.min')
								),
							);
						}else{
							$UIDataWindow["close_button"]=true;
							$UIDataWindow["classes"]="modal-lg";
							$UIDataWindow["id"]="facturacion-app-modal";
							$template="template_modal";
						}
					}
				}
			}
			$this->load->view($template,$UIDataWindow);
		}
			/*---------- CARGAR TRANSACCION ---------*/
			function cargartransaccion($transacion=null,$id=null,$encode=true){
				if(!$transacion && !$id){
					$transacion=$this->input->get("transaccion");
					$id=$this->input->get("id");
				}
				$str_query=$id;
				switch($transacion){				
					case "ventatemp":
						$str_query="T-".$id;
						$selec="'ventatemp' as transaccion,ventas_trans.id_venta_trans as id,ventas_trans.id_cliente as cliente_id,ventas_trans.nombre_cliente as cliente_nombre,clientes.credito_cliente as cliente_credito,clientes.clasificacion_cliente as cliente_clasificacion,ventas_trans.dui_cliente as cliente_dui,ventas_trans.nit_cliente as cliente_nit,ventas_trans.nrc_cliente as cliente_nrc";
						$selec.=",ventas_trans.cobro_venta_trans as venta_condicion,ventas_trans.documento_venta_trans as venta_doc,ventas_trans.id_vendedor as  venta_vendedor";
						$sourceInfo=$this->Generic_model->get('ventas_trans',$selec,array('id_venta_trans'=>$id),'','',array('clientes'=>'clientes.id_cliente=ventas_trans.id_cliente, LEFT'));
						$sourceInfo=$sourceInfo[0];
						$productos=$this->Generic_model->get('productosxventastrans','productos.id_producto as id,presentaciones.sku_presentacion as sku,presentaciones.id_presentacion as id_pre,presentaciones.unidades_representativas as uequiv,productos.tipo_producto as tipo_producto,productos.producto_interno as interno,presentaciones.desc_presentacion as nombre,productos.tipo_venta as tipo,productosxventastrans.cantidad_producto as cant,productosxventastrans.precio_producto as precio,0 as descuento,presentaciones.ref_presentacion as ref',array('id_venta_trans'=>$id),'','',array('presentaciones'=>'presentaciones.id_presentacion=productosxventastrans.id_presentacion','productos'=>'productos.id_producto=productosxventastrans.id_producto'));
					break;
					case "cotizacion":
						$str_query="C-".$id;
						$selec="'cotizacion' as transaccion,cotizaciones.id_cotizacion as id,cotizaciones.id_cliente as cliente_id,clientes.nombre_cliente as cliente_nombre,clientes.credito_cliente as cliente_credito,clientes.clasificacion_cliente as cliente_clasificacion,clientes.dui_cliente as cliente_dui,clientes.nit_cliente as cliente_nit,clientes.ncr_cliente as cliente_nrc,notas_cotizacion as cotizacion_notas,firma_cotizacion as cotizacion_firma";
						$selec.=",cotizaciones.id_vendedor as  venta_vendedor";
						$sourceInfo=$this->Generic_model->get('cotizaciones',$selec,array('id_cotizacion'=>$id),'','',array('clientes'=>'clientes.id_cliente = cotizaciones.id_cliente, LEFT'));
						$sourceInfo=$sourceInfo[0];
						$productos=$this->Generic_model->get('productosxcotizacion','productos.id_producto as id,presentaciones.sku_presentacion as sku,presentaciones.id_presentacion as id_pre,presentaciones.unidades_representativas as uequiv,productos.tipo_producto as tipo_producto,productos.producto_interno as interno,presentaciones.desc_presentacion as nombre,productos.tipo_venta as tipo,productosxcotizacion.cantidad_producto as cant,productosxcotizacion.precio_producto as precio',array('productosxcotizacion.id_cotizacion'=>$id),'','',array('presentaciones'=>'presentaciones.id_presentacion=productosxcotizacion.id_presentacion','productos'=>'productos.id_producto=productosxcotizacion.id_producto'));
					break;
					case "venta":
						$str_query="V-".$id;
						$selec="'venta' as transaccion,ventas.id_venta as id,ventas.id_cliente as cliente_id,ventas.nombre_cliente as cliente_nombre,clientes.credito_cliente as cliente_credito,clientes.clasificacion_cliente as cliente_clasificacion,ventas.dui_cliente as cliente_dui,ventas.nit_cliente as cliente_nit,ventas.nrc_cliente as cliente_nrc";
						$selec.=",ventas.cobro_venta as venta_condicion,ventas.documento_venta as venta_doc,ventas.id_vendedor as venta_vendedor,descuento_venta as descuento,ventas.efectivo_venta as efectivo,ventas.pos_venta as pos";
						$sourceInfo=$this->Generic_model->get('ventas',$selec,array('id_venta'=>$id),'','',array('clientes'=>'clientes.id_cliente=ventas.id_cliente, LEFT'));
						$sourceInfo=$sourceInfo[0];
						$productos=$this->Generic_model->get('salida_productos','productos.id_producto as id,presentaciones.sku_presentacion as sku,presentaciones.id_presentacion as id_pre,presentaciones.unidades_representativas as uequiv,productos.tipo_producto as tipo_producto,productos.producto_interno as interno,presentaciones.desc_presentacion as nombre,productos.tipo_venta as tipo,salida_productos.cant_salida as cant,salida_productos.costo_salida as precio,salida_productos.descuento_salida as descuento,presentaciones.ref_presentacion as ref',array('id_venta'=>$id),'','',array('presentaciones'=>'presentaciones.id_presentacion=salida_productos.id_presentacion','productos'=>'productos.id_producto=salida_productos.id_producto'));
					break;
					case "ventafull": /*Incluye serie y numero de documento, cajero y vendedor completos e info de caja*/
						$str_query="VF-".$id;
						$selec="'venta' as transaccion,ventas.id_venta as id,ventas.fecha_venta as venta_fecha,ventas.id_cliente as cliente_id,ventas.nombre_cliente as cliente_nombre,clientes.credito_cliente as cliente_credito,clientes.clasificacion_cliente as cliente_clasificacion,ventas.dui_cliente as cliente_dui,ventas.nit_cliente as cliente_nit,ventas.nrc_cliente as cliente_nrc,ventas.estado_venta as venta_estado";
						$selec.=",ventas.cobro_venta as venta_condicion,ventas.forma_pago_venta as venta_forma_pago,ventas.estado_cobro as venta_estado_cobro,transaccionesxcredito.id_credito as venta_credito_id,ventas.documento_venta as venta_doc,ventas.num_documento_venta as venta_numdoc,ventas.id_resolucion as venta_seriedoc_id,resoluciones_caja.serie_autorizada as venta_seriedoc,ventas.id_vendedor as venta_vendedor,ventas.tipo_venta as venta_tipo,ventas.origen_venta as venta_origen,ventas.descargo_venta as venta_descargo";
						$selec.=",vendedor.nombre_usuario as venta_vendedor_nombre,ventas.id_cajero as venta_cajero,cajero.nombre_usuario as venta_cajero_nombre,cajas.id_caja as venta_caja,cajas.nombre_caja as venta_caja_nombre,ventas.efectivo_venta as efectivo,ventas.pos_venta as pos";
						$sourceInfo=$this->Generic_model->get('ventas',$selec,array('ventas.id_venta'=>$id),'','',array('clientes'=>'clientes.id_cliente=ventas.id_cliente, LEFT','resoluciones_caja'=>'resoluciones_caja.id_resolucion=ventas.id_resolucion, LEFT',"transaccionesxcredito"=>"transaccionesxcredito.id_venta=ventas.id_venta,LEFT",'usuarios as vendedor'=>'vendedor.id_usuario=ventas.id_vendedor, LEFT','usuarios as cajero'=>'cajero.id_usuario=ventas.id_cajero,LEFT','cajas'=>'cajas.id_caja=ventas.id_caja, LEFT'));
						$sourceInfo=$sourceInfo[0];
						$productos=$this->Generic_model->get('salida_productos','productos.id_producto as id,presentaciones.sku_presentacion as sku,presentaciones.id_presentacion as id_pre,presentaciones.unidades_representativas as uequiv,productos.tipo_producto as tipo_producto,productos.producto_interno as interno,presentaciones.desc_presentacion as nombre,productos.tipo_venta as tipo,salida_productos.cant_salida as cant,salida_productos.costo_salida as precio,salida_productos.descuento_salida as descuento',array('id_venta'=>$id),'','',array('presentaciones'=>'presentaciones.id_presentacion=salida_productos.id_presentacion','productos'=>'productos.id_producto=salida_productos.id_producto'));
					break;
				}
				
				if(count($productos)>0){
					foreach($productos as $producto){
						/*Verificar existencia*/
						$existencia=$this->Generic_model->get("productos","exist_act_producto as existencia",array("id_producto"=>$producto->id));
						$existencia=$existencia[0];
						$producto->existencia=$existencia->existencia;
						/*Ajuste para clientes exentos*/
						if(isset($sourceInfo->cliente_clasificacion) && (int)$sourceInfo->cliente_clasificacion==4){
							if($producto->tipo==0){
								$producto->tipo=3;
							}
						}
					}
				}
				
				$info["str_query"]=$str_query;
				$info["transaccion"]=(isset($sourceInfo->transaccion) && $sourceInfo->transaccion!=null?$sourceInfo->transaccion:null);
				$info["id_transaccion"]=(isset($sourceInfo->id) && $sourceInfo->id!=null?$sourceInfo->id:null);
				$info["cliente_nombre"]=(isset($sourceInfo->cliente_nombre) && $sourceInfo->cliente_nombre!=null?$sourceInfo->cliente_nombre:"");
				$info["cliente_id"]=(isset($sourceInfo->cliente_id) && $sourceInfo->cliente_id!=null?$sourceInfo->cliente_id:null);
				$info["cliente_credito"]=(isset($sourceInfo->cliente_credito) && $sourceInfo->cliente_credito!=null?$sourceInfo->cliente_credito:'');
				$info["cliente_clasificacion"]=(isset($sourceInfo->cliente_clasificacion) && $sourceInfo->cliente_clasificacion!=null?$sourceInfo->cliente_clasificacion:'');
				$info["cliente_dui"]=(isset($sourceInfo->cliente_dui) && $sourceInfo->cliente_dui!=null?$sourceInfo->cliente_dui:'');
				$info["cliente_nit"]=(isset($sourceInfo->cliente_nit) && $sourceInfo->cliente_nit!=null?$sourceInfo->cliente_nit:'');
				$info["cliente_nrc"]=(isset($sourceInfo->cliente_nrc) && $sourceInfo->cliente_nrc!=null?$sourceInfo->cliente_nrc:'');
				$info["venta_condicion"]=(isset($sourceInfo->venta_condicion) && $sourceInfo->venta_condicion!=null?$sourceInfo->venta_condicion:null);
				$info["venta_forma_pago"]=(isset($sourceInfo->venta_forma_pago) && $sourceInfo->venta_forma_pago!=null?$sourceInfo->venta_forma_pago:null);
				$info["venta_estado_cobro"]=(isset($sourceInfo->venta_estado_cobro) && $sourceInfo->venta_estado_cobro!=null?$sourceInfo->venta_estado_cobro:null);
				$info["venta_credito_id"]=(isset($sourceInfo->venta_credito_id) && $sourceInfo->venta_credito_id!=null?$sourceInfo->venta_credito_id:null);
				$info["venta_fecha"]=(isset($sourceInfo->venta_fecha) && $sourceInfo->venta_fecha!=null?$sourceInfo->venta_fecha:null);
				$info["venta_fecha_format"]=(isset($sourceInfo->venta_fecha) && $sourceInfo->venta_fecha!=null?date("d-m-Y H:i:s",strtotime($sourceInfo->venta_fecha)):null);
				$info["venta_doc"]=(isset($sourceInfo->venta_doc) && $sourceInfo->venta_doc!=null?$sourceInfo->venta_doc:null);
				$info["venta_seriedoc"]=(isset($sourceInfo->venta_seriedoc) && $sourceInfo->venta_seriedoc!=null?$sourceInfo->venta_seriedoc:"auto");
				$info["venta_seriedoc_id"]=(isset($sourceInfo->venta_seriedoc_id) && $sourceInfo->venta_seriedoc_id!=null?$sourceInfo->venta_seriedoc_id:"auto");
				$info["venta_numdoc"]=(isset($sourceInfo->venta_numdoc) && $sourceInfo->venta_numdoc!=null?$sourceInfo->venta_numdoc:"auto");
				$info["venta_vendedor"]=(isset($sourceInfo->venta_vendedor) && $sourceInfo->venta_vendedor!=null?$sourceInfo->venta_vendedor:null);
				$info["venta_vendedor_nombre"]=(isset($sourceInfo->venta_vendedor_nombre) && $sourceInfo->venta_vendedor_nombre!=null?$sourceInfo->venta_vendedor_nombre:null);
				$info["venta_cajero"]=(isset($sourceInfo->venta_cajero) && $sourceInfo->venta_cajero!=null?$sourceInfo->venta_cajero:null);
				$info["venta_cajero_nombre"]=(isset($sourceInfo->venta_cajero_nombre) && $sourceInfo->venta_cajero_nombre!=null?$sourceInfo->venta_cajero_nombre:null);
				$info["venta_caja"]=(isset($sourceInfo->venta_caja) && $sourceInfo->venta_caja!=null?$sourceInfo->venta_caja:null);
				$info["venta_caja_nombre"]=(isset($sourceInfo->venta_caja_nombre) && $sourceInfo->venta_caja_nombre!=null?$sourceInfo->venta_caja_nombre:null);
				$info["venta_estado"]=(isset($sourceInfo->venta_estado) && $sourceInfo->venta_estado!=null?$sourceInfo->venta_estado:null);
				$info["venta_tipo"]=(isset($sourceInfo->venta_tipo) && $sourceInfo->venta_tipo!=null?$sourceInfo->venta_tipo:null);
				$info["venta_origen"]=(isset($sourceInfo->venta_origen) && $sourceInfo->venta_origen!=null?$sourceInfo->venta_origen:null);
				$info["venta_descargo"]=(isset($sourceInfo->venta_descargo) && $sourceInfo->venta_descargo!=null?$sourceInfo->venta_descargo:null);
				$info["efectivo"]=(isset($sourceInfo->efectivo) && $sourceInfo->efectivo!=null?$sourceInfo->efectivo:null);
				$info["pos"]=(isset($sourceInfo->pos) && $sourceInfo->pos!=null?$sourceInfo->pos:null);
				$info["cotizacion_notas"]=(isset($sourceInfo->cotizacion_notas) && $sourceInfo->cotizacion_notas!=null?$sourceInfo->cotizacion_notas:null);
				$info["cotizacion_firma"]=(isset($sourceInfo->cotizacion_firma) && $sourceInfo->cotizacion_firma!=null?$sourceInfo->cotizacion_firma:null);
				if($encode)
					echo json_encode(array("load_info"=>(isset($sourceInfo) && $sourceInfo!=null?(object)$info:null),"load_productos"=>(isset($productos) && $productos!=null?(object)$productos:null)));
				else
					return array("load_info"=>(isset($sourceInfo) && $sourceInfo!=null?(object)$info:null),"load_productos"=>(isset($productos) && $productos!=null?(object)$productos:null));
			}
			/*------------ GUARDAR VENTA ------------*/
			function guardarventa(){
				if($this->input->post('fecha')==""){
					$fecha=gmdate('Y-m-d H:i:s',strtotime('- 6 hours'));
				}else{
					$fecha = gmdate($this->input->post('fecha').' H:i:s',strtotime('- 6 hours'));
				}
				$numeroDoc=$this->input->post('numero');
				$productos=json_decode($this->input->post('productos'));
				$atotales=json_decode($this->input->post('totales'));
				/*--- Ordenar totales ---*/
				$totales=array();
				foreach($atotales as $total){
					foreach($total as $key => $value){
						$totales[$key]=$value;
					}
				}
				/*--- Obtener configuraciones ---*/
				$configuracioness=$this->Generic_model->get("configuraciones");
				foreach($configuracioness as $config){
					if($config->campo_config=="NombreEmpresa"||$config->campo_config=="RazonSocialEmpresa"||$config->campo_config=="DireccionEmpresa"||$config->campo_config=="TelefonoEmpresa"||$config->campo_config=="NRCEmpresa"||$config->campo_config=="NITEmpresa"||$config->campo_config=="MensajeTicket"||$config->campo_config=="facturacion_actualizar_cliente")
						$configs[$config->campo_config]=$config->valor_config;
				}
				/*--- Obtener serie ---*/
				if($this->input->post('serieid') && trim($this->input->post('serieid'))!=""){
					$serie=$this->Generic_model->get("resoluciones_caja","num_resolucion,tiraje_actual,tiraje_desde,tiraje_hasta",array("id_resolucion"=>$this->input->post('serieid')));
					$serie=$serie[0];
				}
				/*--Obtener Cajero --*/
				$cajero=$this->Generic_model->get('usuarios','nombre_usuario',array('id_usuario'=>$this->session_['userid']));
				$cajero=$cajero[0]->nombre_usuario;
				/*--Obtener Vendedor--*/
				if($this->input->post('vendedor') && $this->input->post('vendedor')!=''){
					$vendedor=$this->Generic_model->get('usuarios','nombre_usuario',array('id_usuario'=>$this->input->post('vendedor')));
					$vendedor=$vendedor[0]->nombre_usuario;
				}else{
					$vendedor=$cajero;
				}
				/*--- Obtener cliente ---*/
				if($this->input->post('cliente') && trim($this->input->post('cliente'))!=""){
					$cliente=$this->Generic_model->get("clientes","id_cliente,dui_cliente,nit_cliente,ncr_cliente,giro_cliente,direccion_cliente",array('id_cliente'=>$this->input->post('cliente')));
					$cliente=$cliente[0];
				}
				/*--- Asignacion automatica de numero venta ---*/
				if($numeroDoc=="auto" && isset($serie) && $serie!=null){
					$numeroDoc=$serie->tiraje_actual;
				}
				/*--- Ordenar arreglos de productos ---*/
				$salidaArraybase=array(
					'fecha_salida'=>$fecha,
					'fecha_reserva'=>$fecha,
					'concepto_salida'=>0,
					'documento_salida'=>$this->input->post('documento'),
					'num_doc_salida'=>$numeroDoc,
					'doc_reserva_salida'=>$this->input->post('documento'),
					'num_doc_reserva_salida'=>$numeroDoc,
					'doc_facturacion'=>($this->input->post('documento')==1 || $this->input->post('documento')==2 || $this->input->post('documento')==3?$this->input->post('documento'):null),
					'num_doc_facturacion'=>($this->input->post('documento')==1 || $this->input->post('documento')==2 || $this->input->post('documento')==3?$numeroDoc:''),
					'id_venta'=>null
				);
				$productosArray=$this->ordenarProductos($productos,true,true,true,$salidaArraybase);				
				$productosListSalida=$productosArray->salida;/*Saldia de productos*/
				$productosListNormal=$productosArray->normal;/*Cliente*/
				if($this->input->post('documento')==3){
					$productosListInterno=$productosArray->interno;/*Auditoria*/
					$totalInterno=$productosArray->totalInterno;/*Auditoria*/
				}else{
					$productosListInterno=$productosArray->normal;
					$totalInterno=$totales['totalGrabadas'];
				}				
				/*--- Registrar venta ---*/
				$ventaData=array(
					'id_cajero'=>$this->session_['userid'],
					'id_vendedor'=>($this->input->post('vendedor')!=''?$this->input->post('vendedor'):$this->session_['userid']),
					'id_caja'=>$this->caja->id_caja,
					'id_cliente'=>($this->input->post('cliente')!=''?$this->input->post('cliente'):null),
					'nombre_cliente'=>$this->input->post('clientetxt'),
					'dui_cliente'=>$this->input->post('dui'),
					'nit_cliente'=>$this->input->post('nit'),
					'nrc_cliente'=>$this->input->post('nrc'), 
					'fecha_venta'=>$fecha,
					'cobro_venta'=>$this->input->post('condicion'), 
					'estado_cobro'=>($this->input->post('condicion')==0?2:0),
					'forma_pago_venta'=>$this->input->post('fpago'),
					'efectivo_venta'=>$this->input->post('efectivo'),
					'pos_venta'=>$this->input->post('pos'),
					'descargo_venta'=>2,
					'id_resolucion'=>$this->input->post('serieid'),
					'documento_venta'=>$this->input->post('documento'),
					'num_documento_venta'=>$numeroDoc,
					'estado_venta'=>1,
					'tipo_venta'=>($this->input->post('documento')==1 || $this->input->post('documento')==2 || $this->input->post('documento')==3?0:1),
					'estado_transito_venta'=>($this->input->post('documento')==1 || $this->input->post('documento')==2 || $this->input->post('documento')==3?1:0),
					'origen_venta'=>0,
					'subtotal_venta'=>$totales['totalGrabadas'],
					'total_venta'=>$totales['totalTotal'],
					'descuento_venta'=>$totales['totalDescuentos'],
					'total_interno'=>$totalInterno,
					'iva_venta'=>(isset($totales['totalIVA'])?$totales['totalIVA']:0.00),
					'retencion_venta'=>(isset($totales['totalIVAretenido'])?$totales['totalIVAretenido']:0.00),
					'total_nosujeto_venta'=>$totales['totalNS'],
					'total_exento_venta'=>$totales['totalExento']
				);
				$venta=$this->Generic_model->save('ventas',$ventaData,true);
				/*--- Actualizar numero de documento en la serie ---*/
				if($venta>0 && isset($serie) && $serie!=null){
					$numeroDoc=(int)$numeroDoc;
					$tiraje_hasta=(int)$serie->tiraje_hasta;
					if(($numeroDoc+1)>$tiraje_hasta){
						$this->Generic_model->update("resoluciones_caja",array("tiraje_actual"=>$numeroDoc+1,"estado_resolucion"=>1),"id_resolucion",$this->input->post('serieid'));
					}else{
						$this->Generic_model->update("resoluciones_caja",array("tiraje_actual"=>$numeroDoc+1),"id_resolucion",$this->input->post('serieid'));
					}
				}
				
				/*--- Actualizar inventario ---*/
				for($i=0;$i<count($productosListSalida);$i++){
					if($productosListSalida[$i]["tipo_producto"]==0){
					    $this->Generic_model->disminuir('productos','id_producto',$productosListSalida[$i]['id_producto'],'exist_act_producto',$productosListSalida[$i]["cant_inventario"]);
					}
					unset($productosListSalida[$i]["cant_inventario"]);
					unset($productosListSalida[$i]["tipo_producto"]);
					$productosListSalida[$i]["id_venta"]=$venta;
				}
				
				/*--- Registrar Salida---*/
				$this->Generic_model->savebatch('salida_productos',$productosListSalida);
				/*--- Credito ---*/
				if($this->input->post('condicion')=='1' || $this->input->post('condicion')=='3'){
					$doc = $this->input->post('documento');
					if($doc=='0'){$doc='S/Documento';}
					else if($doc=='1'){$doc='Factura';}
					else if($doc=='2'){$doc='Comprobante de Credito Fiscal';}
					else if($doc=='3'){$doc='Ticket';}
					else if($doc=='4'){$doc='Nota de remision';}
					else if($doc=='5'){$doc='Nota de envio';}
					$credito=$this->input->post('credito');
					if($credito=='CREATE'){
						$estado_credito=0;
						if($this->input->post('condicion')=='3'){
							$estado_credito=2;
						}
						$creditoData=array(
							'id_cliente'=>$this->input->post('cliente'),
							'id_usuario'=>$this->session_['userid'],
							'estado_credito'=>$estado_credito,
							'autorizacion_credito'=>$fecha,
							'monto_credito'=>$totales['totalTotal'],
							'saldo_credito'=>$totales['totalTotal'],
							'fecha_credito'=>$fecha,
							'finalizacion_credito'=>date("Y-m-d", strtotime($this->input->post('fechacred')))
						);
						$credito=$this->Generic_model->save('creditos',$creditoData,true);
					}else{
						$ccredito=$this->Generic_model->get('creditos','saldo_credito as saldo,monto_credito as monto',array('id_credito'=>$credito));
						$saldo=$ccredito[0]->saldo;
						$monto=$ccredito[0]->monto;
						if(($saldo+$totales['totalTotal']) > $monto){
							$monto=$saldo+$totales['totalTotal'];
						}
						$creditoData=array(
							'monto_credito'=>$monto,
							'saldo_credito'=>$saldo+$totales['totalTotal'],
							'estado_credito'=>0
						);
						$this->Generic_model->update('creditos',$creditoData,'id_credito',$credito);
					}
					if($credito>1){	
						$tipo_transaccion=0;
						if($this->input->post('condicion')=='3'){
							$tipo_transaccion=2;
						}
						$transData=array(
							'id_credito' => $credito,
							'id_caja' => $this->caja->id_caja,
							'id_usuario'=>$this->session_['userid'],
							'fecha_transaccion'=>$fecha,
							'ref_transaccion'=> 'Venta con '.$doc.' No. '.$this->input->post('serie').' '.$numeroDoc,
							'tipo_transaccion'=>$tipo_transaccion,
							'doc_transaccion'=>$this->input->post('documento'),
							'num_doc_transaccion'=>$numeroDoc,
							'id_venta'=>$venta,
							'forma_transaccion'=>$this->input->post('fpago'),
							'monto_transaccion'=>$totales['totalTotal'],
							'saldo_transaccion'=>$totales['totalTotal']
						);
						$this->Generic_model->save('transaccionesxcredito',$transData);
					}					
				}
				/*Actualiza transaccion*/
				if($this->input->post("trans") && $this->input->post("trans")!="" && $this->input->post("transid") && $this->input->post("transid")!=""){
					$dataTransUpdate=array();
					$dataTranstable="";
					$dataTransField="";
					switch($this->input->post("trans")){
						/*Venta temporal*/
						case "ventatemp":
							$dataTranstable="ventas_trans";
							$dataTransField="id_venta_trans";
							$dataTransUpdate["estado_venta_trans"]=1;
						break;
						/* cotizacion*/
						case "cotizacion":break;
						/*Venta */
						case "venta":break;
						/*Pedido*/
						case "pedido":break;
					}
					if(count($dataTransUpdate)>0 && $dataTranstable!="" && $dataTransField!="")
						$this->Generic_model->update($dataTranstable,$dataTransUpdate,$dataTransField,$this->input->post("transid"));
				}
				/*--- Actualizar cliente ---*/
				if(isset($configs["facturacion_actualizar_cliente"]) && $configs["facturacion_actualizar_cliente"]>0 && isset($cliente)){
					$dataClienteUpdate=array();
					switch(intval($configs["facturacion_actualizar_cliente"])){
						/*Actualizar con nuevos datos cuando estan vacios*/
						case 1:
							if($this->input->post('dui') && $this->input->post('dui')!="" && $cliente->dui_cliente=="")
								$dataClienteUpdate["dui_cliente"]= $this->input->post('dui');
							if($this->input->post('nit') && $this->input->post('nit')!="" && $cliente->nit_cliente=="")
								$dataClienteUpdate["nit_cliente"]= $this->input->post('nit');
							if($this->input->post('nrc') && $this->input->post('nrc')!="" && $cliente->ncr_cliente=="")
								$dataClienteUpdate["ncr_cliente"]= $this->input->post('nrc');
						break;
						/*Actualizar con nuevos datos cuando son diferentes*/
						case 2:
							if($this->input->post('dui') && $this->input->post('dui')!="" && $cliente->dui_cliente!=$this->input->post('dui'))
								$dataClienteUpdate["dui_cliente"]= $this->input->post('dui');
							if($this->input->post('nit') && $this->input->post('nit')!="" && $cliente->nit_cliente!=$this->input->post('nit'))
								$dataClienteUpdate["nit_cliente"]= $this->input->post('nit');
							if($this->input->post('nrc') && $this->input->post('nrc')!="" && $cliente->ncr_cliente!=$this->input->post('nrc'))
								$dataClienteUpdate["ncr_cliente"]= $this->input->post('nrc');
						break;
						/*Actualizar siempre*/
						case 3:
							if($this->input->post('dui') && $this->input->post('dui')!="")
								$dataClienteUpdate["dui_cliente"]= $this->input->post('dui');
							if($this->input->post('nit') && $this->input->post('nit')!="")
								$dataClienteUpdate["nit_cliente"]= $this->input->post('nit');
							if($this->input->post('nrc') && $this->input->post('nrc')!="")
								$dataClienteUpdate["ncr_cliente"]= $this->input->post('nrc');
						break;
					}					
					if(count($dataClienteUpdate)>0){
						$this->Generic_model->update("clientes",$dataClienteUpdate,"id_cliente",$this->input->post('cliente'));
					}
				}
				/*--- Impresion ---*/				
				$dataPrint["copias"]=$this->input->post('impresion');
				$dataPrint['fecha']=date("d-m-Y H:i:s",strtotime($fecha));
				$dataPrint['caja']=$this->caja->nombre_caja;
				$dataPrint['doc_desde']=(isset($serie->tiraje_desde)?$serie->tiraje_desde:"");
				$dataPrint['doc_hasta']=(isset($serie->tiraje_hasta)?$serie->tiraje_hasta:"");
				$dataPrint['doc_resolucion']=(isset($serie->num_resolucion)?$serie->num_resolucion:"");
				$dataPrint['doc_serie']=$this->input->post('serie');
				$dataPrint['doc_numero']=$numeroDoc;
				$dataPrint['cliente']=$this->input->post('clientetxt');
				$dataPrint['dui_cliente']=$this->input->post('dui');
				$dataPrint['nit_cliente']=$this->input->post('nit');
				$dataPrint['nrc_cliente']=$this->input->post('nrc');
				$dataPrint['diascred']=$this->input->post('diascred');
				$dataPrint['condicion']=($this->input->post('condicion')=="1"?"Credito":"Contado");
				$dataPrint['condicion_num']=$this->input->post('condicion');
				$dataPrint['direccion_cliente']=(isset($cliente->direccion_cliente)?$cliente->direccion_cliente:"");
				$dataPrint['giro_cliente']=(isset($cliente->giro_cliente)?$cliente->giro_cliente:"");
				$dataPrint['productos_normal']=json_decode (json_encode ($productosListNormal), FALSE);
				$dataPrint['productos_interno']=json_decode (json_encode ($productosListInterno), FALSE);
				$dataPrint['totales']=$totales;
				$dataPrint['total_interno']=$totalInterno;
				$dataPrint['efectivo']=$this->input->post("efectivo");
				$dataPrint['cajero']=$cajero;
				$dataPrint['vendedor']=$vendedor;
				$dataPrint['referencia']="V-".$venta;
				if($this->input->post('impresion')==0){
					$this->imprimirFactura($dataPrint,$this->input->post('documento'));
				}
			}
			/*----------- REIMPIRIMIR VENTA ----------*/
			function reimprimirventa(){
				$productos=json_decode($this->input->post('productos'));
				$atotales=json_decode($this->input->post('totales'));
				/*--- Obtener configuraciones ---*/
				$configuracioness=$this->Generic_model->get("configuraciones");
				foreach($configuracioness as $config){
					if($config->campo_config=="NombreEmpresa"||$config->campo_config=="RazonSocialEmpresa"||$config->campo_config=="DireccionEmpresa"||$config->campo_config=="TelefonoEmpresa"||$config->campo_config=="NRCEmpresa"||$config->campo_config=="NITEmpresa"||$config->campo_config=="MensajeTicket"||$config->campo_config=="facturacion_actualizar_cliente")
						$configs[$config->campo_config]=$config->valor_config;
				}
				/*--- Obtener serie ---*/
				if($this->input->post('serieid') && trim($this->input->post('serieid'))!=""){
					$serie=$this->Generic_model->get("resoluciones_caja","num_resolucion,serie_autorizada,tiraje_actual,tiraje_desde,tiraje_hasta",array("id_resolucion"=>$this->input->post('serieid')));
					$serie=$serie[0];
				}
				/*--- Obtener cliente ---*/
				if($this->input->post('cliente') && trim($this->input->post('cliente'))!=""){
					$cliente=$this->Generic_model->get("clientes","direccion_cliente,giro_cliente",array('id_cliente'=>$this->input->post('cliente')));
					$cliente=$cliente[0];
				}
				/*--- Ordenar totales ---*/
				$totales=array();
				foreach($atotales as $total){
					foreach($total as $key => $value){
						$totales[$key]=$value;
					}
				}
				/*--- Ordenar arreglos de productos ---*/
				$productosArray=$this->ordenarProductos($productos,true,true,false);
				$productosListNormal=$productosArray->normal;/*Cliente*/
				$totalInterno=0;/*Auditoria*/
				if($this->input->post('documento')==3){
					$productosListInterno=$productosArray->interno;/*Auditoria*/
					$totalInterno=$productosArray->totalInterno;/*Auditoria*/
				}else{
					$productosListInterno=$productosArray->normal;
					$totalInterno=$totales['totalGrabadas'];
				}
				/*--- Impresion ---*/
				$dataPrint["copias"]=$this->input->post('copias');
				$dataPrint['fecha']=$this->input->post('fecha');
				$dataPrint['caja']=$this->input->post('caja');
				$dataPrint['doc_desde']=(isset($serie->tiraje_desde)?$serie->tiraje_desde:"");
				$dataPrint['doc_hasta']=(isset($serie->tiraje_hasta)?$serie->tiraje_hasta:"");
				$dataPrint['doc_resolucion']=(isset($serie->num_resolucion)?$serie->num_resolucion:"");
				$dataPrint['doc_serie']=(isset($serie->serie_autorizada)?$serie->serie_autorizada:"");
				$dataPrint['doc_numero']=$this->input->post('numero');
				$dataPrint['cliente']=$this->input->post('clientetxt');
				$dataPrint['dui_cliente']=$this->input->post('dui');
				$dataPrint['nit_cliente']=$this->input->post('nit');
				$dataPrint['nrc_cliente']=$this->input->post('nrc');
				$dataPrint['condicion']=$this->input->post('condicion'); 
				$dataPrint['direccion_cliente']=(isset($cliente->direccion_cliente)?$cliente->direccion_cliente:"");
				$dataPrint['giro_cliente']=(isset($cliente->giro_cliente)?$cliente->giro_cliente:"");
				$dataPrint['productos_normal']=json_decode (json_encode ($productosListNormal), FALSE);
				$dataPrint['productos_interno']=json_decode (json_encode ($productosListInterno), FALSE);
				$dataPrint['totales']=$totales;
				$dataPrint['total_interno']=$totalInterno;
				$dataPrint['efectivo']=$totales["totalTotal"];
				$dataPrint['cajero']=$this->input->post('cajero');
				$dataPrint['vendedor']=$this->input->post('vendedor');
				$dataPrint['referencia']=$this->input->post('referencia');
				$this->imprimirFactura($dataPrint,$this->input->post('documento'));
			}
			/*ORDENAR ARREGLOS DE PRODUCTOS*/
			function ordenarProductos($productos,$normal,$interno,$salida,$salidaInfo=null){
				$productosListSalida= array();/*Saldia de productos*/
				$productosListInterno=array();/*Auditoria*/
				$productosListNormal=array();/*Cliente*/
				$totalInterno=0;/*Auditoria*/
				$dataProductos=array();
				foreach($productos as $producto){
					/*Arreglo para salida de productos*/
					if($salida && $salidaInfo){
						$salidaArray=null;
						$salidaArray=$salidaInfo;
						$salidaArray['id_producto']=$producto->id;
						$salidaArray['id_presentacion']=$producto->pre;
						$salidaArray['cant_salida']=$producto->cant;
						$salidaArray['costo_salida']=$producto->costo;
						$salidaArray['descuento_salida']=$producto->descuento;
						$salidaArray['cant_inventario']=$producto->cant*$producto->uequiv;
						$salidaArray['tipo_producto']=$producto->tipo;
						$productosListSalida[]=$salidaArray;
					}
					/*Arreglo para productos interno(auditoria) para tickets*/
					if($interno){
						if(($producto->interno==0 && $producto->tipoventa==0) || $producto->tipoventa==1 || $producto->tipoventa==2 || $producto->tipoventa==3){/*Si el producto es normal y grabado o excento o no sujeto va a la cinta*/
							$productosListInterno[]=array(
								"cant"=>$producto->cant,
								"desc"=>$producto->desc,
								"costo"=>round($producto->costo,3),
								"tipoventa"=>($producto->tipoventa==0?'G':($producto->tipoventa==1 || $producto->tipoventa==3?'E':'NS'))
							);
							if($producto->tipoventa==0)
								$totalInterno+=(float)$producto->costo*(float)$producto->cant;
						}
					}
					/*Arreglo de productos normales(ticket cliente y demás documentos)*/
					if($normal){
						$productosListNormal[]=array(
							"cant"=>$producto->cant,
							"desc"=>$producto->desc,
							"ref"=>$producto->ref,
							"costo"=>round($producto->costo,3),
							"descuento"=>round($producto->descuento,3),
							"tipoventa"=>($producto->tipoventa==0?'G':($producto->tipoventa==1 || $producto->tipoventa==3?'E':'NS'))
						);
					}
				}				
				if($interno){
					/*Ajuste para lista interna vacia*/
					if(count($productosListInterno)==0){
						foreach($productosListNormal as $prodInterno){
							$cantInterno=((float)$prodInterno['cant']<1?$prodInterno['cant']:1);
							$productosListInterno[]=array(
								"cant"=>$cantInterno,
								"desc"=>$prodInterno['desc'],
								"costo"=>$prodInterno['costo'],
								"tipoventa"=>$prodInterno['tipoventa'] 
							);
							if($prodInterno['tipoventa']==0){
								$totalInterno+=(float)$cantInterno*(float)$prodInterno['costo'];
							}
						}
					}
					$dataProductos['interno']=$productosListInterno;
					$dataProductos['totalInterno']=$totalInterno;
				}
				if($normal){
					$dataProductos['normal']=$productosListNormal;
				}
				if($salida){
					$dataProductos['salida']=$productosListSalida;
				}
				return (object)$dataProductos;
			}
			/*IMPRIMIR DOCUMENTOS*/
			function imprimirFactura($dataPrint,$documento){
				/*--- Obtener configuraciones ---*/
				$configuracioness=$this->Generic_model->get("configuraciones");
				foreach($configuracioness as $config){
					if($config->campo_config=="NombreEmpresa"||$config->campo_config=="RazonSocialEmpresa"||$config->campo_config=="DireccionEmpresa"||$config->campo_config=="TelefonoEmpresa"||$config->campo_config=="NRCEmpresa"||$config->campo_config=="NITEmpresa"||$config->campo_config=="MensajeTicket"||$config->campo_config=="facturacion_actualizar_cliente")
						$configs[$config->campo_config]=$config->valor_config;
				}
				$dataPrint['nombre_empresa']=$configs["NombreEmpresa"];
				$dataPrint['rsocial_empresa']=$configs["RazonSocialEmpresa"];
				$dataPrint['direcion_empresa']=$configs["DireccionEmpresa"];
				$dataPrint['telefono_empresa']=$configs["TelefonoEmpresa"];
				$dataPrint['nit_empresa']=$configs["NITEmpresa"];
				$dataPrint['nrc_empresa']=$configs["NRCEmpresa"];
				$dataPrint['mensaje_ticket']=$configs["MensajeTicket"];
				echo json_encode($dataPrint);
			}
		/*---------- APLICACION DE  DEVOLUCION ----------*/
		function devolucionapp(){
			if(!$this->caja){
				$UIDataModal["content_view"]="error_nocaja_view";
				$UIDataModal["title"]="Error: Caja desconocida";
			}else{
				if($this->caja->estado_caja==0){
					$UIDataModal["content_view"]="error_caja_inactiva_view";
					$UIDataModal["title"]="Error: Caja inactiva";
				}else{
					$UIDataModal["title"]="Devoluci&oacute;n";
					if(!filter_var($this->permisos['facturacion']['transacciones-devolucion'],FILTER_VALIDATE_BOOLEAN)){
						$UIDataModal['content_view']="error_noacceso_view";
					}else{
						$UIDataModal["content_view"]="transacciones_devolucion_app_view";
						$UIDataModal["close_button"]=true;
						$UIDataModal["classes"]="modal-lg";
						$UIDataModal["id"]="devolucion-app-modal";
						$UIDataModal["clientes"]=$this->Generic_model->get('clientes','id_cliente,nombre_cliente,razonsocial_cliente,clasificacion_cliente,credito_cliente','',array('nombre_cliente'=>'ASC'));
						$UIDataModal["caja"]=$this->caja->id_caja;
					}
				}
			}
			$this->load->view('template_modal',$UIDataModal);
		}
			/*--- CARGAR LISTA VENTA DE VENTAS---*/
			function cargarventas(){
				if($this->input->get("by")==="document"){
					$where=array('documento_venta'=>$this->input->get('doc'),'id_resolucion'=>($this->input->get('serie')!=''?$this->input->get('serie'):null),'num_documento_venta'=>$this->input->get('num'));
				}elseif($this->input->get("by")==="transaction"){
					$where=array('id_venta'=>$this->input->get('id'));
				}
				$select ="ventas.id_venta as id,ventas.fecha_venta as fecha,(subtotal_venta+iva_venta-retencion_venta+percepcion_venta+total_nosujeto_venta+total_exento_venta-descuento_venta) as total,ventas.nombre_cliente as cliente,cajas.nombre_caja as caja";
				$ventas=$this->Generic_model->get('ventas',$select,$where,'','',array('cajas'=>'cajas.id_caja = ventas.id_caja, LEFT'));
				if(count($ventas)>0){
					echo "<table class='table table-hover'>";
					foreach($ventas as $i=>$venta){
						if($i==0){echo "<tr class='miracle-selected-table-item' id='venta-".$venta->id."'>";}
						else{echo "<tr id='venta-".$venta->id."'>";}
						echo "<td><div class='row'>";
						echo "<div class='col-sm-8'><h4><strong>Cliente:</strong> ".$venta->cliente."</h4></div>";
						echo "<div class='col-sm-4'><h4><strong>TOTAL:</strong> $".$venta->total."</h4></div></div>";
						echo "<div class='row'><div class='col-sm-12'><span>".date("d/m/Y H:i:s",strtotime($venta->fecha))." - ".$venta->caja."</span></div></div></td></tr>";
					}
					echo "</table>";
				}else{
					echo "<span style='display:block;text-align:center;'>No se ha encontrado ninguna venta asociada a la informaci&oacute;n proporcionada.</span>";
				} 
			}
			/*-------- GUARDAR DEVOLUCION -------*/
			function guardardevolucion(){
				$fecha=gmdate('Y-m-d H:i:s', strtotime('- 6 hours'));
				$numeroDoc=$this->input->post('numero');
				$docVenta="";
				$productos=json_decode($this->input->post('productos'));
				$atotales=json_decode($this->input->post('totales'));
				/*--- Ordenar totales ---*/
				$totales=array();
				foreach($atotales as $total){
					foreach($total as $key => $value){
						$totales[$key]=$value;
					}
				}
				/*--- Obtener configuraciones ---*/
				$configuracioness=$this->Generic_model->get("configuraciones");
				foreach($configuracioness as $config){
					if($config->campo_config=="NombreEmpresa"||$config->campo_config=="RazonSocialEmpresa"||$config->campo_config=="DireccionEmpresa"||$config->campo_config=="TelefonoEmpresa"||$config->campo_config=="NRCEmpresa"||$config->campo_config=="NITEmpresa"||$config->campo_config=="MensajeTicket"||$config->campo_config=="facturacion_actualizar_cliente")
						$configs[$config->campo_config]=$config->valor_config;
				}
				/*Ajustes para Tickets*/
				if($this->input->post('documento')=="3"){
					/*--- Ajuste para asignacion automatica de numero devolucion ---*/
					$numeroDoc="auto";
				}
				/*--- Obtener serie---*/
				if($this->input->post('serieid') && trim($this->input->post('serieid'))!=""){
					$serie=$this->Generic_model->get("resoluciones_caja","num_resolucion,tiraje_actual,tiraje_desde,tiraje_hasta",array("id_resolucion"=>$this->input->post('serieid')));
					$serie=$serie[0];
				}
				/*--- Asignacion automatica de numero venta ---*/
				if($numeroDoc=="auto" && isset($serie) && $serie!=null){
					$numeroDoc=$serie->tiraje_actual;
				}
				/*--- Obtener Cajero ---*/
				$cajero=$this->Generic_model->get('usuarios','nombre_usuario',array('id_usuario'=>$this->session_['userid']));
				$cajero=$cajero[0]->nombre_usuario;
				/*--- Obtener cliente ---*/
				if($this->input->post('cliente') && trim($this->input->post('cliente'))!=""){
					$cliente=$this->Generic_model->get("clientes","id_cliente,dui_cliente,nit_cliente,ncr_cliente,giro_cliente,direccion_cliente",array('id_cliente'=>$this->input->post('cliente')));
					$cliente=$cliente[0];
				}
				/*--- ID Venta ---*/
				$venta=($this->input->post('venta')!='' ? $this->input->post('venta'):null);
				/*--- Obtener Venta ---*/
				if($venta){
					$ventaInfo=$this->Generic_model->get("ventas","ventas.documento_venta,ventas.id_resolucion,resoluciones_caja.serie_autorizada,ventas.num_documento_venta",array("id_venta"=>$venta),"","",array("resoluciones_caja"=>"resoluciones_caja.id_resolucion=ventas.id_resolucion,LEFT"));
					$ventaInfo=$ventaInfo[0];
					switch($ventaInfo->documento_venta){
						case "0":$docVenta='S/Documento';break;
						case "1":$docVenta='Factura';break;
						case "2":$docVenta='Comprobante de Credito Fiscal';break;
						case "3":$docVenta='Ticket';break;
						case "4":$docVenta='Nota de remision';break;
						case "5":$docVenta='Nota de envio';break;
					}
				}
				switch($this->input->post('documento')){
					case "0":$doc='S/Documento';break;
					case "1":$doc='Factura';break;
					case "2":$doc='Comprobante de Credito Fiscal';break;
					case "3":$doc='Ticket';break;
					case "4":$doc='Nota de remision';break;
					case "5":$doc='Nota de envio';break;
					case "8":$doc='Nota de credito';break;
				}
				/*---Tipo de devolucion---*/
				/* if($this->input->post('devforma')==0){
					$tipoDev=1;
				}else{
					$tipoDev=0;
				} */
				$tipoDev=$this->input->post('condicion');
				/*--- Ordenar arreglos de productos ---*/
				$productosListEntrada= array();/*Entrada de productos*/
				$productosListInterno=array();/*Auditoria*/
				$productosListNormal=array();/*Cliente*/
				$totalInterno=0;/*Auditoria*/
				foreach($productos as $producto){
					/*Arreglo para entrada de productos*/
					$productosListEntrada[] = array(
						'fecha_entrada'=>$fecha,
						'id_producto'=>$producto->id,
						'id_presentacion'=>$producto->pre,
						'concepto_entrada'=>2,
						'id_devolucion'=>null,
						'cant_entrada'=>$producto->cant,
						'costo_entrada'=>$producto->costo,
						'cant_inventario'=>$producto->cant*$producto->uequiv,
						'tipo_producto'=>$producto->tipo
					);
					/*Arreglo para productos interno(auditoria) para tickets*/
					if($this->input->post('documento')==3 && ($producto->interno==0 && $producto->tipoventa==0) || $producto->tipoventa==1 || $producto->tipoventa==2){/*Si el producto es normal y grabado o excento o no sujeto va a la cinta*/
						$productosListInterno[]=array(
							"cant"=>$producto->cant,
							"desc"=>$producto->desc,
							"costo"=>round($producto->costo,2),
							"tipoventa"=>($producto->tipoventa==0?'G':($producto->tipoventa==1?'E':'NS'))
						);
						if($producto->tipoventa==0)
							$totalInterno+=(float)$producto->costo*(float)$producto->cant;
					}
					/*Arreglo de productos normales(ticket cliente y demás documentos)*/
					$productosListNormal[]=array(
						"cant"=>$producto->cant,
						"desc"=>$producto->desc,
						"costo"=>round($producto->costo,2),
						"tipoventa"=>($producto->tipoventa==0?'G':($producto->tipoventa==1?'E':'NS'))
					);
				}
				/*Ajuste para lista interna vacia*/
				if(count($productosListInterno)==0){
					foreach($productosListNormal as $prodInterno){
						$cantInterno=((float)$prodInterno['cant']<1?$prodInterno['cant']:1);
						$productosListInterno[]=array(
							"cant"=>$cantInterno,
							"desc"=>$prodInterno['desc'],
							"costo"=>$prodInterno['costo'],
							"tipoventa"=>$prodInterno['tipoventa'] 
						);
						if($prodInterno['tipoventa']==0){
							$totalInterno+=(float)$cantInterno*(float)$prodInterno['costo'];
						}
					}
				}
				/*Ajuste de total interno para documentos distintos a ticket*/
				if($this->input->post('documento')!=3){
					$totalInterno=$totales['totalGrabadas'];
				}
				/*--- Registrar devolucion ---*/
				$devData=array(
					'fecha_devolucion'=>$fecha,
					'id_caja'=>$this->caja->id_caja,
					'id_usuario'=>$this->session_['userid'] ,
					'id_venta'=>$venta,
					'motivo_devolucion'=>$this->input->post('motivo'),
					'doc_devolucion'=>$this->input->post('documento'),
					'id_resolucion'=>((trim($this->input->post('serieid'))!="" && is_numeric($this->input->post('serieid')))?$this->input->post('serieid'):null),
					'num_doc_devolucion'=>$numeroDoc,
					'tipo_devolucion'=>$tipoDev,
					'forma_devolucion'=>$this->input->post('devforma'),
					'efectivo_devolucion'=>$this->input->post('efectivo'),
					'pos_devolucion'=>$this->input->post('pos'),
					'grabado_devolucion'=>$totales['totalGrabadas'],
					'descuento_devolucion'=>$totales['totalDescuentos'],
					'interno_devolucion'=>$totalInterno,
					'iva_devolucion'=>(isset($totales['totalIVA'])?$totales['totalIVA']:0.00),
					'retencion_devolucion'=>(isset($totales['totalIVAretenido'])?$totales['totalIVAretenido']:0.00),
					'exento_devolucion'=>$totales['totalExento'],
					'nosujeto_devolucion'=>$totales['totalNS']
				);
				$devolucion=$this->Generic_model->save('devoluciones',$devData,true);
				/*--- Actualizar numero de documento en la serie para tickets---*/
				if($this->input->post('documento')=="3" || $this->input->post('documento')=="8"){
					if($devolucion>0 && isset($serie) && $serie!=null){
						$numeroDoc=(int)$numeroDoc;
						$tiraje_hasta=(int)$serie->tiraje_hasta;
						if(($numeroDoc+1)>$tiraje_hasta){
							$this->Generic_model->update("resoluciones_caja",array("tiraje_actual"=>$numeroDoc+1,"estado_resolucion"=>1),"id_resolucion",$this->input->post('serieid'));
						}else{
							$this->Generic_model->update("resoluciones_caja",array("tiraje_actual"=>$numeroDoc+1),"id_resolucion",$this->input->post('serieid'));
						}
					}
				}
				/*--- Actualizar inventario ---*/
				for($i=0;$i<count($productosListEntrada);$i++){
					if($productosListEntrada[$i]["tipo_producto"]==0){
						$this->Generic_model->aumentar('productos','id_producto',$productosListEntrada[$i]['id_producto'],'exist_act_producto',$productosListEntrada[$i]["cant_inventario"]);
					}
					unset($productosListEntrada[$i]["cant_inventario"]);
					unset($productosListEntrada[$i]["tipo_producto"]);
					$productosListEntrada[$i]["id_devolucion"]=$devolucion;
				}
				$this->Generic_model->savebatch('entrada_productos',$productosListEntrada);
				/*--- Modificar venta ---*/
				if($venta){
					$this->Generic_model->update("ventas",array("estado_venta"=>0),"id_venta",$venta);
				}
				/*Abono a credito*/
				if($tipoDev==1){
					$ccredito=$this->Generic_model->get('creditos','saldo_credito as saldo',array('id_credito'=>$this->input->post('credito')));
					$saldo=$ccredito[0]->saldo;
					$creditoData=array('saldo_credito'=>$saldo-$totales['totalTotal']);
					$transData=array(
						'id_credito'=>$this->input->post('credito'),
						'id_caja' => $this->caja->id_caja,
						'id_usuario'=>$this->session_['userid'],
						'fecha_transaccion'=>$fecha,
						'ref_transaccion'=>'Devolucion '.$doc.' numero '.$numeroDoc.' ('.$docVenta.' No. '.$ventaInfo->serie_autorizada.' '.$ventaInfo->num_documento_venta.') con abono a deuda',
						'tipo_transaccion'=>1,
						'doc_transaccion'=>$this->input->post('documento'),
						'num_doc_transaccion'=>$numeroDoc,
						'id_devolucion'=>$devolucion,
						'forma_transaccion'=>$this->input->post('devforma'),
						'monto_transaccion'=>$totales['totalTotal'],
						'saldo_transaccion'=>$saldo-$totales['totalTotal']
					);
					$this->Generic_model->save('transaccionesxcredito',$transData);
					$this->Generic_model->update('creditos',$creditoData,'id_credito',$this->input->post('credito'));
				}
				/*--- Formato de forma de devolucion ---*/
				$forma="";
				switch($this->input->post('devforma')){
					case "0":$forma="Abono Automatico a credito";break;
					case "1":$forma="Efectivo";break;
					case "2":$forma="Cheque";break;
					case "3":$forma="POS";break;
					case "4":$forma="Abono a cuenta";break;
					case "5":$forma="Pago electronico";break;
				}
				/*--- Impresión ---*/
				if($this->input->post('documento')!='0'){
					$dataPrint["copias"]=0;
					$dataPrint['fecha']=date("d-m-Y H:i:s",strtotime($fecha));
					$dataPrint['caja']=$this->caja->nombre_caja;
					$dataPrint['nombre_empresa']=$configs["NombreEmpresa"];
					$dataPrint['rsocial_empresa']=$configs["RazonSocialEmpresa"];
					$dataPrint['direcion_empresa']=$configs["DireccionEmpresa"];
					$dataPrint['telefono_empresa']=$configs["TelefonoEmpresa"];
					$dataPrint['nit_empresa']=$configs["NITEmpresa"];
					$dataPrint['nrc_empresa']=$configs["NRCEmpresa"];
					$dataPrint['mensaje_ticket']=$configs["MensajeTicket"];
					$dataPrint['doc_desde']=(isset($serie->tiraje_desde)?$serie->tiraje_desde:"");
					$dataPrint['doc_hasta']=(isset($serie->tiraje_hasta)?$serie->tiraje_hasta:"");
					$dataPrint['doc_resolucion']=(isset($serie->num_resolucion)?$serie->num_resolucion:"");
					$dataPrint['doc_serie']=$this->input->post('docserie');
					$dataPrint['documento']=$doc;
					$dataPrint['doc_numero']=$numeroDoc;
					$dataPrint['doc_anulado']=$docVenta;/*En formato texto*/
					$dataPrint['doc_anulado_serie']=$ventaInfo->serie_autorizada;
					$dataPrint['doc_anulado_numero']=$ventaInfo->num_documento_venta;
					$dataPrint['forma']=$forma;
					$dataPrint['credito']=($this->input->post('credito')!=""?$this->input->post('credito'):"N/A");
					$dataPrint['cliente']=$this->input->post('clientenombre');
					$dataPrint['dui_cliente']=$this->input->post('clientedui');
					$dataPrint['nit_cliente']=$this->input->post('clientenit');
					$dataPrint['nrc_cliente']=(isset($cliente->ncr_cliente)?$cliente->ncr_cliente:"");
					$dataPrint['direccion_cliente']=(isset($cliente->direccion_cliente)?$cliente->direccion_cliente:"");
					$dataPrint['productos_normal']=json_decode (json_encode ($productosListNormal), FALSE);
					$dataPrint['productos_interno']=json_decode (json_encode ($productosListInterno), FALSE);
					$dataPrint['totales']=$totales;
					$dataPrint['total_interno']=$totalInterno;
					$dataPrint['cajero']=$cajero;
					$dataPrint['motivo']=$this->input->post('motivo');
					$dataPrint['referencia']="D-".$devolucion;
					echo json_encode($dataPrint);
				}else{
					echo true;
				}
			}
		/*------ APLICACION DE COBRO DE CREDITOS ------*/
		function pagocredito(){
			if(!$this->caja){
				$UIDataModal["content_view"]="error_nocaja_view";
				$UIDataModal["title"]="Error: Caja desconocida";
			}else{
				if($this->caja->estado_caja==0){
					$UIDataModal["content_view"]="error_caja_inactiva_view";
					$UIDataModal["title"]="Error: Caja inactiva";
				}else{
					$UIDataModal["title"]="Pago de creditos";
					if(!filter_var($this->permisos['facturacion']['transacciones-facturacion'],FILTER_VALIDATE_BOOLEAN)){
						$UIDataModal['content_view']="error_noacceso_view";
					}else{
						$UIDataModal["content_view"]="transacciones_pago_credito_app_view";
						$UIDataModal["close_button"]=true;
						$UIDataModal["classes"]="modal-lg";
						$UIDataModal["id"]="facturacion-app-modal";
						$UIDataModal["clientes"]=$this->Generic_model->get('clientes','id_cliente as id, nombre_cliente as nombre, razonsocial_cliente as razon,direccion_cliente as direccion,dui_cliente as dui,nit_cliente as nit,ncr_cliente as nrc,giro_cliente as giro',"",array('nombre_cliente'=>'ASC'));
						
						$UIDataModal["caja"]=$this->caja->id_caja;
					}
				}
			}
			$this->load->view('template_modal',$UIDataModal);
		}
			/*---- GUARDAR UN PAGO A CREDITO ----*/
			function guardarpagocredito(){
				$fecha=gmdate('Y-m-d H:i:s', strtotime('- 6 hours'));
				$docs=json_decode($this->input->post("docs"));
				$productos=json_decode($this->input->post("productos"));
				$venta=null;
				$concepto="Pago:";
				$vendedor=null;
				/*Recorrer documentos para registrar pago*/
				foreach($docs as $doc){
					if($doc->credito){
						/*Obtener credito*/
						$credito=$this->Generic_model->get('creditos','saldo_credito as saldo',array('id_credito'=>$doc->credito));
						/*Actualizar credito*/
						$nsaldo=(floatval($credito[0]->saldo)-floatval($doc->total));
						$estadoCred=0;
						if($nsaldo<=0){
							$estadoCred=1;
						}
						$creditoData=array(
							'saldo_credito'=>$nsaldo,
							'estado_credito'=>$estadoCred
						);
						$tipo_transaccion=1;
						if((int)$doc->condicion==3){
							$tipo_transaccion=3;
						}
						/*Registrar transaccion*/
						$dataTrans=array(
							"id_credito"=>$doc->credito,
							"id_caja"=>$this->caja->id_caja,
							"id_usuario"=>$this->session_['userid'],
							"fecha_transaccion"=>$fecha,
							"ref_transaccion"=>"Pago en caja de ".$this->getDocById($doc->doc)." No. ".$doc->numdoc." (".$this->getDocById($this->input->post('docp'))." No. ".$this->input->post('seriep')." ".$this->input->post('nump').")",
							"tipo_transaccion"=>$tipo_transaccion,
							"doc_transaccion"=>$this->input->post('docp'),
							"num_doc_transaccion"=>$this->input->post('nump'),
							"id_venta"=>null,
							"forma_transaccion"=>$this->input->post('fpago'),
							"monto_transaccion"=>$doc->total,
							"saldo_transaccion"=>$nsaldo
						);					
						$this->Generic_model->save('transaccionesxcredito',$dataTrans);
						$this->Generic_model->update('creditos',$creditoData,'id_credito',$doc->credito);
						$concepto.=" ".$this->getDocById($doc->doc)." No. ".$doc->numdoc."(Cred:".$doc->credito."),";
					}else{
						$concepto.=" ".$this->getDocById($doc->doc)." No. ".$doc->numdoc."(Cred:N/A),";
					}
					/*Actualizar venta original*/
					$dataUpVenta["estado_cobro"]=2;
					if((int)$doc->condicion==1){
						$dataUpVenta["estado_venta"]=0;
					}
					/* $dataUpVenta=array(
						"estado_cobro"=>2,
						"estado_venta"=>0
					); */
					$this->Generic_model->update('ventas',$dataUpVenta,'id_venta',$doc->idventa);
					$vendedor=$doc->vendedor;
				}
				/*Facturacion*/
				$facturar=filter_var($this->input->post("facturar"),FILTER_VALIDATE_BOOLEAN);
				if($facturar){
					/*--- Ordenar totales ---*/
					$atotales=json_decode($this->input->post('totales'));
					$totales=array();
					foreach($atotales as $total){
						foreach($total as $key => $value){
							$totales[$key]=$value;
						}
					}
					/*--Obtener Cajero --*/
					$cajero=$this->Generic_model->get('usuarios','nombre_usuario',array('id_usuario'=>$this->session_['userid']));
					$cajero=$cajero[0]->nombre_usuario;
					/*--Obtener Vendedor--*/
					if(isset($vendedor) && $vendedor!=''){
						$vendedorNombre=$this->Generic_model->get('usuarios','nombre_usuario',array('id_usuario'=>$vendedor));
						$vendedorNombre=$vendedorNombre[0]->nombre_usuario;
					}else{
						$vendedorNombre=$cajero;
					}
					/*--- Obtener cliente ---*/
					if($this->input->post('cliente') && trim($this->input->post('cliente'))!=""){
						$cliente=$this->Generic_model->get("clientes","id_cliente,dui_cliente,nit_cliente,ncr_cliente,giro_cliente,direccion_cliente",array('id_cliente'=>$this->input->post('cliente')));
						$cliente=$cliente[0];
					}
					/*--- Ordenar arreglos de productos ---*/
					$productosArray=$this->ordenarProductos($productos,true,true,false);
					$productosListNormal=$productosArray->normal;/*Cliente*/
					$totalInterno=0;/*Auditoria*/
					if($this->input->post('docf')==3){
						$productosListInterno=$productosArray->interno;/*Auditoria*/
						$totalInterno=$productosArray->totalInterno;/*Auditoria*/
					}else{
						$productosListInterno=$productosArray->normal;
						$totalInterno=$totales['totalGrabadas'];
					}
					/*-- Guardar nueva venta --*/
					$ventaData=array(
						'id_cajero'=>$this->session_['userid'],
						'id_vendedor'=>$vendedor,
						'id_caja'=>$this->caja->id_caja,
						'id_cliente'=>($this->input->post('cliente')!=''?$this->input->post('cliente'):null),
						'nombre_cliente'=>$this->input->post('clientetxt'),
						'dui_cliente'=>$this->input->post('clientedui'),
						'nit_cliente'=>$this->input->post('clientenit'),
						'nrc_cliente'=>$this->input->post('clientenrc'), 
						'fecha_venta'=>$fecha,
						'cobro_venta'=>2, 
						'estado_cobro'=>2,
						'forma_pago_venta'=>$this->input->post('fpago'),
						'descargo_venta'=>2,
						'id_resolucion'=>$this->input->post('serieidf'),
						'documento_venta'=>$this->input->post('docf'),
						'num_documento_venta'=>$this->input->post('numf'),
						'estado_venta'=>1,
						'tipo_venta'=>0,
						'estado_transito_venta'=>1,
						'origen_venta'=>2,
						'subtotal_venta'=>$totales['totalGrabadas'],
						'total_interno'=>$totalInterno,
						'iva_venta'=>(isset($totales['totalIVA'])?$totales['totalIVA']:0.00),
						'retencion_venta'=>(isset($totales['totalIVAretenido'])?$totales['totalIVAretenido']:0.00),
						'total_nosujeto_venta'=>$totales['totalNS'],
						'total_exento_venta'=>$totales['totalExento']
					);
					$ventanueva=$this->Generic_model->save('ventas',$ventaData,true);
					/*Actualizar salida de productos*/
					foreach($productos as $sprod){
						$datasal=array(
							"doc_facturacion"=>$this->input->post('docf'),
							"num_doc_facturacion"=>$this->input->post('numf'),
							"id_venta"=>$ventanueva,
							"costo_salida"=>$sprod->costo
						);
						$this->Generic_model->update('salida_productos',$datasal,'id_salida',$sprod->idsalida);
					}
				}
				/*Actualizar numero de documento de pago en la serie*/
				if($this->input->post('serieidp') && trim($this->input->post('serieidp'))!=""){
					$serie=$this->Generic_model->get("resoluciones_caja","tiraje_hasta",array("id_resolucion"=>$this->input->post('serieidp')));
					$serie=$serie[0];
					$tiraje_hasta=$serie->tiraje_hasta;
					if(((int)$this->input->post('nump') + 1) > (int)$tiraje_hasta){
						$this->Generic_model->update("resoluciones_caja",array("tiraje_actual"=>((int)$this->input->post('nump')+1),"estado_resolucion"=>1),"id_resolucion",$this->input->post('serieidp'));
					}else{
						$this->Generic_model->update("resoluciones_caja",array("tiraje_actual"=>((int)$this->input->post('nump')+1)),"id_resolucion",$this->input->post('serieidp'));
					}
				}
				/*Actualizar numero de documento de facturacion en la serie*/
				if($facturar){
					if($this->input->post('serieidf') && trim($this->input->post('serieidf'))!=""){
						$serief=$this->Generic_model->get("resoluciones_caja","tiraje_hasta",array("id_resolucion"=>$this->input->post('serieidf')));
						$serief=$serief[0];
						$tiraje_hasta=$serief->tiraje_hasta;
						if(((int)$this->input->post('numf') + 1) > (int)$tiraje_hasta){
							$this->Generic_model->update("resoluciones_caja",array("tiraje_actual"=>((int)$this->input->post('numf')+1),"estado_resolucion"=>1),"id_resolucion",$this->input->post('serieidf'));
						}else{
							$this->Generic_model->update("resoluciones_caja",array("tiraje_actual"=>((int)$this->input->post('numf')+1)),"id_resolucion",$this->input->post('serieidf'));
						}
					}
				}
				/*Impresión recibo*/
				$receiptData['fecha']=$fecha;
				$receiptData['cliente']=$this->input->post('clientetxt');
				$receiptData['monto']=$this->input->post('total');
				$receiptData['concepto']=trim($concepto, ",");
				$this->load->view('impresos/transacciones_credito_recibo_view',$receiptData);
				/*Impresion de factura*/
				if($facturar){
					$factruraInfo=$this->input->post("factura");
					
					$dataPrint["copias"]=0;
					$dataPrint['fecha']=$factruraInfo["fecha"];
					$dataPrint['caja']=$this->caja->id_caja;
					$dataPrint['doc_desde']=(isset($serief->tiraje_desde)?$serief->tiraje_desde:"");
					$dataPrint['doc_hasta']=(isset($serief->tiraje_hasta)?$serief->tiraje_hasta:"");
					$dataPrint['doc_resolucion']=(isset($serief->num_resolucion)?$serief->num_resolucion:"");
					$dataPrint['doc_serie']=(isset($serief->serie_autorizada)?$serief->serie_autorizada:"");
					$dataPrint['doc_numero']=$this->input->post('numf');
					$dataPrint['cliente']=$factruraInfo["cliente"];
					$dataPrint['dui_cliente']=$factruraInfo["dui"];
					$dataPrint['nit_cliente']=$factruraInfo["nit"];
					$dataPrint['nrc_cliente']=$factruraInfo["nrc"];
					$dataPrint['condicion']="Contado"; 
					$dataPrint['direccion_cliente']=$factruraInfo["direccion"];
					$dataPrint['productos_normal']=json_decode (json_encode ($productosListNormal), FALSE);
					$dataPrint['productos_interno']=json_decode (json_encode ($productosListInterno), FALSE);
					$dataPrint['totales']=$totales;
					$dataPrint['total_interno']=$totalInterno;
					$dataPrint['efectivo']=$totales["totalTotal"];
					$dataPrint['cajero']=$cajero;
					$dataPrint['vendedor']=$vendedorNombre;
					$dataPrint['referencia']="V-".$ventanueva;
					$this->imprimirFactura($dataPrint,$this->input->post('docf'));
				}
				echo true;
			}
		/*----------- APLICACION DE CORTES -------------*/
		function cortesapp(){
			if(!$this->caja){
				$UIDataModal["content_view"]="error_nocaja_view";
				$UIDataModal["title"]="Error: Caja desconocida";
			}else{
				$UIDataModal["title"]="Cortes";
				if(!filter_var($this->permisos['facturacion']['transacciones-cortes'],FILTER_VALIDATE_BOOLEAN)){
					$UIDataModal['content_view']="error_noacceso_view";
				}else{
					$UIDataModal["content_view"]="transacciones_cortes_app_view";
					$UIDataModal["close_button"]=true;
					$UIDataModal["classes"]="modal-md";
					$UIDataModal["id"]="cortes-app-modal";
					$UIDataModal["caja"]=$this->caja->id_caja;
					$UIDataModal["caja_estado"]=$this->caja->estado_caja;
				}
			}
			$this->load->view('template_modal',$UIDataModal);
		}
			/*----------- HACER CORTE -----------*/
			function makecorte(){
			    $this->load->library('app_utilities');
				/*--- Obtener configuraciones ---*/
				$configuracioness=$this->Generic_model->get("configuraciones");
				foreach($configuracioness as $config){
					if($config->campo_config=="NombreEmpresa")
						$configs[$config->campo_config]=$config->valor_config;
                }
                $empresa=$configs["NombreEmpresa"];
				$fecha=gmdate('Y-m-d H:i:s', strtotime('- 6 hours'));
				$getType=$this->input->get('tipo');
				//$getRes=$this->input->get('serie');
				$getRes="";
				$getDotacion=$this->input->get('dotacion');
				$dotacion=0;
				$ticketInicioVenta="-";
				$ticketInicioDev="-";
				$ticketFinVenta="-";
				$ticketFinDev="-";
				/*Obtener resolucion*/
				if(is_numeric($getRes)){
					$resolucionTicket=$this->Generic_model->get('resoluciones_caja','*',array('id_resolucion'=>$getRes));
					$resolucionTicket=$resolucionTicket[0];
				}else{
					$resolucionTicket=null;
				}
				/*Obtener correlativo de ultimo corte*/
				$lastCorteCorrelativo=$this->Generic_model->get('cortes','correlativo_corte as correlativo',array('id_caja'=>$this->caja->id_caja),array('fecha_corte'=>'DESC'),'','',1);
				$lastCorteCorrelativo=$lastCorteCorrelativo[0];
				if(isset($lastCorteCorrelativo->correlativo)){
					$correlativo=$lastCorteCorrelativo->correlativo;
				}else{
					$correlativo=0;
				}
				/*Informacion de ultimo corte, dotacion y estado de caja*/
				if($getType==0){/*Corte X inicial*/
					$lastCorte=$this->Generic_model->get('cortes','fecha_corte as fecha',array('id_caja'=>$this->caja->id_caja,'tipo_corte'=>2),array('fecha_corte'=>'DESC'),'','',1);
					$lastCorte=$lastCorte[0];
					$dotacion=$getDotacion;
					if(isset($lastCorte->fecha)){
						$lastCorte=$lastCorte->fecha;
					}else{
						$lastCorte='0000-00-00 00:00:00';
					}
					/*Informacion de caja*/
					$dataCaja['estado_caja']=1;
					$dataCaja['dotacion_caja']=$getDotacion;
					
					/*Caja Chica*/
					$correlativochica=1;
			
					$lastCorteChica=$this->Generic_model->get('cortes_cajachica','*',array('cajachica'=>1),array("id_corte"=>"DESC"),"","",1);
					if(count($lastCorteChica)):
						$correlativochica=$lastCorteChica[0]->correlativo_corte+1;
					endif;
					$corte=array(
						"fecha_corte"=>$fecha,
						"desde_corte"=>$fecha,
						"correlativo_corte"=>$correlativochica,
						"estado_corte"=>0,
						"id_usuario"=>$this->session_['userid'],
						"cajachica"=>1
					);
					
					$idcortechica=$this->Generic_model->save('cortes_cajachica',$corte,true);
					
					$this->Generic_model->update('cajachica',array("estado_cajachica"=>1,"corte_cajachica"=>$idcortechica),'id_cajachica',1);
					
					if($dotacion>0){
						$transaccion=array(
							"fecha_transaccion"=>$fecha,
							"id_usuario"=>$this->session_['userid'],
							"id_cajachica"=>1,
							"tipo_transaccion"=>0,
							"concepto_transaccion"=>"Dotacion inicial",
							"monto_transaccion"=>$dotacion
						);
						$this->Generic_model->save('transaccionesxcajachica',$transaccion);
					}
				}else if($getType==3){/*Z mensual*/
					$lastCorte=$this->Generic_model->get('cortes','fecha_corte as fecha',array('id_caja'=>$this->caja->id_caja,'tipo_corte'=>3),array('fecha_corte'=>'DESC'),'','',1);
					$lastCorte=$lastCorte[0];
					if(isset($lastCorte->fecha)){
						$lastCorte=$lastCorte->fecha;
					}else{
						$lastCorte='0000-00-00 00:00:00';
					}
				}
				else{/*Corte X Parcial y Z */
					$lastCorte=$this->Generic_model->get('cortes','fecha_corte as fecha',array('id_caja'=>$this->caja->id_caja,'tipo_corte'=>0),array('fecha_corte'=>'DESC'),'','',1);
					$lastCorte=$lastCorte[0]->fecha;
					$dotacion=$this->Generic_model->get('cajas','dotacion_caja as dotacion',array('id_caja'=>$this->caja->id_caja));
					$dotacion=$dotacion[0]->dotacion;
					if($getType==2){
						/*Caja*/
						$dataCaja['estado_caja']=0;
						$dataCaja['dotacion_caja']=0;
						/*Caja Chica*/
						$cajachica=$this->Generic_model->get('cajachica','*',array('id_cajachica'=>1));
			
						$this->Generic_model->update('cajachica',array("estado_cajachica"=>0),'id_cajachica',1);
						$this->Generic_model->update('cortes_cajachica',array("estado_corte"=>1,"hasta_corte"=>$fecha),'id_corte',$cajachica[0]->corte_cajachica);
					}
				}
				/*Actualizar caja*/
				if(isset($dataCaja) && !empty($dataCaja)){
					$this->Generic_model->update('cajas',$dataCaja,'id_caja',$this->caja->id_caja);
				}
				/*Obtener ventas*/
				$ventasSQL="(SELECT forma_pago_venta as medio,documento_venta as documento,num_documento_venta as documento_numero,cobro_venta as cobro,origen_venta as origen,subtotal_venta as grabado,total_interno as interno,total_exento_venta as exento,total_nosujeto_venta as nosujeto,descuento_venta as descuento,iva_venta as iva,retencion_venta as retencion,percepcion_venta as percepcion,(subtotal_venta+total_exento_venta+total_nosujeto_venta+iva_venta-descuento_venta) as total,estado_venta as estado,efectivo_venta as efectivo, pos_venta as pos FROM ventas WHERE id_caja = '".$this->caja->id_caja."' AND fecha_venta > '".$lastCorte."' AND documento_venta != '3' ORDER BY fecha_venta ASC)";
				if($resolucionTicket){
					$ventasSQL.=" UNION ALL (SELECT forma_pago_venta as medio,documento_venta as documento,num_documento_venta as documento_numero,cobro_venta as cobro,origen_venta as origen,subtotal_venta as grabado,total_interno as interno,total_exento_venta as exento,total_nosujeto_venta as nosujeto,descuento_venta as descuento,iva_venta as iva,retencion_venta as retencion,percepcion_venta as percepcion,(subtotal_venta+total_exento_venta+total_nosujeto_venta+iva_venta-descuento_venta) as total,efectivo_venta as efectivo, pos_venta as pos FROM ventas WHERE id_caja = '".$this->caja->id_caja."' AND fecha_venta > '".$lastCorte."' AND documento_venta = '3' AND id_resolucion = '".$resolucionTicket->id_resolucion."' ORDER BY fecha_venta ASC)";
				}
				$ventas=$this->Generic_model->sql_custom($ventasSQL);
				/*Obtener Pagos de creditos*/
				$pagosCreditosSQL="SELECT tipo_transaccion as tipo, forma_transaccion as medio,doc_transaccion as documento,monto_transaccion as total FROM transaccionesxcredito WHERE id_caja='".$this->caja->id_caja."' AND (tipo_transaccion='1' OR tipo_transaccion='3')AND fecha_transaccion > '".$lastCorte."' ORDER BY fecha_transaccion ASC";
				$pagosCreditos=$this->Generic_model->sql_custom($pagosCreditosSQL);
				/*Obtener devoluciones*/
				$devolucionesSQL="(SELECT forma_devolucion as medio, doc_devolucion as documento, num_doc_devolucion as documento_numero, tipo_devolucion as tipo,retencion_devolucion as retencion,percepcion_devolucion as percepcion,(grabado_devolucion + exento_devolucion + nosujeto_devolucion + iva_devolucion - descuento_devolucion) as total,efectivo_devolucion as efectivo,pos_devolucion as pos FROM devoluciones WHERE id_caja = '".$this->caja->id_caja."' AND fecha_devolucion > '".$lastCorte."' AND doc_devolucion != '3' ORDER BY fecha_devolucion ASC)";
				if($resolucionTicket){
					$devolucionesSQL.=" UNION ALL (SELECT forma_devolucion as medio, doc_devolucion as documento, num_doc_devolucion as documento_numero, tipo_devolucion as tipo,retencion_devolucion as retencion,percepcion_devolucion as percepcion, (grabado_devolucion + exento_devolucion + nosujeto_devolucion + iva_devolucion - descuento_devolucion) as total,efectivo_devolucion as efectivo,pos_devolucion as pos FROM devoluciones WHERE id_caja = '".$this->caja->id_caja."' AND fecha_devolucion > '".$lastCorte."' AND doc_devolucion = '3' AND id_resolucion = '".$resolucionTicket->id_resolucion."' ORDER BY fecha_devolucion ASC)";
				}
				$devoluciones=$this->Generic_model->sql_custom($devolucionesSQL);
				/*totales - corte fiscal*/
				$total_sdocumento_grabado=$total_sdocumento_exento=$total_sdocumento_nosujeto=0;
				$total_factura_grabado=$total_factura_exento=$total_factura_nosujeto=0;
				$total_ccf_grabado=$total_ccf_exento=$total_ccf_nosujeto=$total_ccf_percibido=$total_ccf_retenido=0;
				$total_ticket_grabado=$total_ticket_interno=$total_ticket_exento=$total_ticket_nosujeto=0;
				$total_nremision_grabado=$total_nremision_exento=$total_nremision_nosujeto=0;
				$total_nenvio_grabado=$total_nenvio_exento=$total_nenvio_nosujeto=0;
				$total_devolucion_sdocumento=$total_devolucion_factura=$total_devolucion_ccf=$total_devolucion_ticket=$total_devolucion_nremision=$total_devolucion_nenvio=$total_devolucion_ncredito=0;
				$total_trans_sdocumento=$total_trans_factura=$total_trans_ccf=$total_trans_ticket=$total_trans_ticket_dev=$total_trans_nremision=$total_trans_nenvio=$total_trans_ncredito=0;
				$ticketInicio=$ticketFin="-";
				/*totales -anexo  ingreso segun medio*/
				$total_ventas_efectivo=$total_ventas_cheque=$total_ventas_pos=$total_ventas_cuenta=$total_ventas_electronico=0;
				$total_devoluciones_efectivo=$total_devoluciones_cheque=$total_devoluciones_pos=$total_devoluciones_cuenta=$total_devoluciones_electronico=0;
				/*Segun documento*/
				$total_contado_sdocumento=$total_devolucion_sdocumento_contado=$total_credito_sdocumento=$total_devolucion_sdocumento_credito=$total_devolucion_sdocumento_acobro=$total_singreso_sdocumento=$total_acobro_sdocumento=0;
				$total_contado_factura=$total_devolucion_factura_contado=$total_credito_factura=$total_devolucion_factura_credito=$total_devolucion_factura_acobro=$total_singreso_factura=$total_acobro_factura=0;
				$total_contado_ccf=$total_devolucion_ccf_contado=$total_credito_ccf=$total_devolucion_ccf_credito=$total_devolucion_ccf_acobro=$total_singreso_ccf=$total_acobro_ccf=0;
				$total_contado_ticket=$total_devolucion_ticket_contado=$total_credito_ticket=$total_devolucion_ticket_credito=$total_devolucion_ticket_acobro=$total_singreso_ticket=$total_acobro_ticket=0;
				$total_contado_nremision=$total_devolucion_nremision_contado=$total_credito_nremision=$total_devolucion_nremision_credito=0;
				$total_contado_nenvio=$total_devolucion_nenvio_contado=$total_credito_nenvio=$total_devolucion_nenvio_credito=0;
				$total_recibos=0;
				$total_devolucion_ncredito_contado=$total_devolucion_ncredito_credito=0;
				/*Segun tipo*/
				$total_abonos_cred_contado=$total_abonos_acobro_contado=0;
				
				/*------- CALCULO DE TOTALES DE VENTA -------*/
				$mensaje_fact="<strong>Facturas</strong><br><table border='1' cellspacing='0'><thead><tr><th>Numero</th><th>Total</th><th>Estado</th></tr></thead><tbody>";
				if(count($ventas)){
					foreach($ventas as $venta){
						/*segun medio*/
						if($venta->origen==0){
							switch($venta->medio){
								case 1: $total_ventas_efectivo+=($venta->total+$venta->percepcion-$venta->retencion);break;/*ventas efectivo*/
								case 2: $total_ventas_cheque+=($venta->total+$venta->percepcion-$venta->retencion);break;/*ventas cheques*/
								case 3: $total_ventas_pos+=($venta->total+$venta->percepcion-$venta->retencion);break;/*ventas POS*/
								case 4: $total_ventas_cuenta+=($venta->total+$venta->percepcion-$venta->retencion);break;/*ventas abono a cuenta*/
								case 5: $total_ventas_electronico+=($venta->total+$venta->percepcion-$venta->retencion);break;/*ventas pago electronico*/
								case 6:/* Mixto - Efectivo/Pos */
									$total_ventas_efectivo+=$venta->efectivo;
									$total_ventas_pos+=$venta->pos;
								break;
							}
						}
						/*segun documento*/
						switch($venta->documento){
							case 0:/*Sin documento*/
								switch($venta->cobro){
									case 0:$total_contado_sdocumento+=($venta->total+$venta->percepcion-$venta->retencion);break;/*contado*/
									case 1:$total_credito_sdocumento+=($venta->total+$venta->percepcion-$venta->retencion);break;/*credito*/
									case 2:$total_singreso_sdocumento+=($venta->total+$venta->percepcion-$venta->retencion);break;/*sin ingreso*/
									case 3:$total_acobro_sdocumento+=($venta->total+$venta->percepcion-$venta->retencion);break;/*sin ingreso*/
								}
								/*Segun tipo venta*/
								$total_sdocumento_grabado+=$venta->grabado+$venta->percepcion-$venta->retencion;
								$total_sdocumento_exento+=$venta->exento;
								$total_sdocumento_nosujeto+=$venta->nosujeto;
								$total_trans_sdocumento++;
							break;
							case 1:/*Factura*/
								switch($venta->cobro){
									case 0:$total_contado_factura+=($venta->total+$venta->percepcion-$venta->retencion);break;/*contado*/
									case 1:$total_credito_factura+=($venta->total+$venta->percepcion-$venta->retencion);break;/*credito*/
									case 2:$total_singreso_factura+=($venta->total+$venta->percepcion-$venta->retencion);break;/*sin ingreso*/
									case 3:$total_acobro_factura+=($venta->total+$venta->percepcion-$venta->retencion);break;/*a cobro*/
								}
								/*Segun tipo venta*/
								$total_factura_grabado+=$venta->grabado+$venta->percepcion-$venta->retencion-$venta->descuento;
								$total_factura_exento+=$venta->exento;
								$total_factura_nosujeto+=$venta->nosujeto;
								$total_trans_factura++;
								$mensaje_fact.="<tr><td>".$venta->documento_numero."</td><td>$".number_format(($venta->total+$venta->percepcion-$venta->retencion),2)."</td><td>".(($venta->estado==1)?"Activa":"Anulada")."</td></tr>";
							break;
							case 2:/*CCF*/
								switch($venta->cobro){
									case 0:$total_contado_ccf+=($venta->total+$venta->percepcion-$venta->retencion);break;/*contado*/
									case 1:$total_credito_ccf+=($venta->total+$venta->percepcion-$venta->retencion);break;/*credito*/
									case 2:$total_singreso_ccf+=($venta->total+$venta->percepcion-$venta->retencion);break;/*sin ingreso*/
									case 3:$total_acobro_ccf+=($venta->total+$venta->percepcion-$venta->retencion);break;/*a cobro*/
								}
								/*Segun tipo venta*/
								$total_ccf_grabado+=$venta->grabado+$venta->iva+$venta->percepcion-$venta->retencion;
								$total_ccf_exento+=$venta->exento;
								$total_ccf_nosujeto+=$venta->nosujeto;
								$total_trans_ccf++;
							break;
							case 3:/*Ticket*/
								switch($venta->cobro){
									case 0:$total_contado_ticket+=($venta->total+$venta->percepcion-$venta->retencion);break;/*contado*/
									case 1:$total_credito_ticket+=($venta->total+$venta->percepcion-$venta->retencion);break;/*credito*/
									case 2:$total_singreso_ticket+=($venta->total+$venta->percepcion-$venta->retencion);break;/*sin ingreso*/
									case 3:$total_acobro_ticket+=($venta->total+$venta->percepcion-$venta->retencion);break;/*a cobro*/
								}
								/*Segun tipo venta*/
								$total_ticket_grabado+=$venta->grabado+$venta->percepcion-$venta->retencion;
								$total_ticket_interno+=$venta->interno+$venta->percepcion-$venta->retencion;
								$total_ticket_exento+=$venta->exento;
								$total_ticket_nosujeto+=$venta->nosujeto;
								$total_trans_ticket++;
								/*primer ticket*/
								if($ticketInicio==="-"){
									$ticketInicio=$venta->documento_numero;
								}
								/*ultimo ticket*/
								$ticketFin=$venta->documento_numero;
							break;
							case 4:/*Nota remision*/
								switch($venta->cobro){
									case 0:$total_contado_nremision+=($venta->total+$venta->percepcion-$venta->retencion);break;/*contado*/
									case 1:$total_credito_nremision+=($venta->total+$venta->percepcion-$venta->retencion);break;/*credito*/
								}
								/*Segun tipo venta*/
								$total_nremision_grabado+=$venta->grabado+$venta->percepcion-$venta->retencion;
								$total_nremision_exento+=$venta->exento;
								$total_nremision_nosujeto+=$venta->nosujeto;
								$total_trans_nremision++;
							break;
							case 5:/*Nota envio*/
								switch($venta->cobro){
									case 0:$total_contado_nenvio+=($venta->total+$venta->percepcion-$venta->retencion);break;/*contado*/
									case 1:$total_credito_nenvio+=($venta->total+$venta->percepcion-$venta->retencion);break;/*credito*/
								}
								/*Segun tipo venta*/
								$total_nenvio_grabado+=$venta->grabado+$venta->percepcion+$venta->retencion;
								$total_nenvio_exento+=$venta->exento;
								$total_nenvio_nosujeto+=$venta->nosujeto;								
								$total_trans_nenvio++;
							break;
							/*6-Recibo, 7-Orden pedido y 8 nota de credito no aplican como documentos de venta*/
						}
					}
					$mensaje_fact.="</tbody></table><em>*No se determinan las usadas en reimpresion</em><br>";
				}
				/*--- CALCULO DE TOTALES PAGOS CREDITOS ---*/
				if(count($pagosCreditos)>0){
					foreach($pagosCreditos as $pago){
						switch($pago->medio){
							case 1: $total_ventas_efectivo+=($pago->total);break;/*ventas efectivo*/
							case 2: $total_ventas_cheque+=($pago->total);break;/*ventas cheques*/
							case 3: $total_ventas_pos+=($pago->total);break;/*ventas POS*/
							case 4: $total_ventas_cuenta+=($pago->total);break;/*ventas abono a cuenta*/
							case 5: $total_ventas_electronico+=($pago->total);break;/*ventas pago electronico*/
						}
						/*Segun documento*/
						switch($pago->documento){
							case 0:/*Sin documento*/
								$total_contado_sdocumento+=$pago->total;
							break;
							case 6:/*Recibo*/
								$total_recibos+=$pago->total;
								if($pago->tipo==1): 
									$total_abonos_cred_contado+=$pago->total;
								elseif($pago->tipo==3):
									$total_abonos_acobro_contado+=$pago->total;
								endif;
							break;
						}
					}
				}
				/*--- CALCULO DE TOTALES DEVOLUCIONES ----*/
				if(count($devoluciones)>0){
					foreach($devoluciones as $devolucion){
						/*segun medio*/
						switch($devolucion->medio){
							case 1: $total_devoluciones_efectivo+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);break;/*devoluciones efectivo*/
							case 2: $total_devoluciones_cheque+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);break;/*devoluciones cheques*/
							case 3: $total_devoluciones_pos+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);break;/*devoluciones POS*/
							case 4: $total_devoluciones_cuenta+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);break;/*devoluciones abono a cuenta*/
							case 5: $total_devoluciones_electronico+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);break;/*devoluciones pago electronico*/
							case 6:
								$total_devoluciones_efectivo+=$devolucion->efectivo;
								$total_devoluciones_pos+=$devolucion->pos;
							break;
						}
						/*Segun documento*/
						switch($devolucion->documento){
							case 0:/*Sin documento*/
								$total_devolucion_sdocumento+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);
								switch($devolucion->tipo){
									case 0:$total_devolucion_sdocumento_contado+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);break;
									case 1:$total_devolucion_sdocumento_credito+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);break;
									case 3:$total_devolucion_sdocumento_acobro+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);break;
								}
							case 1:/*Factura*/
								$total_devolucion_factura+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);
								switch($devolucion->tipo){
									case 0:$total_devolucion_factura_contado+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);break;
									case 1:$total_devolucion_factura_credito+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);break;
									case 3:$total_devolucion_factura_acobro+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);break;
								}
							break;
							case 2:/*CCF*/
								$total_devolucion_ccf+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);
								switch($devolucion->tipo){
									case 0:$total_devolucion_ccf_contado+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);break;
									case 1:$total_devolucion_ccf_credito+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);break;
									case 3:$total_devolucion_ccf_acobro+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);break;
								}
							break;
							case 3:/*Ticket*/
								$total_devolucion_ticket+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);
								switch($devolucion->tipo){
									case 0:$total_devolucion_ticket_contado+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);break;
									case 1:$total_devolucion_ticket_credito+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);break;
									case 3:$total_devolucion_ticket_acobro+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);break;
								}
								/*Transacciones con tickets*/
								$total_trans_ticket_dev++;
								/*Primer ticket*/
								if($devolucion->documento_numero < $ticketInicio){
									$ticketInicio=$devolucion->documento_numero;
								}
								/*Ultimo ticket*/
								if($devolucion->documento_numero > $ticketFin){
									$ticketFin=$devolucion->documento_numero;
								}
							break;
							case 4:/*Nota remision*/
								$total_devolucion_nremision+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);
								switch($devolucion->tipo){
									case 0:$total_devolucion_nremision_contado+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);break;
									case 1:$total_devolucion_nremision_credito+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);break;
								}
							break;
							case 5:/*Nota envio*/
								$total_devolucion_nenvio+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);
								switch($devolucion->tipo){
									case 0:$total_devolucion_nenvio_contado+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);break;
									case 1:$total_devolucion_nenvio_credito+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);break;
								}
							break;
							case 8:/*Nota de credito*/
								$total_devolucion_ncredito+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);
								switch($devolucion->tipo){
									case 0:$total_devolucion_ncredito_contado+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);break;
									case 1:$total_devolucion_ncredito_credito+=($devolucion->total+$devolucion->percepcion-$devolucion->retencion);break;
								}
								$total_trans_ncredito++;
							break;
						}
					}
				}
				/*Ajuste para ticket inicio*/
				if($ticketInicio==="-" && is_numeric($getRes)){
					$ticketInicio=$resolucionTicket->tiraje_actual;
				}				
				$dataCorteFiscal=array(
					"total_sdocumento_grabado"=>$total_sdocumento_grabado,
					"total_sdocumento_exento"=>$total_sdocumento_exento,
					"total_sdocumento_nosujeto"=>$total_sdocumento_nosujeto,
					"total_factura_grabado"=>$total_factura_grabado,
					"total_factura_exento"=>$total_factura_exento,
					"total_factura_nosujeto"=>$total_factura_nosujeto,
					"total_ccf_grabado"=>$total_ccf_grabado,
					"total_ccf_exento"=>$total_ccf_exento,
					"total_ccf_nosujeto"=>$total_ccf_nosujeto,
					"total_ticket_grabado"=>$total_ticket_grabado,
					"total_ticket_interno"=>$total_ticket_interno,
					"total_ticket_exento"=>$total_ticket_exento,
					"total_ticket_nosujeto"=>$total_ticket_nosujeto,
					"total_nremision_grabado"=>$total_nremision_grabado,
					"total_nremision_exento"=>$total_nremision_exento,
					"total_nremision_nosujeto"=>$total_nremision_nosujeto,
					"total_nenvio_grabado"=>$total_nenvio_grabado,
					"total_nenvio_exento"=>$total_nenvio_exento,
					"total_nenvio_nosujeto"=>$total_nenvio_nosujeto,
					"total_devolucion_sdocumento"=>$total_devolucion_sdocumento,
					"total_devolucion_factura"=>$total_devolucion_factura,
					"total_devolucion_ccf"=>$total_devolucion_ccf,
					"total_devolucion_ticket"=>$total_devolucion_ticket,
					"total_devolucion_nremision"=>$total_devolucion_nremision,
					"total_devolucion_nenvio"=>$total_devolucion_nenvio,
					"total_devolucion_ncredito"=>$total_devolucion_ncredito,
					"total_trans_sdocumento"=>$total_trans_sdocumento,
					"total_trans_factura"=>$total_trans_factura,
					"total_trans_ccf"=>$total_trans_ccf,
					"total_trans_ticket"=>$total_trans_ticket,
					"total_trans_ticket_dev"=>$total_trans_ticket_dev,
					"ticketInicio"=>$ticketInicio,
					"ticketFin"=>$ticketFin,
					"total_trans_nremision"=>$total_trans_nremision,
					"total_trans_nenvio"=>$total_trans_nenvio,
					"total_trans_ncredito"=>$total_trans_ncredito
				);
				$dataAnexoMedio=array(
					"total_ventas_efectivo"=>$total_ventas_efectivo,
					"total_ventas_cheque"=>$total_ventas_cheque,
					"total_ventas_pos"=>$total_ventas_pos,
					"total_ventas_cuenta"=>$total_ventas_cuenta,
					"total_ventas_electronico"=>$total_ventas_electronico,
					"total_devoluciones_efectivo"=>$total_devoluciones_efectivo,
					"total_devoluciones_cheque"=>$total_devoluciones_cheque,
					"total_devoluciones_pos"=>$total_devoluciones_pos,
					"total_devoluciones_cuenta"=>$total_devoluciones_cuenta,
					"total_devoluciones_electronico"=>$total_devoluciones_electronico,
					"dotacion"=>$dotacion
				);
				$dataAnexoDocumento=array(
					"total_contado_sdocumento"=>$total_contado_sdocumento,
					"total_devolucion_sdocumento_contado"=>$total_devolucion_sdocumento_contado,
					"total_credito_sdocumento"=>$total_credito_sdocumento,
					"total_devolucion_sdocumento_credito"=>$total_devolucion_sdocumento_credito,
					"total_singreso_sdocumento"=>$total_singreso_sdocumento,
					"total_acobro_sdocumento"=>$total_acobro_sdocumento,
					"total_devolucion_sdocumento_acobro"=>$total_devolucion_sdocumento_acobro,
					"total_contado_factura"=>$total_contado_factura,
					"total_devolucion_factura_contado"=>$total_devolucion_factura_contado,
					"total_credito_factura"=>$total_credito_factura,
					"total_devolucion_factura_credito"=>$total_devolucion_factura_credito,
					"total_singreso_factura"=>$total_singreso_factura,
					"total_acobro_factura"=>$total_acobro_factura,
					"total_devolucion_factura_acobro"=>$total_devolucion_factura_acobro,
					"total_contado_ccf"=>$total_contado_ccf,
					"total_devolucion_ccf_contado"=>$total_devolucion_ccf_contado,
					"total_credito_ccf"=>$total_credito_ccf,
					"total_devolucion_ccf_credito"=>$total_devolucion_ccf_credito,
					"total_singreso_ccf"=>$total_singreso_ccf,
					"total_acobro_ccf"=>$total_acobro_ccf,
					"total_devolucion_ccf_acobro"=>$total_devolucion_ccf_acobro,
					"total_contado_ticket"=>$total_contado_ticket,
					"total_devolucion_ticket_contado"=>$total_devolucion_ticket_contado,
					"total_credito_ticket"=>$total_credito_ticket,
					"total_devolucion_ticket_credito"=>$total_devolucion_ticket_credito,
					"total_singreso_ticket"=>$total_singreso_ticket,
					"total_acobro_ticket"=>$total_acobro_ticket,
					"total_devolucion_ticket_acobro"=>$total_devolucion_ticket_acobro,
					"total_contado_nremision"=>$total_contado_nremision,
					"total_devolucion_nremision_contado"=>$total_devolucion_nremision_contado,
					"total_credito_nremision"=>$total_credito_nremision,
					"total_devolucion_nremision_credito"=>$total_devolucion_nremision_credito,
					"total_contado_nenvio"=>$total_contado_nenvio,
					"total_devolucion_nenvio_contado"=>$total_devolucion_nenvio_contado,
					"total_credito_nenvio"=>$total_credito_nenvio,
					"total_devolucion_nenvio_credito"=>$total_devolucion_nenvio_credito,
					"total_recibos"=>$total_recibos,
					"total_devolucion_ncredito_contado"=>$total_devolucion_ncredito_contado,
					"total_devolucion_ncredito_credito"=>$total_devolucion_ncredito_credito,
					"total_abonos_pedido"=>0
				);
				$dataAnexoTipo=array(
					"total_venta_contado"=>$total_contado_sdocumento+$total_contado_factura+$total_contado_ccf+$total_contado_ticket+$total_contado_nremision+$total_contado_nenvio,
					"total_dev_contado"=>$total_devolucion_sdocumento_contado+$total_devolucion_factura_contado+$total_devolucion_ccf_contado+$total_devolucion_ticket_contado+$total_devolucion_nremision_contado+$total_devolucion_nenvio_contado+$total_devolucion_ncredito_contado,
					"total_abonos_cred_contado"=>$total_abonos_cred_contado,
					"total_abonos_acobro_contado"=>$total_abonos_acobro_contado,
					"total_abonos_pedido_contado"=>0,
					"dotacion_contado"=>$dotacion,
					"total_venta_credito"=>$total_credito_sdocumento+$total_credito_factura+$total_credito_ccf+$total_credito_ticket+$total_credito_nremision+$total_credito_nenvio,
					"total_dev_credito"=>$total_devolucion_sdocumento_credito+$total_devolucion_factura_credito+$total_devolucion_ccf_credito+$total_devolucion_ticket_credito+$total_devolucion_nremision_credito+$total_devolucion_nenvio_credito+$total_devolucion_ncredito_credito,
				);
				$dataCorte['id_caja']=$this->caja->id_caja;
				$dataCorte['id_usuario']=$this->session_['userid'];
				$dataCorte['fecha_corte']=$fecha;
				$dataCorte['correlativo_corte']=$correlativo+1;
				$dataCorte['tipo_corte']=$getType;
				$dataCorte['id_resolucion']=(is_numeric($getRes))?$resolucionTicket->id_resolucion:null;
				$dataCorte['corte_fiscal']=serialize($dataCorteFiscal);
				$dataCorte['corte_anexo1']=serialize($dataAnexoMedio);
				$dataCorte['corte_anexo2']=serialize($dataAnexoDocumento);
				$dataCorte['corte_anexo3']=serialize($dataAnexoTipo);

				$mensaje="";
				if($getType==2){
					$mensaje="";
					$mensaje.="Total ventas ".$this->app_utilities->fechaHoraElSalvador($fecha,1)."<strong> $ ".(($total_ccf_grabado+$total_factura_grabado+$total_ticket_grabado)-($total_devolucion_ticket+$total_devolucion_factura))."</strong><br><br>";
					$sendmail=true;

					/*Total segun medio de pago*/
					$mensaje.="<br><strong>Totales segun Medio de Pago</strong><br>";
					$mensaje.="Efectivo: $".$total_ventas_efectivo."<br>";
					$mensaje.="POS: $".$total_ventas_pos."<br>";

					/*Otros docs*/
					$mensaje.="<br><strong>Transacciones con otros documentos</strong><br>";
					$mensaje.="Transacciones con Facturas: ".$total_trans_factura."<br>";
					$mensaje.="Transacciones con CCF: ".$total_trans_ccf."<br>";
					$mensaje.=$mensaje_fact;

					/*Devoluciones*/
					$mensaje.="<br><strong>Devoluciones</strong><br>";
					$mensaje.="Total Devoluciones: $".$total_devolucion_factura."<br>";

					if($sendmail){
						//$this->app_utilities->send($mensaje,$empresa);
					} 
				}

				$corte=$this->Generic_model->save('cortes',$dataCorte,true);		

				$this->load->view("transacciones_cortes_app_detalles_view",array("id_corte"=>$corte,"corteFiscal"=>$dataCorteFiscal,"anexoMedios"=>$dataAnexoMedio,"anexoDocumento"=>$dataAnexoDocumento,"anexoTipo"=>$dataAnexoTipo));
			}
			/**/
			function vercortes($id=null){
				if($id==null)
					$id=$this->input->get('id');
				$modal=filter_var($this->input->get("modal"),FILTER_VALIDATE_BOOLEAN);
				$corte=$this->Generic_model->get("cortes","*",array("id_corte"=>$id));
				$corte=$corte[0];
				$dataCorte=array(
					"id_corte"=>$id,
					"modal"=>$modal,
					"corteFiscal"=>unserialize($corte->corte_fiscal),
					"anexoMedios"=>unserialize($corte->corte_anexo1),
					"anexoDocumento"=>unserialize($corte->corte_anexo2)
				);
				if($modal){
					$dataCorte["content_view"]="transacciones_cortes_app_detalles_view";
					$this->load->view('template_modal',$dataCorte);
				}else{
					$this->load->view("transacciones_cortes_app_detalles_view",$dataCorte);
				}
			}
			function printcorte(){
				/*--- Obtener configuraciones ---*/
				$configuracioness=$this->Generic_model->get("configuraciones");
				foreach($configuracioness as $config){
					if($config->campo_config=="NombreEmpresa"||$config->campo_config=="RazonSocialEmpresa"||$config->campo_config=="DireccionEmpresa"||$config->campo_config=="TelefonoEmpresa"||$config->campo_config=="NRCEmpresa"||$config->campo_config=="NITEmpresa"||$config->campo_config=="MensajeTicket"||$config->campo_config=="facturacion_actualizar_cliente")
						$configs[$config->campo_config]=$config->valor_config;
				}
				$corte=$this->Generic_model->get("cortes","*",array("id_corte"=>$this->input->get("id")),"","",array("usuarios"=>"usuarios.id_usuario=cortes.id_usuario,LEFT","cajas"=>"cajas.id_caja=cortes.id_corte,LEFT","resoluciones_caja"=>"resoluciones_caja.id_resolucion=cortes.id_resolucion,LEFT"));
				$corte=$corte[0];
				
				$dataPrint['nombre_empresa']=$configs["NombreEmpresa"];
				$dataPrint['rsocial_empresa']=$configs["RazonSocialEmpresa"];
				$dataPrint['direcion_empresa']=$configs["DireccionEmpresa"];
				$dataPrint['telefono_empresa']=$configs["TelefonoEmpresa"];
				$dataPrint['nit_empresa']=$configs["NITEmpresa"];
				$dataPrint['nrc_empresa']=$configs["NRCEmpresa"];

				$dataPrint['doc_desde']=$corte->tiraje_desde;
				$dataPrint['doc_hasta']=$corte->tiraje_hasta;
				$dataPrint['doc_resolucion']=$corte->num_resolucion;
				
				$dataPrint['tipo_corte']=($corte->tipo_corte==0?"X":($corte->tipo_corte==1?"X PARCIAL":($corte->tipo_corte==2?"Z":($corte->tipo_corte==3?"Z MENSUAL":""))));
				$dataPrint['numero_corte']=$corte->correlativo_corte;
				$dataPrint['caja']=$corte->nombre_caja;
				$dataPrint['cajero']=$corte->nombre_usuario;
				$dataPrint['fecha']=$corte->fecha_corte;
				
				$dataPrint['dataCorteFiscal']=unserialize($corte->corte_fiscal);
				$dataPrint['dataAnexoMedio']=unserialize($corte->corte_anexo1);
				$dataPrint['dataAnexoDocumento']=unserialize($corte->corte_anexo2);
				$dataPrint['dataAnexoTipo']=unserialize($corte->corte_anexo3);
				$dataPrint['printCorteFiscal']=filter_var($this->input->get("corte"),FILTER_VALIDATE_BOOLEAN);
				$dataPrint['printAnexoMedio']=filter_var($this->input->get("anexo1"),FILTER_VALIDATE_BOOLEAN);
				$dataPrint['printAnexoDocumento']=filter_var($this->input->get("anexo2"),FILTER_VALIDATE_BOOLEAN);
				$dataPrint['printAnexoTipo']=filter_var($this->input->get("anexo3"),FILTER_VALIDATE_BOOLEAN);
				
				echo json_encode($dataPrint);
				
				//$this->load->view("impresos/transacciones_facturacion_cortes_view",$dataPrint);
			}			
	/*--------------------------- VENTAS ------------------------*/
	function ventas(){
		$UIData['user_info']=$this->usuario;
		$UIData['main_view']="transacciones_ventas_view";
		$UIData['section_title']="Ventas";
		$UIData['jsfiles']=array(
			"miracle.transacciones.tools",
			"miracle.key",
			"miracle.clientes","miracle.transacciones_ventas_nueva",
			"miracle.ventas","miracle.ventasapp",
			"miracle.transacciones_facturacion_app",
			"miracle.clientes",
			"miracle.clientes_lista_mini.min",
			"miracle.productos_inventario_buscar.min"
		);
		$UIData['plugins']=array(
			array(
				"nombre"=>"datatables",
				"css"=> array('dataTables.bootstrap','dataTables.responsive','dataTables.tableTools.min'),
				"js"=> array('jquery.dataTables','dataTables.bootstrap.min','dataTables.responsive','dataTables.tableTools.min')
			),
			array(
				"nombre"=>"iCheck",
				"css"=>array('custom'),
				"js"=>array('icheck.min')
			),
			array(
				"nombre"=>"datapicker",
				"css"=>array('datepicker3'),
				"js"=>array('bootstrap-datepicker','locales/bootstrap-datepicker.es')
			),
			array(
				"nombre"=>"jquery_form",
				"js"=> array('jquery.form.min')
			),
			array(
				"nombre"=>"input-mask",
				"js"=> array('jquery.inputmask')
			)
		);
		$this->load->view('template', $UIData);
	}
		/*--------- APLICACION DE  VENTAS  TEMP ---------*/
		function venta_nueva(){
			$ventaId=$this->input->get('id');
			$UIDataModal["title"]=($ventaId ? "Modificar venta":"Nueva venta");
			if(!filter_var($this->permisos['ventas']['transacciones-registrar-venta'],FILTER_VALIDATE_BOOLEAN)){
				$UIDataModal['content_view']="error_noacceso_view";
			}else{
				$UIDataModal["content_view"]="transacciones_ventas_nueva_view";
				$UIDataModal["close_button"]=true;
				$UIDataModal["classes"]="modal-lg";
				$UIDataModal["id"]="inventario-nueva-entrada-modal";
				$UIDataModal["clientes"]=$this->Generic_model->get('clientes','id_cliente, nombre_cliente, razonsocial_cliente,clasificacion_cliente','',array('nombre_cliente'=>'ASC'));
				if($ventaId){
					$ventaInfo=$this->cargartransaccion("ventatemp",$ventaId,false);	
					$UIDataModal["venta"]=$ventaInfo["load_info"];					
					$UIDataModal["productos"]=$ventaInfo["load_productos"];
				}
			} 
			$this->load->view('template_modal',$UIDataModal);
		}
			/*------- GUARDAR VENTA TEMP --------*/
			function guardarventaapp(){
				$fecha = gmdate('Y-m-d H:i:s', strtotime('- 6 hours'));
				$productos=json_decode($this->input->post('productos'));
				$atotales=json_decode($this->input->post('totales'));
				$totales=array();
				foreach($atotales as $total){
					foreach($total as $key => $value){
						$totales[$key]=$value;
					}
				}
				$vendedor=$this->input->post('vendedor');
				/*vendedor*/
				if($vendedor==''){
					$vendedor=$this->session_['userid'];
				}
				/*Registrar venta*/
				$ventaTransData=array(
					'id_vendedor'=>$vendedor,
					'id_cliente'=>($this->input->post('cliente')!=''?$this->input->post('cliente'):null),
					'nombre_cliente'=>$this->input->post('clientetxt'),
					'dui_cliente'=>$this->input->post('dui'),
					'nit_cliente'=>$this->input->post('nit'),
					'nrc_cliente'=>$this->input->post('nrc'),
					'fecha_venta_trans'=>$fecha,
					'estado_venta_trans'=>0,
					'descargo_venta'=>2,
					'subtotal_venta_trans'=>$totales['totalGrabadas'],
					'total_nosujeto_venta_trans'=>$totales['totalNS'],
					'total_exento_venta_trans'=>$totales['totalExento'],
					'documento_venta_trans'=>$this->input->post('documento'),
					'cobro_venta_trans'=>$this->input->post('condicion')
				);
				
				if($this->input->post('idventa')!=''){
					$this->Generic_model->update('ventas_trans',$ventaTransData,'id_venta_trans',$this->input->post('idventa'));
					$ventatrans=$this->input->post('idventa');
				}else{
					$ventatrans=$this->Generic_model->save('ventas_trans',$ventaTransData,true);
				}
				
				/*registrar productos*/
				$productoslist = array();
				foreach($productos as $producto){
					$productoslist[] = array(
						'id_venta_trans'=>$ventatrans,
						'id_producto'=>$producto->id,
						'id_presentacion'=>$producto->pre,
						'cantidad_producto'=>$producto->cant,
						'precio_producto'=>$producto->costo
					);
				}
				
				if($this->input->post('idventa')!=''){
					$this->Generic_model->delete('productosxventastrans','id_venta_trans',$this->input->post('idventa'));
				}
				$this->Generic_model->savebatch('productosxventastrans',$productoslist);
				echo $ventatrans;
			}
			function cargar_ventas(){
				$this->load->library("ssp");
			
				$table = 'ventas_trans';
				$primaryKey = 'id_venta_trans';
				
				$columns = array(
					array( 'db' => '`vt`.`id_venta_trans`', 'dt' => 0, 'field' => 'id_venta_trans' ),
					array( 'db' => '`vt`.`fecha_venta_trans`', 'dt' => 1, 'field' => 'fecha_venta_trans', 'formatter' => function( $d, $row ) {
						$dateConvert = explode('-',$d);
						$timeConvert = explode(' ',$dateConvert[2]);
						return $timeConvert[0].' de '.$this->TraducirMes($dateConvert[1]).' del '.$dateConvert[0].' a las '.$timeConvert[1];
					}),
					array(
						'db' => '`vt`.`id_cliente`',
						'dt' => 2,
						'field' => 'id_cliente',
						'formatter' => function( $d, $row ) {
							if($d != ""){
								return $row[5];
							}else{
								return $row[6];
							}
						}
					),
					array( 'db' => '`us`.`nombre_usuario`', 'dt' => 3, 'field' => 'nombre_usuario' ),
					array(
						'db' => '`vt`.`id_venta_trans`',
						'dt' => 4,
						'field' => 'id_venta_trans',
						'formatter' => function( $d, $row ) {
							return '<button class="btn btn-info btn-xs" onclick="ventasapp.facturar('.$d.')">Facturar</button> <button class="btn btn-warning btn-xs" onclick="ventasapp.modificar('.$d.')">Modificar</button> <button class="btn btn-danger btn-xs"  onclick="ventasapp.eliminar('.$d.')">Eliminar</button>';
						}
					),
					array( 'db' => '`cl`.`nombre_cliente`', 'dt' => 5, 'field' => 'nombre_cliente' ),
					array( 'db' => '`vt`.`nombre_cliente`', 'dt' => 6, 'field' => 'nombre_cliente' ),
				);
				$host =  explode(':',$this->db->hostname);
				$sql_details = array(
					'user' => $this->db->username,
					'pass' => $this->db->password,
					'db'   => $this->db->database,
					'host' => $host[0]
				);
				
				$joinQuery = "FROM `ventas_trans` AS `vt` LEFT OUTER JOIN `clientes` AS `cl` ON (`cl`.`id_cliente` = `vt`.`id_cliente`) LEFT OUTER JOIN `usuarios` AS `us` ON (`us`.`id_usuario` = `vt`.`id_vendedor`)";
				$extraWhere = "estado_venta_trans = 0";
				$groupBy = '';
				 
				echo json_encode(
					$this->ssp->simple( $this->input->post(), $sql_details, $table, $primaryKey, $columns, $joinQuery, $extraWhere,$groupBy)
				);
			}
	/*------------------------- COTIZACIONES ----------------------*/
	function cotizaciones(){
		$UIData['user_info']=$this->usuario;
		$UIData['main_view']	= "transacciones_cotizaciones_view";
		$UIData['section_title']	= "Cotizaciones";
		$UIData['jsfiles']=array(
			"miracle.transacciones.tools",
			"miracle.key",
			"miracle.cotizaciones",
			"miracle.transacciones_facturacion_app",
			"miracle.ventas",
			"miracle.clientes",
			"miracle.productos_inventario_buscar.min");
		$UIData['plugins']=array(
			array(
				"nombre"=>"datatables",
				"css"=> array('dataTables.bootstrap','dataTables.responsive','dataTables.tableTools.min'),
				"js"=> array('jquery.dataTables','dataTables.bootstrap.min','dataTables.responsive','dataTables.tableTools.min')
			),
			array(
				"nombre"=>"chosen",
				"css"=> array('chosen'),
				"js"=> array('chosen.jquery')
			),
			array(
				"nombre"=>"iCheck",
				"css"=>array('custom'),
				"js"=>array('icheck.min')
			),
			array(
				"nombre"=>"datapicker",
				"css"=>array('datepicker3'),
				"js"=>array('bootstrap-datepicker','locales/bootstrap-datepicker.es')
			),
			array(
				"nombre"=>"input-mask",
				"js"=> array('jquery.inputmask')
			)
		);
		$this->load->view('template', $UIData);
	}
		function cotizacion_nueva(){
			if(!filter_var($this->permisos['cotizaciones']['transacciones-registrar-cotizaciones'],FILTER_VALIDATE_BOOLEAN)){
				$UIDataModal['content_view']="error_noacceso_view";
				$UIDataModal["title"]="Cotizaciones";
			}else{
				$cotizacionId=$this->input->get('id');
				$title=($cotizacionId ? "Modificar cotizaci&oacute;n":"Nueva cotizaci&oacute;n");
				$firmante=$this->Generic_model->get('usuarios','nombre_usuario as nombre',array('id_usuario'=>$this->session_['userid']));
				$UIDataModal["content_view"]= "transacciones_cotizaciones_nueva_view";
				$UIDataModal["title"]=$title;
				$UIDataModal["close_button"]=true;
				$UIDataModal["classes"]="modal-lg";
				$UIDataModal["id"]="inventario-nueva-entrada-modal";
				$UIDataModal["clientes"]=$this->Generic_model->get('clientes','id_cliente, nombre_cliente, razonsocial_cliente,clasificacion_cliente','',array('nombre_cliente'=>'ASC'));
				$UIDataModal["firmante"]= $firmante[0]->nombre;
				if($cotizacionId){
					$cotizacion=$this->cargartransaccion("cotizacion",$cotizacionId,false);		
					$UIDataModal["cotizacion"]=$cotizacion["load_info"];
					$UIDataModal["productos"]=$cotizacion["load_productos"];
					$cotizacion_=$this->Generic_model->get("cotizaciones","*",array("id_cotizacion"=>$cotizacionId));
					$UIDataModal['detalles'] = unserialize($cotizacion_[0]->detalles_cotizacion);
				}
			}
			$this->load->view('template_modal',$UIDataModal);
		}
			function guardarcotizacion(){
				$configs = array(
					"detalles" => array(
						"preciosconiva"			=>filter_var($this->input->post('preciosconiva'),FILTER_VALIDATE_BOOLEAN),
						"precioscontrans"		=>filter_var($this->input->post('precioscontrans'),FILTER_VALIDATE_BOOLEAN),
						"firmacliente"			=>filter_var($this->input->post('firmacliente'),FILTER_VALIDATE_BOOLEAN),
						"chequebool"			=>filter_var($this->input->post('chequebool'),FILTER_VALIDATE_BOOLEAN),
						"chequetext"			=>$this->input->post('chequetext'),
						"validezbool"			=>filter_var($this->input->post('validezbool'),FILTER_VALIDATE_BOOLEAN),
						"valideztext"			=>$this->input->post('valideztext'),
						"observacionesbool"		=>filter_var($this->input->post('observacionesbool'),FILTER_VALIDATE_BOOLEAN),
						"observacionestext"		=>$this->input->post('observacionestext'),
						"garantiabool"			=>filter_var($this->input->post('garantiabool'),FILTER_VALIDATE_BOOLEAN),
						"garantiatext"			=>$this->input->post('garantiatext'),
						"fletebool"				=>filter_var($this->input->post('fletebool'),FILTER_VALIDATE_BOOLEAN),
						"fletetext"				=>$this->input->post('fletetext'),
						"formapagobool"			=>filter_var($this->input->post('formapagobool'),FILTER_VALIDATE_BOOLEAN),
						"formapagotext"			=>$this->input->post('formapagotext'),
						"periodobool"			=>filter_var($this->input->post('periodobool'),FILTER_VALIDATE_BOOLEAN),
						"periodotext"			=>$this->input->post('periodotext'),
					),
				);
				
				$action=$this->input->post('action');
				$productos=json_decode($this->input->post('productos'));
				$atotales=json_decode($this->input->post('totales'));
				$totales=array();
				foreach($atotales as $total){
					foreach($total as $key => $value){
						$totales[$key]=$value;
					}
				}
				$cotizacionData=array(
					'id_cliente'=>$this->input->post('cliente'),
					'id_vendedor'=>$this->session_['userid'],
					'fecha_cotizacion'=>$this->input->post('fecha'),
					'subtotal_cotizacion'=>$totales['totalGrabadas'],
					'total_nosujeto_cotizacion'=>$totales['totalNS'],
					'total_exento_cotizacion'=>$totales['totalExento'],
					'notas_cotizacion'=>$this->input->post('notas'),
					'firma_cotizacion'=>$this->input->post('firmante'),
					'detalles_cotizacion'=> serialize($configs)
				);	
				
				if($action=='update'){
					$this->Generic_model->update('cotizaciones',$cotizacionData,'id_cotizacion',$this->input->post('id'));
					$this->Generic_model->delete('productosxcotizacion','id_cotizacion',$this->input->post('id'));
					$cotizacion=$this->input->post('id');
				}else{
					$cotizacion=$this->Generic_model->save('cotizaciones',$cotizacionData,true);
				}
				$productoslist = array();
				foreach($productos as $producto){
					$productoslist[] = array(
						'id_cotizacion'=>$cotizacion,
						'id_producto'=>$producto->id,
						'id_presentacion'=>$producto->pre,
						'cantidad_producto'=>$producto->cant,
						'precio_producto'=>$producto->costo
					);
				}
				$this->Generic_model->savebatch('productosxcotizacion',$productoslist);
				echo $cotizacion;
			}
			function eliminarcotizacion(){
				echo $this->Generic_model->delete('cotizaciones','id_cotizacion',$this->input->get('id'));
			}
		function cargar_cotizaciones(){
			$this->load->library("ssp");
			$table = 'cotizaciones';
			$primaryKey = 'id_cotizacion';
			
			$columns = array(
				array( 'db' => '`co`.`fecha_cotizacion`', 'dt' => 0, 'field' => 'fecha_cotizacion', 'formatter' => function( $d, $row ) {
					$dateConvert = explode('-',$d);
					$timeConvert = explode(' ',$dateConvert[2]);
					return $timeConvert[0].' de '.$this->TraducirMes($dateConvert[1]).' del '.$dateConvert[0].' a las '.$timeConvert[1];
				}),
				array( 'db' => '`cl`.`nombre_cliente`', 'dt' => 1, 'field' => 'nombre_cliente' ),
				array( 'db' => '`us`.`nombre_usuario`', 'dt' => 2, 'field' => 'nombre_usuario' ),
				array(
					'db' => '`co`.`id_cotizacion`',
					'dt' => 3,
					'field' => 'id_cotizacion',
					'formatter' => function( $d, $row ) {
						$btnStmt='<button class="btn btn-primary btn-xs " onclick="cotizaciones.facturar('.$d.')">Facturar</button> <a class="btn btn-info btn-xs" target="_blank" href="'.base_url().'reportes/reporte_cotizacion?id='.$d.'">Exportar</a> <button class="btn btn-warning btn-xs " onclick="cotizaciones.modificar('.$d.')">Modificar</button>';
						if(filter_var($this->permisos['cotizaciones']['transacciones-eliminar-cotizaciones'],FILTER_VALIDATE_BOOLEAN)){
							$btnStmt.=' <button class="btn btn-danger btn-xs" onclick="cotizaciones.eliminar('.$d.')">Eliminar</button>';
						}else{
							$btnStmt.=' <button class="btn btn-danger btn-xs" onclick="error_noacces()">Eliminar</button>';
						}
						return $btnStmt;
					}
				),
			);
			$host =  explode(':',$this->db->hostname);
			$sql_details = array(
				'user' => $this->db->username,
				'pass' => $this->db->password,
				'db'   => $this->db->database,
				'host' => $host[0]
			);
			
			$joinQuery = "FROM `cotizaciones` AS `co` LEFT OUTER JOIN `usuarios` AS `us` ON (`us`.`id_usuario` = `co`.`id_vendedor`) LEFT OUTER JOIN `clientes` AS `cl` ON (`cl`.`id_cliente` = `co`.`id_cliente`)";
			$extraWhere = "";
			 
			echo json_encode(
				$this->ssp->simple( $this->input->post(), $sql_details, $table, $primaryKey, $columns, $joinQuery, $extraWhere)
			);
		}
		
		function TraducirMes($month){
			switch($month){
				case '01':
						return $mes = 'Enero';
					break;
				case '02':
						return $mes = 'Febrero';
					break;
				case '03':
						return $mes = 'Marzo';
					break;
				case '04':
						return $mes = 'Abril';
					break;
				case '05':
						return $mes = 'Mayo';
					break;
				case '06':
						return $mes = 'Junio';
					break;
				case '07':
						return $mes = 'Julio';
					break;
				case '08':
						return $mes = 'Agosto';
					break;
				case '09':
						return $mes = 'Septiembre';
					break;
				case '10':
						return $mes = 'Octubre';
					break;
				case '11':
						return $mes = 'Noviembre';
					break;
				case '12':
						return $mes = 'Diciembre';
					break;
			}
		}
		function getDocById($id){
			$doc="Desconocido";
			switch(intval($id)){
				case 0:$doc="S/Documento";break;
				case 1:$doc='Factura';break;
				case 2:$doc='Comprobante de Crédito Fiscal';break;
				case 3:$doc='Ticket';break;
				case 4:$doc='Nota de remisión';break;
				case 5:$doc='Nota de envío';break;
				case 6:$doc='Recibo';break;
				case 7:$doc='Orden de pedido';break;
				case 8:$doc='Nota de crédito';break;
				default:$doc="Desconocido (".$id.")";break;
			}
			return $doc;
		}
		function is_logged_in(){
			$session = $this->session->userdata('userInfo');
			$is_logged_in =$session['is_logged_in'];
			
			if(!isset($is_logged_in) || $is_logged_in !== true){
				redirect(base_url("login"));
				die();
			}
		}
		function get_caja($ip){
			$caja=$this->Generic_model->get('cajas','*',array('direccion_ip_caja'=>$ip));
			if(count($caja)>0)
				return $caja[0];
			else
				return null;
		}
	/*----------- APLICACION DE CAJA CHICA -------------*/
	function cajachica(){
		if(!$this->caja){
			$UIDataModal["content_view"]="error_nocaja_view";
			$UIDataModal["title"]="Error: Caja desconocida";
		}else{
			/* if($this->caja->estado_caja==1){
				$UIDataModal["content_view"]="error_caja_inactiva_view";
				$UIDataModal["title"]="Error: Caja inactiva";
			}else{
				
			} */
			$UIDataModal["title"]="Caja Chica";
			if(!filter_var($this->permisos['facturacion']['transacciones-cortes'],FILTER_VALIDATE_BOOLEAN)){
				$UIDataModal['content_view']="error_noacceso_view";
			}else{
				$cajachica=$this->Generic_model->get('cajachica',"*","","","",array("cortes_cajachica"=>"cortes_cajachica.id_corte=cajachica.corte_cajachica,left outer"));
				$UIDataModal["cajachica"] = $cajachica[0];
				
				$UIDataModal["content_view"]="transacciones_caja_chica_app_view";
				$UIDataModal["close_button"]=true;
				$UIDataModal["classes"]="modal-lg";
				$UIDataModal["id"]="cajachica-app-modal";
				$UIDataModal["caja"]=$this->caja->id_caja;
				$UIDataModal["caja_estado"]=$this->caja->estado_caja;
			}
		}
		$this->load->view('template_modal',$UIDataModal);
	}
		function abrir_cajachica(){
			$fecha = gmdate('Y-m-d H:i:s', strtotime('- 6 hours'));
			$correlativo=1;
			
			$lastCorte=$this->Generic_model->get('cortes_cajachica','*',array('cajachica'=>$this->input->post("id")),array("id_corte"=>"DESC"),"","",1);
			if(count($lastCorte)):
				$correlativo=$lastCorte[0]->correlativo_corte+1;
			endif;
			$corte=array(
				"fecha_corte"=>$fecha,
				"desde_corte"=>$fecha,
				"correlativo_corte"=>$correlativo,
				"estado_corte"=>0,
				"id_usuario"=>$this->session_['userid'],
				"cajachica"=>$this->input->post("id")
			);
			
			$idcorte=$this->Generic_model->save('cortes_cajachica',$corte,true);
			
			$this->Generic_model->update('cajachica',array("estado_cajachica"=>1,"corte_cajachica"=>$idcorte),'id_cajachica',$this->input->post('id'));
			
			if($this->input->post("dotacion")>0 && $this->input->post("dotacion")!=""){
				$transaccion=array(
					"fecha_transaccion"=>$fecha,
					"id_usuario"=>$this->session_['userid'],
					"id_cajachica"=>$this->input->post("id"),
					"tipo_transaccion"=>0,
					"concepto_transaccion"=>"Dotacion inicial",
					"monto_transaccion"=>$this->input->post("dotacion")
				);
				$this->Generic_model->save('transaccionesxcajachica',$transaccion);
			}
			
			echo $fecha;
		}
		function cerrar_cajachica(){
			$fecha = gmdate('Y-m-d H:i:s', strtotime('- 6 hours'));
			$caja=$this->Generic_model->get('cajachica','*',array('id_cajachica'=>$this->input->post("id")));
			
			$this->Generic_model->update('cajachica',array("estado_cajachica"=>0),'id_cajachica',$this->input->post('id'));
			$this->Generic_model->update('cortes_cajachica',array("estado_corte"=>1,"hasta_corte"=>$fecha),'id_corte',$caja[0]->corte_cajachica);
			
			echo $fecha;
		}
		function exportar_corte(){
			$cutBy=$this->input->get("by");
			$gastos=filter_var($this->input->get("gastos"),FILTER_VALIDATE_BOOLEAN);
			$ingresos=filter_var($this->input->get("ingresos"),FILTER_VALIDATE_BOOLEAN);
			$ingresos_resumen=filter_var($this->input->get("ingresos_resumen"),FILTER_VALIDATE_BOOLEAN);
			$ingresos_doc_sd=filter_var($this->input->get("ingresos_doc_sd"),FILTER_VALIDATE_BOOLEAN);
			$ingresos_doc_factura=filter_var($this->input->get("ingresos_doc_factura"),FILTER_VALIDATE_BOOLEAN);
			$ingresos_doc_ticket=filter_var($this->input->get("ingresos_doc_ticket"),FILTER_VALIDATE_BOOLEAN);
			$ingresos_doc_ccf=filter_var($this->input->get("ingresos_doc_ccf"),FILTER_VALIDATE_BOOLEAN);
			$ingresos_doc_resumen=filter_var($this->input->get("ingresos_doc_resumen"),FILTER_VALIDATE_BOOLEAN);
			
			$selectsTrans="concepto_transaccion,monto_transaccion,fecha_transaccion";
			
			if($cutBy=="caja"){
				$cajachica = $this->Generic_model->get('cajachica',"*",array("id_cajachica"=>$this->input->get("id")),"","",array("cortes_cajachica"=>"cortes_cajachica.id_corte=cajachica.corte_cajachica"));
				$cajachica = $cajachica[0];
				$estado = $cajachica->estado_corte;
				
				$fechadesde=$this->input->get("fecha_desde");
				$fechahasta=$this->input->get("fecha_hasta");
			}else{
				$corte = $this->Generic_model->get('cortes_cajachica',"*",array("id_corte"=>$this->input->get("id")));
				$corte = $corte[0];
				$estado = $corte->estado_corte;
				
				$fechadesde=$this->input->get("fecha_desde");
				$fechahasta=$this->input->get("fecha_hasta");
			}
			
			$dataReport["fechadesde"]=$fechadesde;
			$dataReport["fechahasta"]=$fechahasta;
			$dataReport["ingresos_resumen"]=$ingresos_resumen;
			$dataReport["ingresos_doc_resumen"]=$ingresos_doc_resumen;
			
			if($estado==0){
				$wheresTrans = array("DATE(fecha_transaccion) >="=>$fechadesde,"DATE(fecha_transaccion) <="=>$fechahasta,"concepto_transaccion !="=>"Dotacion inicial");
				$wheresVentas = array("fecha_salida >="=>$fechadesde);
			}else{
				$wheresTrans = array("DATE(fecha_transaccion) >="=>$fechadesde,"DATE(fecha_transaccion) <="=>$fechahasta,"concepto_transaccion !="=>"Dotacion inicial");
				$wheresVentas = array("fecha_salida >="=>$fechadesde,"fecha_salida <="=>$fechahasta);
			}
			
			/*Transacciones de Caja Chica*/
			if($ingresos_resumen){
				if($gastos){
					$wheresTrans["tipo_transaccion"]=1;
					$dataReport["gastosDataResumen"] = $this->Generic_model->get('transaccionesxcajachica',"SUM(monto_transaccion) as Total",$wheresTrans);
				}
				if($ingresos){
					$wheresTrans["tipo_transaccion"]=0;
					$dataReport["ingresosDataResumen"] = $this->Generic_model->get('transaccionesxcajachica',"SUM(monto_transaccion) as Total",$wheresTrans);
				}
			}else{
				if($gastos){
					$wheresTrans["tipo_transaccion"]=1;
					$dataReport["gastosData"] = $this->Generic_model->get('transaccionesxcajachica',$selectsTrans,$wheresTrans);
				}
				if($ingresos){
					$wheresTrans["tipo_transaccion"]=0;
					$dataReport["ingresosData"] = $this->Generic_model->get('transaccionesxcajachica',$selectsTrans,$wheresTrans);
				}
			}
			
			/*Ventas*/
			$joinsVentas = array(
				"ventas"=>"ventas.id_venta=salida_productos.id_venta",
				"presentaciones"=>"presentaciones.id_presentacion=salida_productos.id_presentacion",
				"productos"=>"productos.id_producto=salida_productos.id_producto",
			);
			$wheresVentas["estado_venta"]=1;
			$wheresVentas["concepto_salida"]=0;
			$selectsVentas="num_doc_salida,desc_presentacion,cant_salida,costo_salida,exist_act_producto,forma_pago_venta";
			
			if($ingresos_doc_resumen){
				if($ingresos_doc_sd){
					$wheresVentas["documento_venta"]=0;
					$dataReport["ingresosSDdataResumen"] = $this->Generic_model->get('salida_productos',"SUM(cant_salida*costo_salida) as Total",$wheresVentas,"","",$joinsVentas);
				}
				if($ingresos_doc_factura){
					$wheresVentas["documento_venta"]=1;
					$dataReport["ingresosFACdataResumen"] = $this->Generic_model->get('salida_productos',"SUM(cant_salida*costo_salida) as Total",$wheresVentas,"","",$joinsVentas);
				}
				if($ingresos_doc_ccf){
					$wheresVentas["documento_venta"]=2;
					$dataReport["ingresosCCFdataResumen"] = $this->Generic_model->get('salida_productos',"SUM((cant_salida*costo_salida)+(cant_salida*costo_salida)*0.13) as Total",$wheresVentas,"","",$joinsVentas);
				}
				if($ingresos_doc_ticket){
					$wheresVentas["documento_venta"]=3;
					$dataReport["ingresosTICKdataResumen"] = $this->Generic_model->get('salida_productos',"SUM(cant_salida*costo_salida) as Total",$wheresVentas,"","",$joinsVentas);
				}
			}else{
				if($ingresos_doc_sd){
					$wheresVentas["documento_venta"]=0;
					$dataReport["ingresosSDdata"] = $this->Generic_model->get('salida_productos',$selectsVentas,$wheresVentas,"","",$joinsVentas);
				}
				if($ingresos_doc_factura){
					$wheresVentas["documento_venta"]=1;
					$dataReport["ingresosFACdata"] = $this->Generic_model->get('salida_productos',$selectsVentas,$wheresVentas,"","",$joinsVentas);
				}
				if($ingresos_doc_ccf){
					$wheresVentas["documento_venta"]=2;
					$dataReport["ingresosCCFdata"] = $this->Generic_model->get('salida_productos',$selectsVentas,$wheresVentas,"","",$joinsVentas);
				}
				if($ingresos_doc_ticket){
					$wheresVentas["documento_venta"]=3;
					$dataReport["ingresosTICKdata"] = $this->Generic_model->get('salida_productos',$selectsVentas,$wheresVentas,"","",$joinsVentas);
				}
			}
			
			$configuraciones = $this->Generic_model->get('configuraciones');
			$configs = array();		
			foreach($configuraciones as $config){
				$configs[$config->campo_config] = $config->valor_config;
			}			
			$dataReport['configs'] = $configs;
			
			$this->load->view('reportes/reporte_cajachica_pdf',$dataReport);
		}
		function guardar_transaccion_cajachica(){
			$fecha = gmdate($this->input->post('fecha').' H:i:s',strtotime('- 6 hours'));
			$transaccion=array(
				"fecha_transaccion"=>$fecha,
				"id_usuario"=>$this->session_['userid'],
				"id_cajachica"=>$this->input->post("id"),
				"tipo_transaccion"=>$this->input->post("tipo"),
				"concepto_transaccion"=>$this->input->post("concepto"),
				"monto_transaccion"=>$this->input->post("monto"),
			);
			echo $this->Generic_model->save('transaccionesxcajachica',$transaccion);
		}
		function cargar_transaccionesxcajachica(){
			$idcaja=$this->input->get("id");
			$desde=$this->input->get("desde");
			$hasta=$this->input->get("hasta");
			$data["idcaja"]=$idcaja;
			$caja=$this->Generic_model->get('cajachica','*',array('id_cajachica'=>$idcaja),"","",array("cortes_cajachica"=>"cortes_cajachica.id_corte=cajachica.corte_cajachica"));
			if($caja){
				if($caja[0]->estado_corte==0){
					$wheres = array("fecha_transaccion >="=>$desde,"fecha_transaccion <="=>$hasta,"concepto_transaccion !="=>"Dotacion inicial");
				}else{
					$wheres = array("fecha_transaccion >="=>$desde,"fecha_transaccion <="=>$hasta,"concepto_transaccion !="=>"Dotacion inicial");
				}
				$data["transacciones"]=$this->Generic_model->get("transaccionesxcajachica","*",$wheres);
			}
			$this->load->view('transacciones_caja_chica_cortes_transacciones_view',$data);
		}
			function eliminar_transaccion(){
				echo $this->Generic_model->delete('transaccionesxcajachica','id_transaccion',$this->input->get('id'));
			}
		function cortes_cajachica(){
			$UIDataModal["title"]="Cortes Caja Chica";
			$UIDataModal["content_view"]="transacciones_caja_chica_cortes_view";
			$UIDataModal["close_button"]=true;
			$UIDataModal["classes"]="modal-lg";
			$UIDataModal["id"]="cajachica-cortes-modal";
			
			$this->load->view('template_modal',$UIDataModal);
		}
			function cargar_cortes_cajachica(){
				$this->load->library("ssp");
				$table = 'cortes_cajachica';
				$primaryKey = 'id_corte';
				
				$columns = array(
					array( 'db' => '`co`.`correlativo_corte`', 'dt' => 0, 'field' => 'correlativo_corte' ),
					array( 'db' => '`co`.`fecha_corte`', 'dt' => 1, 'field' => 'fecha_corte', 'formatter' => function( $d, $row ) {
						$dateConvert = explode('-',$d);
						$timeConvert = explode(' ',$dateConvert[2]);
						return $timeConvert[0].' de '.$this->TraducirMes($dateConvert[1]).' del '.$dateConvert[0].' a las '.$timeConvert[1];
					}),
					array( 'db' => '`us`.`nombre_usuario`', 'dt' => 2, 'field' => 'nombre_usuario' ),
					array( 'db' => '`co`.`desde_corte`', 'dt' => 3, 'field' => 'desde_corte', 'formatter' => function( $d, $row ) {
						$dateConvert = explode('-',$d);
						$timeConvert = explode(' ',$dateConvert[2]);
						return $timeConvert[0].' de '.$this->TraducirMes($dateConvert[1]).' del '.$dateConvert[0].' a las '.$timeConvert[1];
					}),
					array( 'db' => '`co`.`hasta_corte`', 'dt' => 4, 'field' => 'hasta_corte', 'formatter' => function( $d, $row ) {
						if($d!=""){
							$dateConvert = explode('-',$d);
							$timeConvert = explode(' ',$dateConvert[2]);
							return $timeConvert[0].' de '.$this->TraducirMes($dateConvert[1]).' del '.$dateConvert[0].' a las '.$timeConvert[1];							
						}
					}),
					array(
						'db' => '`co`.`id_corte`',
						'dt' => 5,
						'field' => 'id_corte',
						'formatter' => function( $d, $row ) {
							$btnStmt='<button class="btn btn-primary btn-xs" data-id="'.$d.'">Exportar</button>';
							
							return $btnStmt;
						}
					),
					array(
						'db' => '`co`.`id_corte`',
						'dt' => 6,
						'field' => 'id_corte',
						'formatter' => function( $d, $row ) {
							$btnStmt='<button class="btn btn-danger btn-xs" data-id="'.$d.'">Eliminar</button>';
							
							return $btnStmt;
						}
					),
				);
				$host =  explode(':',$this->db->hostname);
				$sql_details = array(
					'user' => $this->db->username,
					'pass' => $this->db->password,
					'db'   => $this->db->database,
					'host' => $host[0]
				);
				
				$joinQuery = "FROM `cortes_cajachica` AS `co` LEFT OUTER JOIN `usuarios` AS `us` ON (`us`.`id_usuario` = `co`.`id_usuario`)";
				$extraWhere = "";
				 
				echo json_encode(
					$this->ssp->simple( $this->input->post(), $sql_details, $table, $primaryKey, $columns, $joinQuery, $extraWhere)
				);
			}
}
?>