<?php
class Reportes extends CI_Controller{
	function __construct(){
		parent::__construct();
		$this->is_logged_in();
		$this->session_ = $this->session->userdata('userInfo');
		$this->permisos=$this->Generic_model->get('usuarios','permisos_usuario',array('id_usuario'=>$this->session_['userid']));
		$this->permisos=unserialize(base64_decode($this->permisos[0]->permisos_usuario));
		/*usuario*/
		$this->usuario=$this->Generic_model->get('usuarios','nombre_usuario as nombre,username_usuario as username, thumb_usuario as thumbnail',array('id_usuario'=>$this->session_['userid']));
		$this->usuario=$this->usuario[0];
		
		$this->configuraciones = $this->Generic_model->get('configuraciones');
		$configs = array();		
		foreach($this->configuraciones as $config){
			$configs[$config->campo_config] = $config->valor_config;
		}
		$this->configuraciones = $configs;
	}
	/**/
    function index(){echo "Reportes!";}
    /*------------------------- INVENTARIOS ----------------------*/
	function reporte_inventario_excel(){
	    $productos = $this->Generic_model->get("productos","*",array(/*"exist_act_producto >"=>0,*/"precio_identificador"=>1),"","",array("presentaciones"=>"presentaciones.id_producto=productos.id_producto","preciosxpresentacion"=>"preciosxpresentacion.id_presentacion=presentaciones.id_presentacion"));
		if($productos && count($productos)){
		    foreach($productos as $producto){
		        $SQLStm="SELECT (costo_entrada/unidades_representativas) as costo, ultimocosto_producto FROM entrada_productos LEFT JOIN presentaciones ON presentaciones.id_presentacion = entrada_productos.id_presentacion LEFT JOIN productos ON productos.id_producto = entrada_productos.id_producto WHERE entrada_productos.id_producto = ".$producto->id_producto." AND (concepto_entrada = 0 OR concepto_entrada = 1 OR concepto_entrada = 9)ORDER BY fecha_entrada LIMIT 1";
		        $ultimo_costo=$this->Generic_model->sql_custom($SQLStm);
		        $ultimo_costo=(isset($ultimo_costo[0])?$ultimo_costo[0]->costo:$ultimo_costo[0]->ultimocosto_producto);
		        $producto->ultimocosto_producto=$ultimo_costo;
		    }
		}
		$data["productos"] = $productos;
		$data['configs']=$this->configuraciones;
		$this->load->view('reportes/reporte_inventario_excel_view',$data);
	}
	function reporte_venta(){
		$ventas = $this->Generic_model->get("ventas","*",array("id_venta"=>$this->input->get("id")));
		foreach($ventas as $venta):
			$venta->productos = $this->Generic_model->get("salida_productos","*",array("id_venta"=>$venta->id_venta),"","",array("presentaciones"=>"presentaciones.id_presentacion=salida_productos.id_presentacion"));
		endforeach;

        $data["venta"] = $ventas[0];
		$data['configs']=$this->configuraciones;
		/* echo "<pre>";
			print_r($ventas);
		echo "</pre>"; */
        $this->load->view('reportes/reporte_venta_pdf',$data);
	}
	/*------------------------- VENTAS ----------------------*/
	function graficos_ventas(){
		$UIData['user_info']=$this->usuario;
		$UIData['main_view']	= "reportes_graficos_ventas_view";
		$UIData['section_title']	= "Grafico de ventas";
		$UIData['plugins']=array(
			array(
				"nombre"=>"datapicker",
				"css"=>array('datepicker3'),
				"js"=>array('bootstrap-datepicker','locales/bootstrap-datepicker.es')
			),
			array(
				"nombre"=>"highcharts",
				"js"=>array('highcharts','exporting','data','drilldown')
			),
			array(
				"nombre"=>"iCheck",
				"css"=>array('custom'),
				"js"=>array('icheck.min')
			),
			array(
				"nombre"=>"datatables",
				"css"=> array('dataTables.bootstrap','dataTables.responsive','dataTables.tableTools.min'),
				"js"=> array('jquery.dataTables','dataTables.bootstrap.min','dataTables.responsive','dataTables.tableTools.min')
			),
		);
		$this->load->view('template', $UIData);
	}
		function grafico_ventas(){
			if(!filter_var($this->permisos['reportesventas']['reportesventas-ventas'],FILTER_VALIDATE_BOOLEAN)){
				$this->load->view("error_noacceso_view");
			}else{
				$data["valores"] = $this->input->get("valores");
				
				if($this->input->get("tipo") == "mensual"){
					$sql = 'SELECT DATE_FORMAT(`fecha_venta`, "%m-%Y") as Fecha, SUM(`subtotal_venta`) + SUM(`iva_venta`) + SUM(`retencion_venta`) + SUM(`percepcion_venta`) + SUM(`total_nosujeto_venta`) + SUM(`total_exento_venta`) as Total FROM `ventas` WHERE DATE(`fecha_venta`) >= "'.$this->input->get("fechadesde").'-01" AND DATE(`fecha_venta`) <= "'.date($this->input->get("fechahasta").'-t').'" GROUP BY DATE_FORMAT(`fecha_venta`, "%m-%Y")';
					$data["result"] = $this->Generic_model->sql_custom($sql);
					
					$this->load->view('reportes/grafico_ventas_mensuales_view',$data);
				}else{
					$sql = 'SELECT DATE(`fecha_venta`) as Fecha, SUM(`subtotal_venta`) + SUM(`iva_venta`) + SUM(`retencion_venta`) + SUM(`percepcion_venta`) + SUM(`total_nosujeto_venta`) + SUM(`total_exento_venta`) as Total FROM `ventas` WHERE DATE(`fecha_venta`) >= "'.$this->input->get("fechadesde").'" AND DATE(`fecha_venta`) <= "'.$this->input->get("fechahasta").'" GROUP BY DATE(`fecha_venta`)';
					$data["result"] = $this->Generic_model->sql_custom($sql);
					
					$this->load->view('reportes/grafico_ventas_diarias_view',$data);
				}			
			}
		}
		function grafico_utilidades(){
			if(!filter_var($this->permisos['reportesventas']['reportesventas-utilidades'],FILTER_VALIDATE_BOOLEAN)){
				$this->load->view("error_noacceso_view");
			}else{
				$data["valores"] = $this->input->get("valores");
				$sql = 'SELECT id_venta,fecha_venta,SUM(`subtotal_venta`) + SUM(`iva_venta`) + SUM(`retencion_venta`) + SUM(`percepcion_venta`) + SUM(`total_nosujeto_venta`) + SUM(`total_exento_venta`) as Total FROM `ventas` WHERE DATE(`fecha_venta`) >= "'.$this->input->get("fechadesde").'-01" AND DATE(`fecha_venta`) <= "'.date($this->input->get("fechahasta").'-t').'" GROUP BY (`id_venta`) ORDER BY `fecha_venta` ASC';
				$result = $this->Generic_model->sql_custom($sql);
				if(count($result) > 0):
					foreach($result as $res){
						$salidas[] = array(
							"id_venta" => $res->id_venta,
							"fecha_venta" => $res->fecha_venta,
							"Total" => $res->Total,
							"ventas" => $this->Generic_model->get('salida_productos','id_producto,cant_salida',$wheres = array("id_venta" => $res->id_venta))
						);
					}
					
					$salidas_ventas = json_decode (json_encode ($salidas), FALSE);
					
					$contador = 0;
					foreach($salidas_ventas as $salidas){
						$salidas_ventas_salidas[$contador] = array(
							"id_venta" => $salidas->id_venta,
							"fecha_venta" => $salidas->fecha_venta,
							"Total" => $salidas->Total
						);
						
						if(is_array($salidas->ventas)):
							$productos = "";
							foreach($salidas->ventas as $salida):
								$costo_neto = 0;
								$costo = $this->Generic_model->get('entrada_productos','costo_entrada',$wheres = array("id_producto" => $salida->id_producto,"fecha_entrada <=" => $salidas->fecha_venta),$orders = array("fecha_entrada" => "desc"),$likes="",$joins = "",$limits = "1");
								if($costo):
									$costo_neto = $salida->cant_salida * $costo[0]->costo_entrada;								
								endif;
								$productos[] = array(
									"costo" => $costo_neto
								);
							endforeach;
							$salidas_ventas_salidas[$contador]['ventas_salidas'] = $productos;
						else:
							$salidas_ventas_salidas[$contador]['ventas_salidas'] = "";
						endif;
						
						$contador++;
					}
					
					$data["ventas"] = json_decode (json_encode ($salidas_ventas_salidas), FALSE);
				endif;
				
				if($this->input->get("tipo") == "mensual"){				
					$this->load->view('reportes/grafico_utilidades_mensuales_view',$data);
				}else{
					$this->load->view('reportes/grafico_utilidades_diarias_view',$data);
				}	
			}
		}
		function grafico_lineas(){
			if(!filter_var($this->permisos['reportesventas']['reportesventas-ventaslinea'],FILTER_VALIDATE_BOOLEAN)){
				$this->load->view("error_noacceso_view");
			}else{
				$data["valores"] = $this->input->get("valores");
				$result = $this->Generic_model->get("grupos");
				if(count($result) > 0):
					foreach($result as $res){
						$lineas[] = array(
							"id_grupo" => $res->id_grupo,
							"nombre_grupo" => $res->nombre_grupo,
							"productos" => $this->Generic_model->get('productos','id_producto,desc_producto',$wheres = array("id_grupo" => $res->id_grupo))
						);
					}
					$lineas_productos = json_decode (json_encode ($lineas), FALSE);
					$contador = 0;
					foreach($lineas_productos as $linea){
						$lineas_productos_ventas[$contador] = array(
							"id_grupo" => $linea->id_grupo,
							"nombre_grupo" => $linea->nombre_grupo
						);
						if(is_array($linea->productos)):
							$productos = "";
							foreach($linea->productos as $producto):
								$ventas_total = 0;
								$sql = 'SELECT cant_salida,costo_salida FROM `salida_productos` WHERE `id_producto` = "'.$producto->id_producto.'" AND `concepto_salida` = "0" AND DATE(`fecha_salida`) >= "'.$this->input->get("fechadesde").'" AND DATE(`fecha_salida`) <= "'.$this->input->get("fechahasta").'"';
								$ventas = $this->Generic_model->sql_custom($sql);
								if($ventas):
									$ventas_total = $ventas[0]->cant_salida * $ventas[0]->costo_salida;								
								endif;
								$productos[] = array(
									"desc_producto" =>$producto->desc_producto,
									"ventas" => $ventas_total
								);
							endforeach;
							$lineas_productos_ventas[$contador]['productos_ventas'] = $productos;
						else:
							$lineas_productos_ventas[$contador]['productos_ventas'] = "";
						endif;
						
						$contador++;
					}
					
					$data["lineas"] = json_decode (json_encode ($lineas_productos_ventas), FALSE);
				endif;
				
				if($this->input->get("tipo") == "pastel"){
					$this->load->view('reportes/grafico_lineas_pastel_view',$data);
				}else{
					$this->load->view('reportes/grafico_lineas_barras_view',$data);
				}
			}
		}
		
		function grafico_productos_estrellas(){
			if(!filter_var($this->permisos['reportesventas']['reportesventas-ventasestrellas'],FILTER_VALIDATE_BOOLEAN)){
				$this->load->view("error_noacceso_view");
			}else{
				$data["valores"] = $this->input->get("valores");
				if($this->input->get("tipo") == "numero"){
					$data["umedida"] = "Unidades";
					$sql = 'SELECT salida_productos.id_producto, desc_producto, COUNT( salida_productos.id_producto ) as total FROM salida_productos LEFT OUTER JOIN productos ON productos.id_producto = salida_productos.id_producto WHERE concepto_salida = "0" AND DATE(fecha_salida) >= "'.$this->input->get("fechadesde").'" AND DATE(fecha_salida) <= "'.$this->input->get("fechahasta").'" GROUP BY salida_productos.id_producto DESC LIMIT 5 ';
				}else{
					$data["umedida"] = "Dolares";
					$sql = 'SELECT salida_productos.id_producto, desc_producto, ( cant_salida * costo_salida ) as total FROM salida_productos LEFT OUTER JOIN productos ON productos.id_producto = salida_productos.id_producto WHERE concepto_salida = "0" AND DATE(fecha_salida) >= "'.$this->input->get("fechadesde").'" AND DATE(fecha_salida) <= "'.$this->input->get("fechahasta").'" ORDER BY total DESC LIMIT 5 ';
				}
				
				$data["productos"] = $this->Generic_model->sql_custom($sql);
			
				$this->load->view('reportes/grafico_productos_estrellas_view',$data);
			}
		}
		
		function grafico_ventas_vendedor(){
			if(!filter_var($this->permisos['reportesventas']['reportesventas-ventasvendedor'],FILTER_VALIDATE_BOOLEAN)){
				$this->load->view("error_noacceso_view");
			}else{			
				$data["valores"] = $this->input->get("valores");
				if($this->input->get("tipo") == "mensual"){
					$sql_user = 'SELECT id_vendedor,nombre_usuario FROM ventas LEFT OUTER JOIN usuarios ON usuarios.id_usuario = ventas.id_vendedor WHERE DATE(`fecha_venta`) >= "'.$this->input->get("fechadesde").'-01" AND DATE(`fecha_venta`) <= "'.date($this->input->get("fechahasta").'-t').'" GROUP BY id_vendedor';
					$usuarios = $this->Generic_model->sql_custom($sql_user);
					
					$sql = 'SELECT DATE_FORMAT(`fecha_venta`, "%m-%Y") as Fecha FROM `ventas` WHERE DATE(`fecha_venta`) >= "'.$this->input->get("fechadesde").'-01" AND DATE(`fecha_venta`) <= "'.date($this->input->get("fechahasta").'-t').'" GROUP BY DATE_FORMAT(`fecha_venta`, "%m-%Y")';
					$data["result"] = $this->Generic_model->sql_custom($sql);
					
					$categorias = [];
					$count_categorias = 0;
					if(count($data["result"]) > 0 && $usuarios > 0):
						foreach($data["result"] as $res):
							if($count_categorias == 0){
								$categorias[$count_categorias] = array(
									"fecha" => $res->Fecha
								);
								$count_categorias++;
							}else{
								if($categorias[($count_categorias - 1)]["fecha"] !=  $res->Fecha){
									$categorias[$count_categorias] = array(
										"fecha" => $res->Fecha
									);
									$count_categorias++;
								}
							}
						endforeach;
						
						$categorias_obj = json_decode (json_encode ($categorias), FALSE);
						
						$promedioslist = [];
						
						$contador = 0;
						foreach($usuarios as $usuario){
							$usuarios_ventas[$contador] = array(
								"id_usuario" => $usuario->id_vendedor,
								"nombre_usuario" => $usuario->nombre_usuario
							);
							
							$ventaslist = "";
							$contador_ventas = 0;
							foreach($categorias_obj as $categoria):
								$ventas_total = 0;
								$sql = 'SELECT SUM(`subtotal_venta`) + SUM(`iva_venta`) + SUM(`retencion_venta`) + SUM(`percepcion_venta`) + SUM(`total_nosujeto_venta`) + SUM(`total_exento_venta`) as Total FROM `ventas` WHERE DATE_FORMAT(`fecha_venta`, "%m-%Y") = "'.$categoria->fecha.'" AND id_vendedor ="'.$usuario->id_vendedor.'"';
								$ventas = $this->Generic_model->sql_custom($sql);
								if($ventas):
									$ventas_total = $ventas[0]->Total;								
								endif;
								$ventaslist[] = array(
									"ventas" => $ventas_total
								);
								
								if($ventas_total == "" || $ventas_total == 0){
									$dividir = 0;
								}else{
									$dividir = 1;
								}
								
								if($contador == 0){
									$promedioslist[$contador_ventas] = array(
										"total" => $ventas_total,
										"dividir" => $dividir
									);
								}else{
									$promedioslist[$contador_ventas]["total"]+= $ventas_total;
									$promedioslist[$contador_ventas]["dividir"]+= $dividir;
								}
								
								$contador_ventas++;
							endforeach;
							$usuarios_ventas[$contador]['ventas'] = $ventaslist;
							
							$contador++;
						}
						
					endif;
					
					$data["usuarios"] = json_decode (json_encode ($usuarios_ventas), FALSE);
					$data["promedios"] = json_decode (json_encode ($promedioslist), FALSE);
					
					$this->load->view('reportes/grafico_ventas_vendedor_mensuales_view',$data);
				}else{
					$sql_user = 'SELECT id_vendedor,nombre_usuario FROM ventas LEFT OUTER JOIN usuarios ON usuarios.id_usuario = ventas.id_vendedor WHERE DATE(`fecha_venta`) >= "'.$this->input->get("fechadesde").'" AND DATE(`fecha_venta`) <= "'.$this->input->get("fechahasta").'" GROUP BY id_vendedor';
					$usuarios = $this->Generic_model->sql_custom($sql_user);
					
					$sql = 'SELECT DATE(`fecha_venta`) as Fecha FROM `ventas` WHERE DATE(`fecha_venta`) >= "'.$this->input->get("fechadesde").'" AND DATE(`fecha_venta`) <= "'.$this->input->get("fechahasta").'" GROUP BY DATE(`fecha_venta`)';
					$data["result"] = $this->Generic_model->sql_custom($sql);
					
					$categorias = [];
					$count_categorias = 0;
					if(count($data["result"]) > 0 && $usuarios > 0):
						foreach($data["result"] as $res):
							if($count_categorias == 0){
								$categorias[$count_categorias] = array(
									"fecha" => $res->Fecha
								);
								$count_categorias++;
							}else{
								if($categorias[($count_categorias - 1)]["fecha"] !=  $res->Fecha){
									$categorias[$count_categorias] = array(
										"fecha" => $res->Fecha
									);
									$count_categorias++;
								}
							}
						endforeach;
						
						$categorias_obj = json_decode (json_encode ($categorias), FALSE);
						
						$promedioslist = [];
						
						$contador = 0;
						foreach($usuarios as $usuario){
							$usuarios_ventas[$contador] = array(
								"id_usuario" => $usuario->id_vendedor,
								"nombre_usuario" => $usuario->nombre_usuario
							);
							
							$ventaslist = "";
							$contador_ventas = 0;
							foreach($categorias_obj as $categoria):
								$ventas_total = 0;
								$sql = 'SELECT SUM(`subtotal_venta`) + SUM(`iva_venta`) + SUM(`retencion_venta`) + SUM(`percepcion_venta`) + SUM(`total_nosujeto_venta`) + SUM(`total_exento_venta`) as Total FROM `ventas` WHERE DATE(`fecha_venta`) = "'.$categoria->fecha.'" AND id_vendedor ="'.$usuario->id_vendedor.'"';
								$ventas = $this->Generic_model->sql_custom($sql);
								if($ventas):
									$ventas_total = $ventas[0]->Total;								
								endif;
								$ventaslist[] = array(
									"ventas" => $ventas_total
								);
								
								if($ventas_total == "" || $ventas_total == 0){
									$dividir = 0;
								}else{
									$dividir = 1;
								}
								
								if($contador == 0){
									$promedioslist[$contador_ventas] = array(
										"total" => $ventas_total,
										"dividir" => $dividir
									);
								}else{
									$promedioslist[$contador_ventas]["total"]+= $ventas_total;
									$promedioslist[$contador_ventas]["dividir"]+= $dividir;
								}
								
								$contador_ventas++;
							endforeach;
							$usuarios_ventas[$contador]['ventas'] = $ventaslist;
							
							$contador++;
						}
						
					endif;
					
					$data["usuarios"] = json_decode (json_encode ($usuarios_ventas), FALSE);
					$data["promedios"] = json_decode (json_encode ($promedioslist), FALSE);
					
					$this->load->view('reportes/grafico_ventas_vendedor_diarias_view',$data);
				}
			}			
		}
	/*------------------------- ENTRADAS ----------------------*/
	function graficos_entradas(){
		$UIData['user_info']=$this->usuario;
		$UIData['main_view']	= "reportes_graficos_entradas_view";
		$UIData['section_title']	= "Grafico de entradas";
		$UIData['plugins']=array(
			array(
				"nombre"=>"datapicker",
				"css"=>array('datepicker3'),
				"js"=>array('bootstrap-datepicker','locales/bootstrap-datepicker.es')
			),
			array(
				"nombre"=>"highcharts",
				"js"=>array('highcharts','exporting','data','drilldown')
			),
			array(
				"nombre"=>"iCheck",
				"css"=>array('custom'),
				"js"=>array('icheck.min')
			),
			array(
				"nombre"=>"datatables",
				"css"=> array('dataTables.bootstrap','dataTables.responsive','dataTables.tableTools.min'),
				"js"=> array('jquery.dataTables','dataTables.bootstrap.min','dataTables.responsive','dataTables.tableTools.min')
			),
		);
		
		$this->load->view('template', $UIData);
	}
	
		function grafico_compras(){
			if(!filter_var($this->permisos['reportesentradas']['reportesentradas-compras'],FILTER_VALIDATE_BOOLEAN)){
				$this->load->view("error_noacceso_view");
			}else{			
				$data["valores"] = $this->input->get("valores");
				
				if($this->input->get("tipo") == "mensual"){
					$sql = 'SELECT DATE_FORMAT(`fecha_compra`, "%m-%Y") as Fecha, SUM(`subtotal_compra`) + SUM(`iva_compra`) + SUM(`retencion_compra`) + SUM(`percepcion_compra`) + SUM(`total_nosujeto_compra`) + SUM(`total_exento_compra`) as Total FROM `compras` WHERE DATE(`fecha_compra`) >= "'.$this->input->get("fechadesde").'-01" AND DATE(`fecha_compra`) <= "'.date($this->input->get("fechahasta").'-t').'" GROUP BY DATE_FORMAT(`fecha_compra`, "%m-%Y")';
					$data["result"] = $this->Generic_model->sql_custom($sql);
					
					$this->load->view('reportes/grafico_compras_mensuales_view',$data);
				}else{
					$sql = 'SELECT DATE(`fecha_compra`) as Fecha, SUM(`subtotal_compra`) + SUM(`iva_compra`) + SUM(`retencion_compra`) + SUM(`percepcion_compra`) + SUM(`total_nosujeto_compra`) + SUM(`total_exento_compra`) as Total FROM `compras` WHERE DATE(`fecha_compra`) >= "'.$this->input->get("fechadesde").'" AND DATE(`fecha_compra`) <= "'.$this->input->get("fechahasta").'" GROUP BY DATE(`fecha_compra`)';
					$data["result"] = $this->Generic_model->sql_custom($sql);
					
					$this->load->view('reportes/grafico_compras_diarias_view',$data);
				}
			}
		}
		function grafico_devoluciones(){
			if(!filter_var($this->permisos['reportesentradas']['reportesentradas-devoluciones'],FILTER_VALIDATE_BOOLEAN)){
				$this->load->view("error_noacceso_view");
			}else{	
				$data["valores"] = $this->input->get("valores");
				if($this->input->get("tipo") == "mensual"){
					$sql = 'SELECT DATE_FORMAT(`fecha_devolucion`, "%m-%Y") as Fecha, SUM(`total_devolucion`) as Total FROM `devoluciones` WHERE DATE(`fecha_devolucion`) >= "'.$this->input->get("fechadesde").'-01" AND DATE(`fecha_devolucion`) <= "'.date($this->input->get("fechahasta").'-t').'" GROUP BY DATE_FORMAT(`fecha_devolucion`, "%m-%Y")';
					$data["result"] = $this->Generic_model->sql_custom($sql);
					
					$this->load->view('reportes/grafico_devoluciones_mensuales_view',$data);
				}else{
					$sql = 'SELECT DATE(`fecha_devolucion`) as Fecha, SUM(`total_devolucion`) as Total FROM `devoluciones` WHERE DATE(`fecha_devolucion`) >= "'.$this->input->get("fechadesde").'" AND DATE(`fecha_devolucion`) <= "'.$this->input->get("fechahasta").'" GROUP BY DATE(`fecha_devolucion`)';
					$data["result"] = $this->Generic_model->sql_custom($sql);
					
					$this->load->view('reportes/grafico_devoluciones_diarias_view',$data);
				}
			}
		}
		function grafico_compras_proveedor(){
			if(!filter_var($this->permisos['reportesentradas']['reportesentradas-comprasproveedor'],FILTER_VALIDATE_BOOLEAN)){
				$this->load->view("error_noacceso_view");
			}else{
				$data["valores"] = $this->input->get("valores");
				$result = $this->Generic_model->get("proveedores");
				if(count($result) > 0):
					foreach($result as $res){
						$proveedores[] = array(
							"id_proveedor" => $res->id_proveedor,
							"nombre_proveedor" => $res->nombre_proveedor,
							"compras" => $this->Generic_model->sql_custom('SELECT id_compra, SUM(`subtotal_compra`) + SUM(`iva_compra`) + SUM(`retencion_compra`) + SUM(`percepcion_compra`) + SUM(`total_nosujeto_compra`) + SUM(`total_exento_compra`) as Total FROM compras WHERE id_proveedor = '.$res->id_proveedor.' AND DATE(`fecha_compra`) >= "'.$this->input->get("fechadesde").'" AND DATE(`fecha_compra`) <= "'.$this->input->get("fechahasta").'" GROUP BY id_compra')
						);
					}
					
					$proveedores_obj = json_decode (json_encode ($proveedores), FALSE);
					
					$contador = 0;
					foreach($proveedores_obj as $proveedor){
						$proveedores_compras[$contador] = array(
							"id_proveedor" => $proveedor->id_proveedor,
							"nombre_proveedor" => $proveedor->nombre_proveedor
						);
						
						$total_compras = 0;
						if(is_array($proveedor->compras)):
							$sql = 'select SUM(cant_entrada * costo_entrada) as Total,desc_producto from productos left join entrada_productos on entrada_productos.id_producto = productos.id_producto left join compras on compras.id_compra = entrada_productos.id_compra left join proveedores on proveedores.id_proveedor = compras.id_proveedor where proveedores.id_proveedor = '.$proveedor->id_proveedor.' group by productos.id_producto';
							$compras = $this->Generic_model->sql_custom($sql);
							$proveedores_compras[$contador]['productos_compras'] = $compras;
						
							foreach($proveedor->compras as $compra):							
								$total_compras+=$compra->Total;
							endforeach;
							$proveedores_compras[$contador]['total_compras'] = $total_compras;
						else:
							$proveedores_compras[$contador]['total_compras'] = $total_compras;
							$proveedores_compras[$contador]['productos_compras'] = "";
						endif;
						
						$contador++;
					}
					
					$data["proveedores"] = json_decode (json_encode ($proveedores_compras), FALSE);
				endif;
				
				if($this->input->get("tipo") == "pastel"){
					$this->load->view('reportes/grafico_comprasxproveedor_pastel_view',$data);
				}else{
					$this->load->view('reportes/grafico_comprasxproveedor_barras_view',$data);
				}
			}
		}
	/*------------------------- SALIDAS ----------------------*/
	function graficos_salidas(){
		$UIData['user_info']=$this->usuario;
		$UIData['main_view']	= "reportes_graficos_salidas_view";
		$UIData['section_title']	= "Grafico de salidas";
		$UIData['plugins']=array(
			array(
				"nombre"=>"datapicker",
				"css"=>array('datepicker3'),
				"js"=>array('bootstrap-datepicker','locales/bootstrap-datepicker.es')
			),
			array(
				"nombre"=>"highcharts",
				"js"=>array('highcharts','exporting','data','drilldown')
			),
			array(
				"nombre"=>"iCheck",
				"css"=>array('custom'),
				"js"=>array('icheck.min')
			),
			array(
				"nombre"=>"datatables",
				"css"=> array('dataTables.bootstrap','dataTables.responsive','dataTables.tableTools.min'),
				"js"=> array('jquery.dataTables','dataTables.bootstrap.min','dataTables.responsive','dataTables.tableTools.min')
			),
		);
		
		$this->load->view('template', $UIData);
	}
		function grafico_salidas_vencimiento(){
			if(!filter_var($this->permisos['reportessalidas']['reportessalidas-dano'],FILTER_VALIDATE_BOOLEAN)){
				$this->load->view("error_noacceso_view");
			}else{	
				$data["valores"] = $this->input->get("valores");
				
				if($this->input->get("tipo") == "mensual"){
					$sql = 'SELECT DATE_FORMAT(`fecha_salida`, "%m-%Y") as Fecha, SUM( cant_salida * costo_salida ) as Total FROM `salida_productos` WHERE concepto_salida = "2" AND DATE(`fecha_salida`) >= "'.$this->input->get("fechadesde").'-01" AND DATE(`fecha_salida`) <= "'.date($this->input->get("fechahasta").'-t').'" GROUP BY DATE_FORMAT(`fecha_salida`, "%m-%Y")';
					$data["result"] = $this->Generic_model->sql_custom($sql);
					
					$this->load->view('reportes/grafico_vencimientos_mensuales_view',$data);
				}else{
					$sql = 'SELECT DATE(`fecha_salida`) as Fecha, SUM( cant_salida * costo_salida ) as Total FROM `salida_productos` WHERE concepto_salida = "2" AND DATE(`fecha_salida`) >= "'.$this->input->get("fechadesde").'" AND DATE(`fecha_salida`) <= "'.$this->input->get("fechahasta").'" GROUP BY DATE(`fecha_salida`)';
					$data["result"] = $this->Generic_model->sql_custom($sql);
					
					$this->load->view('reportes/grafico_vencimientos_diarias_view',$data);
				}
			}
		}
		function grafico_salidas_perdida(){
			if(!filter_var($this->permisos['reportessalidas']['reportessalidas-extravio'],FILTER_VALIDATE_BOOLEAN)){
				$this->load->view("error_noacceso_view");
			}else{	
				$data["valores"] = $this->input->get("valores");
				if($this->input->get("tipo") == "mensual"){
					$sql = 'SELECT DATE_FORMAT(`fecha_salida`, "%m-%Y") as Fecha, SUM( cant_salida * costo_salida ) as Total FROM `salida_productos` WHERE concepto_salida = "3" AND DATE(`fecha_salida`) >= "'.$this->input->get("fechadesde").'-01" AND DATE(`fecha_salida`) <= "'.date($this->input->get("fechahasta").'-t').'" GROUP BY DATE_FORMAT(`fecha_salida`, "%m-%Y")';
					$data["result"] = $this->Generic_model->sql_custom($sql);
					
					$this->load->view('reportes/grafico_perdidas_mensuales_view',$data);
				}else{
					$sql = 'SELECT DATE(`fecha_salida`) as Fecha, SUM( cant_salida * costo_salida ) as Total FROM `salida_productos` WHERE concepto_salida = "3" AND DATE(`fecha_salida`) >= "'.$this->input->get("fechadesde").'" AND DATE(`fecha_salida`) <= "'.$this->input->get("fechahasta").'" GROUP BY DATE(`fecha_salida`)';
					$data["result"] = $this->Generic_model->sql_custom($sql);
					
					$this->load->view('reportes/grafico_perdidas_diarias_view',$data);
				}
			}
		}
		function grafico_salidas_devolucion(){
			if(!filter_var($this->permisos['reportessalidas']['reportessalidas-devpro'],FILTER_VALIDATE_BOOLEAN)){
				$this->load->view("error_noacceso_view");
			}else{	
				$data["valores"] = $this->input->get("valores");
				if($this->input->get("tipo") == "mensual"){
					$sql = 'SELECT DATE_FORMAT(`fecha_salida`, "%m-%Y") as Fecha, SUM( cant_salida * costo_salida ) as Total FROM `salida_productos` WHERE concepto_salida = "4" AND DATE(`fecha_salida`) >= "'.$this->input->get("fechadesde").'-01" AND DATE(`fecha_salida`) <= "'.date($this->input->get("fechahasta").'-t').'" GROUP BY DATE_FORMAT(`fecha_salida`, "%m-%Y")';
					$data["result"] = $this->Generic_model->sql_custom($sql);
					
					$this->load->view('reportes/grafico_devoluciones_proveedores_mensuales_view',$data);
				}else{
					$sql = 'SELECT DATE(`fecha_salida`) as Fecha, SUM( cant_salida * costo_salida ) as Total FROM `salida_productos` WHERE concepto_salida = "4" AND DATE(`fecha_salida`) >= "'.$this->input->get("fechadesde").'" AND DATE(`fecha_salida`) <= "'.$this->input->get("fechahasta").'" GROUP BY DATE(`fecha_salida`)';
					$data["result"] = $this->Generic_model->sql_custom($sql);
					
					$this->load->view('reportes/grafico_devoluciones_proveedores_diarias_view',$data);
				}
			}
		}
		function grafico_salidas_consumo(){
			if(!filter_var($this->permisos['reportessalidas']['reportessalidas-consumo'],FILTER_VALIDATE_BOOLEAN)){
				$this->load->view("error_noacceso_view");
			}else{	
				$data["valores"] = $this->input->get("valores");
				if($this->input->get("tipo") == "mensual"){
					$sql = 'SELECT DATE_FORMAT(`fecha_salida`, "%m-%Y") as Fecha, SUM( cant_salida * costo_salida ) as Total FROM `salida_productos` WHERE concepto_salida = "5" AND DATE(`fecha_salida`) >= "'.$this->input->get("fechadesde").'-01" AND DATE(`fecha_salida`) <= "'.date($this->input->get("fechahasta").'-t').'" GROUP BY DATE_FORMAT(`fecha_salida`, "%m-%Y")';
					$data["result"] = $this->Generic_model->sql_custom($sql);
					
					$this->load->view('reportes/grafico_consumos_mensuales_view',$data);
				}else{
					$sql = 'SELECT DATE(`fecha_salida`) as Fecha, SUM( cant_salida * costo_salida ) as Total FROM `salida_productos` WHERE concepto_salida = "5" AND DATE(`fecha_salida`) >= "'.$this->input->get("fechadesde").'" AND DATE(`fecha_salida`) <= "'.$this->input->get("fechahasta").'" GROUP BY DATE(`fecha_salida`)';
					$data["result"] = $this->Generic_model->sql_custom($sql);
					
					$this->load->view('reportes/grafico_consumos_diarias_view',$data);
				}
			}
		}
	/*------------------------- INVENTARIOS ----------------------*/
	function reporte_inventario(){
		/*Verificar permisos*/
		if(!filter_var($this->permisos['inventario']['inventario-productos-exportar-inventario'],FILTER_VALIDATE_BOOLEAN)){
			$UIData['main_view']="error_noacceso_view";
			$UIData['structure_only']=true;
			$UIData['section_title']="Reporte de inventario";
			$this->load->view('template', $UIData);
		}else{
			$data['configs'] = $this->configuraciones;
			/*Obtener grupo*/
			if($this->input->get("bygroup") != 0){
				$grupo = $this->Generic_model->get('grupos','*',$wheres = array("id_grupo" => $this->input->get("bygroup")));
				$data['groupname'] = $grupo[0]->nombre_grupo;
			}else{
				$data['groupname'] = "";
			}
			/*Obtener subgrupo*/
			if($this->input->get("bysubgroup") != 0){
				$subgrupo = $this->Generic_model->get('subgrupos','*',$wheres = array("id_subgrupo" => $this->input->get("bysubgroup")));
				$data['subgroupname'] = $subgrupo[0]->nombre_subgrupo;
			}else{
				$data['subgroupname'] = "";
			}
			/*Wheres*/
			$wheres["presentaciones.tipo_presentacion"]=0;
			if($this->input->get("mode")==1){
				if($this->input->get("bygroup") != 0){
					$wheres["productos.id_grupo"]=$this->input->get("bygroup");
					if($this->input->get("bysubgroup")!=0){
						$wheres["productos.id_subgrupo"]=$this->input->get("bysubgroup");
					}
				}
			}
			$joins = array(
				'productos'=>'productos.id_producto=presentaciones.id_producto,left'
			);
			/*Obtener productos*/
			$productosDB=$this->Generic_model->get('presentaciones','*',$wheres,$orders = array("productos.id_producto" => "asc"),$likes = "",$joins);
			if(count($productosDB) > 0):
				/*Recorrer productos*/
				foreach($productosDB as $producto){
					$precio1 = 0;
					$precio1DB = $this->Generic_model->get('preciosxpresentacion','*',$wheres = array("precio_identificador" => 1,"id_presentacion"=>$producto->id_presentacion));
					if($precio1DB){
						$precio1 = $precio1DB[0]->precio_presentacion;
					}
					$precio2 = 0;
					$precio2DB = $this->Generic_model->get('preciosxpresentacion','*',$wheres = array("precio_identificador" => 2,"id_presentacion"=>$producto->id_presentacion));
					if($precio2DB){
						$precio2 = $precio2DB[0]->precio_presentacion;
					}
					$precio3 = 0;
					$precio3DB = $this->Generic_model->get('preciosxpresentacion','*',$wheres = array("precio_identificador" => 3,"id_presentacion"=>$producto->id_presentacion));
					if($precio3DB){
						$precio3 = $precio3DB[0]->precio_presentacion;
					}
					/*Ultimo Costo*/
					$sqlcosto="SELECT (costo_entrada/unidades_representativas) as costo FROM entrada_productos LEFT JOIN presentaciones ON presentaciones.id_presentacion=entrada_productos.id_presentacion WHERE entrada_productos.id_producto = '".$producto->id_producto."' AND (`concepto_entrada`=0 OR `concepto_entrada`=1) ORDER BY `fecha_entrada` DESC LIMIT 1";
					$costo=$this->Generic_model->sql_custom($sqlcosto);
					$costo=(isset($costo[0])?$costo[0]->costo:0);
					$productos[] = array(
						"nombre"=>$producto->desc_presentacion,
						"sku"=>$producto->sku_presentacion,
						"existencias"=>$producto->exist_act_producto,
						"precio1"=>$precio1,
						"precio2"=>$precio2,
						"precio3"=>$precio3,
						"costo"=>$costo
					);
				}
			endif;
			$data["productos"] = json_decode (json_encode ($productos), FALSE);
			$this->load->view('reportes/reporte_inventario_pdf',$data);
		}
	}
	function reporte_inventario_lista_precios(){
		if(!filter_var($this->permisos['inventario']['inventario-productos-exportar-inventario'],FILTER_VALIDATE_BOOLEAN)){
			$UIData['main_view']="error_noacceso_view";
			$UIData['structure_only']=true;
			$UIData['section_title']="Reporte de inventario";
			$this->load->view('template', $UIData);
		}else{		
			$data['configs'] = $this->configuraciones;
			if($this->input->get("bygroup") != 0){
				$grupo = $this->Generic_model->get('grupos','*',$wheres = array("id_grupo" => $this->input->get("bygroup")));
				$data['groupname'] = $grupo[0]->nombre_grupo;
			}else{
				$data['groupname'] = "";
			}
			
			if($this->input->get("bysubgroup") != 0){
				$subgrupo = $this->Generic_model->get('subgrupos','*',$wheres = array("id_subgrupo" => $this->input->get("bysubgroup")));
				$data['subgroupname'] = $subgrupo[0]->nombre_subgrupo;
			}else{
				$data['subgroupname'] = "";
			}
			
			$wheres["presentaciones.tipo_presentacion"] = 0;
			if($this->input->get("mode") == 1){
				if($this->input->get("bygroup") != 0){
					$wheres["productos.id_grupo"] = $this->input->get("bygroup");
					if($this->input->get("bysubgroup") != 0){
						$wheres["productos.id_subgrupo"] = $this->input->get("bysubgroup");
					}
				}
			}
			
			$joins = array(
				'productos' => 'productos.id_producto = presentaciones.id_producto,left outer'
			);
			$productosDB = $this->Generic_model->get('presentaciones','*',$wheres,$orders = array("presentaciones.desc_presentacion" => "asc"),$likes = "",$joins);
			if(count($productosDB) > 0):
				foreach($productosDB as $producto){
					$precio1 = "";
					
					if($this->input->get("precio1") != 0){
						$precio1DB = $this->Generic_model->get('preciosxpresentacion','*',$wheres = array("precio_identificador" => 1,"id_presentacion"=>$producto->id_presentacion));
						if($precio1DB){
							$precio1 = $precio1DB[0]->precio_presentacion;
						}
					}
					
					$precio2 = "";
					if($this->input->get("precio2") != 0){
						$precio2DB = $this->Generic_model->get('preciosxpresentacion','*',$wheres = array("precio_identificador" => 2,"id_presentacion"=>$producto->id_presentacion));
						if($precio2DB){
							$precio2 = $precio2DB[0]->precio_presentacion;
						}
					}
					
					$precio3 = "";
					if($this->input->get("precio3") != 0){
						$precio3DB = $this->Generic_model->get('preciosxpresentacion','*',$wheres = array("precio_identificador" => 3,"id_presentacion"=>$producto->id_presentacion));
						if($precio3DB){
							$precio3 = $precio3DB[0]->precio_presentacion;
						}
					}
					
					$precio4 = "";
					if($this->input->get("precio4") != 0){
						$precio4DB = $this->Generic_model->get('preciosxpresentacion','*',$wheres = array("precio_identificador" => 4,"id_presentacion"=>$producto->id_presentacion));
						if($precio4DB){
							$precio4 = $precio4DB[0]->precio_presentacion;
						}
					}
					
					$precio5 = "";
					if($this->input->get("precio5") != 0){
						$precio5DB = $this->Generic_model->get('preciosxpresentacion','*',$wheres = array("precio_identificador" => 5,"id_presentacion"=>$producto->id_presentacion));
						if($precio5DB){
							$precio5 = $precio5DB[0]->precio_presentacion;
						}
					}
					
					$precio6 = "";
					if($this->input->get("precio6") != 0){
						$precio6DB = $this->Generic_model->get('preciosxpresentacion','*',$wheres = array("precio_identificador" => 5,"id_presentacion"=>$producto->id_presentacion));
						if($precio6DB){
							$precio6 = $precio6DB[0]->precio_presentacion;
						}
					}
					$productos[] = array(
						"nombre" => $producto->desc_presentacion,
						"sku" => $producto->sku_presentacion,
						"existencias" => $producto->exist_act_producto,
						"precio1" => $precio1,
						"precio2" => $precio2,
						"precio3" => $precio3,
						"precio4" => $precio4,
						"precio5" => $precio5,
						"precio6" => $precio6
					);
				}
			endif;
			$data["productos"] = json_decode (json_encode ($productos), FALSE);
			
			
			$this->load->view('reportes/reporte_lista_precios_pdf',$data);
		}
	}
	function reporte_inventario_catalogo(){
		if(!filter_var($this->permisos['inventario']['inventario-productos-exportar-catalogo'],FILTER_VALIDATE_BOOLEAN)){
			$UIData['main_view']="error_noacceso_view";
			$UIData['structure_only']=true;
			$UIData['section_title']="Catalogo de inventario";
			$this->load->view('template', $UIData);
		}else{
			$data['configs'] = $this->configuraciones;
			$data['groupname'] = $this->input->get("groupname");
			$data['subgroupname'] = $this->input->get("subgroupname");
			$data['sku'] = $this->input->get("sku");
			$data['imagen'] = $this->input->get("imagen");
			$data['precio1'] = $this->input->get("precio1");
			$data['precio2'] = $this->input->get("precio2");
			$data['precio3'] = $this->input->get("precio3");
			$data['informacion'] = $this->input->get("informacion");
			
			$wheres = "";
			if($this->input->get("mode") == 1){
				if($this->input->get("bygroup") != 0){
					$wheres["productos.id_grupo"] = $this->input->get("bygroup");
					if($this->input->get("bysubgroup") != 0){
						$wheres["productos.id_subgrupo"] = $this->input->get("bysubgroup");
					}
				}
			}
			
			$joins = array(
				'grupos' => 'grupos.id_grupo = productos.id_grupo,left outer',
				'subgrupos' => 'subgrupos.id_subgrupo = productos.id_subgrupo,left outer'
			);
			
			$data["productos"] = $this->Generic_model->get('productos','*',$wheres,$orders = "",$likes = "", $joins);
			
			$this->load->view('reportes/reporte_inventario_catalogo_pdf',$data);
		}
	}
	/*------------------------- GENERAL ----------------------*/
	function opciones(){
		switch($this->input->get("form")){
			 case "catalogoproductos":
				$UIDataModal["content_view"]= "reportes_opciones_catalogo_producto_view";
				$UIDataModal["title"]="Opciones reporte cat&aacute;logo";
				$UIDataModal["classes"]="";
				$UIDataModal["grupos"]=$this->Generic_model->get('grupos');
			break;
			case "catalogoprecios";
				$UIDataModal["content_view"]= "reportes_opciones_lista_precios_producto_view";
				$UIDataModal["title"]="Reporte de Lista de Precios";
				$UIDataModal["classes"]="";
				$UIDataModal["grupos"]=$this->Generic_model->get('grupos');
			break;
			case "productos";
				$UIDataModal["content_view"]= "reportes_opciones_productos_view";
				$UIDataModal["title"]="Reporte de Inventario de Productos";
				$UIDataModal["classes"]="";
				$UIDataModal["grupos"]=$this->Generic_model->get('grupos');
			break;
			case "comisiones";
				$UIDataModal["content_view"]= "reportes_opciones_comisiones_view";
				$UIDataModal["title"]="Reporte de Comisiones";
				$UIDataModal["classes"]="";
				$UIDataModal["usuario"]=$this->session_['userid'];
			break;
			 /*default:$view ="restaurante_inventario_transacciones_nueva_desconocida_view";break; */
		}
		$UIDataModal["close_button"]=true;
		$UIDataModal["id"]="reporte-opciones-modal";
		$this->load->view('template_modal',$UIDataModal); 
	}
	
	/*------------------------- CLIENTES ----------------------*/
	function reporte_creditos_cliente(){
		if(!filter_var($this->permisos['cuentasxcobrar']['cuentasxcobrar-exportar'],FILTER_VALIDATE_BOOLEAN)){
			$UIData['main_view']="error_noacceso_view";
			$UIData['structure_only']=true;
			$UIData['section_title']="Reporte de cr&eacute;ditos";
			$this->load->view('template', $UIData);
		}else{
			$data['configs'] = $this->configuraciones;
			$data['creditos'] = $this->Generic_model->get('creditos','*',array('id_cliente'=>$this->input->get('idcliente')));
			$data['cliente'] = $this->Generic_model->get('clientes','*',array('id_cliente'=>$this->input->get('idcliente')));
			$this->load->view('reportes/reporte_creditos_cliente_pdf',$data);
		}
	}
	
	function reporte_credito_cliente(){
		if(!filter_var($this->permisos['cuentasxcobrar']['cuentasxcobrar-exportar'],FILTER_VALIDATE_BOOLEAN)){
			$UIData['main_view']="error_noacceso_view";
			$UIData['structure_only']=true;
			$UIData['section_title']="Reporte de cr&eacute;ditos";
			$this->load->view('template', $UIData);
		}else{
			$data['configs'] = $this->configuraciones;
			$data['creditos'] = $this->Generic_model->get('transaccionesxcredito','*',array('id_credito'=>$this->input->get('idcredito')),array('fecha_transaccion'=>'asc'));
			$data['cliente'] = $this->Generic_model->get('clientes','*',array('id_cliente'=>$this->input->get('idcliente')));
			$this->load->view('reportes/reporte_credito_cliente_pdf',$data);
		}
	}
	
	function reporte_creditos(){
		$clientes = $this->Generic_model->get('clientes','id_cliente as id, nombre_cliente as nombre, razonsocial_cliente as razon, limite_credito_cliente as limite',array('credito_cliente'=>1),array('nombre_cliente'=>'ASC'));
			
		if(count($clientes) > 0):
			foreach($clientes as $cliente):
				$creditos=$this->Generic_model->get('creditos','*',array('id_cliente'=>$cliente->id));
				$saldo=0;
				if(count($creditos)>0){
					foreach($creditos as $credito){
						$saldo+=$credito->saldo_credito;
					}
				}
			
				$clientes_saldo[] = array(
					"id" => $cliente->id,
					"nombre" => $cliente->nombre,
					"razon" => $cliente->razon,
					"saldo" => number_format($saldo,2),
					"limite" => $cliente->limite,
				);
			endforeach;
			
			
		endif;
		
		$data['configs'] = $this->configuraciones;
		$data["clientes"] = json_decode (json_encode ($clientes_saldo), FALSE);
		
		$this->load->view('reportes/reporte_creditos_pdf',$data);
	}
	
	function reporte_deudas(){
		
	}
	
	/*------------------------- PROVEEDORES ----------------------*/
	function reporte_deudas_proveedor(){
		if(!filter_var($this->permisos['cuentasxpagar']['cuentasxpagar-exportar'],FILTER_VALIDATE_BOOLEAN)){
			$UIData['main_view']="error_noacceso_view";
			$UIData['structure_only']=true;
			$UIData['section_title']="Reporte de cr&eacute;ditos";
			$this->load->view('template', $UIData);
		}else{
			$data['configs'] = $this->configuraciones;
			$data['deudas'] = $this->Generic_model->get('deudas','*',array('id_proveedor'=>$this->input->get('idproveedor')));
			$data['proveedor'] = $this->Generic_model->get('proveedores','*',array('id_proveedor'=>$this->input->get('idproveedor')));
			$this->load->view('reportes/reporte_deudas_proveedor_pdf',$data);
		}
	}
	
	function reporte_deuda_proveedor(){
		if(!filter_var($this->permisos['cuentasxpagar']['cuentasxpagar-exportar'],FILTER_VALIDATE_BOOLEAN)){
			$UIData['main_view']="error_noacceso_view";
			$UIData['structure_only']=true;
			$UIData['section_title']="Reporte de cr&eacute;ditos";
			$this->load->view('template', $UIData);
		}else{
			$data['configs'] = $this->configuraciones;
			$data['deudas'] = $this->Generic_model->get('transaccionesxdeuda','*',array('id_deuda'=>$this->input->get('iddeuda')),array('fecha_transaccionxd'=>'asc'));
			$data['proveedor'] = $this->Generic_model->get('proveedores','*',array('id_proveedor'=>$this->input->get('idproveedor')));
			$this->load->view('reportes/reporte_deuda_proveedor_pdf',$data);
		}
	}
	
	/*------------------------- COTIZACION ----------------------*/
	function reporte_cotizacion(){
		$data['configs'] = $this->configuraciones;
		
		$wheres = array('id_cotizacion' => $this->input->get('id'));
		
		$joins = array(
			'clientes' => 'clientes.id_cliente = cotizaciones.id_cliente',
			'usuarios' => 'usuarios.id_usuario = cotizaciones.id_vendedor'
		);
		
		$cotizacion = $this->Generic_model->get('cotizaciones','detalles_cotizacion,id_cotizacion,fecha_cotizacion,subtotal_cotizacion,iva_cotizacion,retencion_cotizacion,percepcion_cotizacion,total_nosujeto_cotizacion,total_exento_cotizacion,notas_cotizacion,firma_cotizacion,nombre_cliente,razonsocial_cliente,nombre_usuario',$wheres, $orders = "",$likes="",$joins);
		$data['detalles'] = unserialize($cotizacion[0]->detalles_cotizacion);
		$data['cotizacion'] = $cotizacion[0];
		
		$wheres = array('id_cotizacion' => $cotizacion[0]->id_cotizacion);
		
		$joins = array(
			'presentaciones' => 'presentaciones.id_presentacion = productosxcotizacion.id_presentacion'
		);
		
		$productos = $this->Generic_model->get('productosxcotizacion','desc_presentacion,cantidad_producto,precio_producto',$wheres, $orders = "",$likes="",$joins);
		$data['productos'] = $productos;
		
		$this->load->view('reportes/reporte_cotizacion_pdf',$data);
	}
		
		function reporte_comprasxproveedor(){
			if(!filter_var($this->permisos['reportesentradas']['reportesentradas-comprasproveedor'],FILTER_VALIDATE_BOOLEAN)){
				$UIData['main_view']="error_noacceso_view";
				$UIData['structure_only']=true;
				$UIData['section_title']="Reporte de compras";
				$this->load->view('template', $UIData);
			}else{			
				/*reporte*/
			}
		}
	
	function reportes_salidas(){
		$UIData['user_info']=$this->usuario;
		$UIData['main_view']	= "reportes_salidas_view";
		$UIData['section_title']	= "Reportes de salidas";
		$UIData['plugins']=array(
			array(
				"nombre"=>"datapicker",
				"css"=>array('datepicker3'),
				"js"=>array('bootstrap-datepicker','locales/bootstrap-datepicker.es')
			),
			array(
				"nombre"=>"highcharts",
				"js"=>array('highcharts','exporting','data','drilldown')
			),
			array(
				"nombre"=>"iCheck",
				"css"=>array('custom'),
				"js"=>array('icheck.min')
			),
			array(
				"nombre"=>"datatables",
				"css"=> array('dataTables.bootstrap','dataTables.responsive','dataTables.tableTools.min'),
				"js"=> array('jquery.dataTables','dataTables.bootstrap.min','dataTables.responsive','dataTables.tableTools.min')
			),
		);
		
		$this->load->view('template', $UIData);
	}
	
		function reporte_vencimiento(){
			if(!filter_var($this->permisos['reportessalidas']['reportessalidas-dano'],FILTER_VALIDATE_BOOLEAN)){
				$UIData['main_view']="error_noacceso_view";
				$UIData['structure_only']=true;
				$UIData['section_title']="Reporte de compras";
				$this->load->view('template', $UIData);
			}else{			
				/*reporte*/
			}
		}
		
		function reporte_perdida(){
			if(!filter_var($this->permisos['reportessalidas']['reportessalidas-extravio'],FILTER_VALIDATE_BOOLEAN)){
				$UIData['main_view']="error_noacceso_view";
				$UIData['structure_only']=true;
				$UIData['section_title']="Reporte de compras";
				$this->load->view('template', $UIData);
			}else{			
				/*reporte*/
			}
		}
		
		function reporte_devoluciones_proveedor(){
			if(!filter_var($this->permisos['reportessalidas']['reportessalidas-devpro'],FILTER_VALIDATE_BOOLEAN)){
				$UIData['main_view']="error_noacceso_view";
				$UIData['structure_only']=true;
				$UIData['section_title']="Reporte de compras";
				$this->load->view('template', $UIData);
			}else{			
				/*reporte*/
			}
		}
		
		function reporte_consumo(){
			if(!filter_var($this->permisos['reportessalidas']['reportessalidas-consumo'],FILTER_VALIDATE_BOOLEAN)){
				$UIData['main_view']="error_noacceso_view";
				$UIData['structure_only']=true;
				$UIData['section_title']="Reporte de compras";
				$this->load->view('template', $UIData);
			}else{			
				/*reporte*/
			}
		}
/*--------------------------------------	REPORTES DE VENTAS --------------------------------------*/
	function reportes_ventas(){
		$UIData['user_info']=$this->usuario;
		$UIData['main_view']="reportes_ventas_view";
		$UIData['section_title']="Reportes de ventas";
		$UIData['jsfiles']=array("miracle.reportes_ventas");
		$UIData['plugins']=array(
			array(
				"nombre"=>"datapicker",
				"css"=>array('datepicker3'),
				"js"=>array('bootstrap-datepicker','locales/bootstrap-datepicker.es')
			),
			array(
				"nombre"=>"highcharts",
				"js"=>array('highcharts','exporting','data','drilldown')
			),
			array(
				"nombre"=>"iCheck",
				"css"=>array('custom'),
				"js"=>array('icheck.min')
			),
			array(
				"nombre"=>"datatables",
				"css"=> array('dataTables.bootstrap','dataTables.responsive','dataTables.tableTools.min'),
				"js"=> array('jquery.dataTables','dataTables.bootstrap.min','dataTables.responsive','dataTables.tableTools.min')
			),
		);
		$UIData['vendedores'] = $this->Generic_model->get("usuarios","*",array("id_usuario >=" => 0,"vendedor_usuario"=>1));
		$UIData['cajas'] = $this->Generic_model->get("cajas");
		$UIData['documentos'] = $this->config->item("documentos_venta");
		$this->load->view('template', $UIData);
	}
		/*-------------- Reporte general de ventas -------------*/
		function reporte_ventas(){
			if(!filter_var($this->permisos['reportesventas']['reportesventas-ventas'],FILTER_VALIDATE_BOOLEAN)){
				$UIData['main_view']="error_noacceso_view";
				$UIData['structure_only']=true;
				$UIData['section_title']="Reporte de ventas";
				$this->load->view('template', $UIData);
			}
			else{
				$data['configs']=$this->configuraciones;
				$where="";
				$devsWhere="";
				$includeDevs=filter_var($this->input->get("devs"),FILTER_VALIDATE_BOOLEAN);
				$includeProducts=filter_var($this->input->get("prods"),FILTER_VALIDATE_BOOLEAN);
				$data['includeProducts']=$includeProducts;
				/*Ordenar wheres*/
				$wheres=json_decode(base64_decode($this->input->get("w")));		
				foreach($wheres as $field=>$val){
					if($field=="DATE(`fecha_venta`)>="){
						$fecha_inicio=$val;
					}
					if($field=="DATE(`fecha_venta`)<="){
						$fecha_fin=$val;
					}
					$where.=" ".$field."'".$val."' AND";
					if($includeDevs){
						switch($field){
							case "DATE(`fecha_venta`)>=":$devsWhere.=" DATE(`fecha_devolucion`)>='".$val."' AND";break;
							case "DATE(`fecha_venta`)<=":$devsWhere.=" DATE(`fecha_devolucion`)<='".$val."' AND";break;
							case "documento_venta=":$devsWhere.=" doc_devolucion='".$val."' AND";break;
							case "cobro_venta=":$devsWhere.=" tipo_devolucion='".$val."' AND";break;
							case "id_caja=":$devsWhere.=" devoluciones.id_caja='".$val."' AND";break;
							case "id_cajero=":$devsWhere.=" devoluciones.id_usuario='".$val."' AND";break;
							case "id_vendedor=":$devsWhere.=" vendedores.id_usuario='".$val."' AND";break;
						}
					}
				}
				if($where!=""){$where=substr($where,0,-3);}
				if($devsWhere!=""){$devsWhere=substr($devsWhere,0,-3);}
				/*Consulta ventas*/
				$SQLStmt="(SELECT 'venta' as tipo, id_venta as referencia,fecha_venta as fecha,vendedores.nombre_usuario as vendedor,cajeros.nombre_usuario as cajero,cobro_venta as condicion,documento_venta as documento,num_documento_venta as numero,subtotal_venta as grabado,total_nosujeto_venta as nosujeto,total_exento_venta as exento,descuento_venta as descuento, total_venta as total,(iva_venta-retencion_venta+percepcion_venta) as impuestos,ventas.nombre_cliente as nombre_cliente_venta,ventas.estado_venta as estado";
				$SQLStmt.=" FROM ventas";
				$SQLStmt.=" LEFT JOIN usuarios as vendedores on vendedores.id_usuario=ventas.id_vendedor";
				$SQLStmt.=" LEFT JOIN usuarios as cajeros on cajeros.id_usuario=ventas.id_cajero";
				$SQLStmt.=" WHERE ".$where." AND origen_venta='0' ORDER BY fecha_venta ASC)";
				/*Consulta devoluciones*/
				if($includeDevs){
					$SQLStmt.=" UNION ALL (SELECT 'devolucion' as tipo, id_devolucion as referencia,fecha_devolucion,vendedores.nombre_usuario as vendedor,cajeros.nombre_usuario as cajero,tipo_devolucion as condicion,doc_devolucion as documento,num_doc_devolucion as numero,grabado_devolucion as grabado,nosujeto_devolucion as nosujeto,exento_devolucion as exento,(iva_devolucion-retencion_devolucion+percepcion_devolucion) as impuestos";
					$SQLStmt.=" FROM devoluciones";
					$SQLStmt.=" LEFT JOIN ventas on ventas.id_venta=devoluciones.id_venta";
					$SQLStmt.=" LEFT JOIN usuarios as vendedores on vendedores.id_usuario=ventas.id_vendedor";
					$SQLStmt.=" LEFT JOIN usuarios as cajeros on cajeros.id_usuario=devoluciones.id_usuario";
					$SQLStmt.=" WHERE ".$devsWhere." ORDER BY fecha_venta ASC)";
				}
				$transacciones=$this->Generic_model->sql_custom($SQLStmt);
				$documentos=$this->config->item("documentos_venta");
				if($includeProducts){
					foreach($transacciones as $transaccion){
						if($transaccion->tipo==="venta"){
							$transaccion->productos=$this->Generic_model->get("salida_productos","presentaciones.sku_presentacion as sku,presentaciones.desc_presentacion as desc,cant_salida as cant, costo_salida as costo",array("id_venta"=>$transaccion->referencia),"","",array("presentaciones"=>"presentaciones.id_presentacion=salida_productos.id_presentacion"));
						}
						else if($transaccion->tipo==="devolucion"){
							$transaccion->productos=$this->Generic_model->get("entrada_productos","presentaciones.sku_presentacion as sku,presentaciones.desc_presentacion as desc,cant_entrada as cant, costo_entrada as costo",array("id_devolucion"=>$transaccion->referencia),"","",array("presentaciones"=>"presentaciones.id_presentacion=entrada_productos.id_presentacion"));
						}
					}
				}
				
				$data['transacciones']=$transacciones;
				$data['fechadesde']=$fecha_inicio;
				$data['fechahasta']=$fecha_fin;
				$data['documentos']=$this->config->item("documentos_venta");
				$this->load->view('reportes/reporte_nuevo_ventas_pdf',$data);
			}
		}
		/*-------------- Reporte de ventas credito -------------*/
		function reporte_ventas_credito(){
			if(!filter_var($this->permisos['reportesventas']['reportesventas-ventas'],FILTER_VALIDATE_BOOLEAN)){
				$UIData['main_view']="error_noacceso_view";
				$UIData['structure_only']=true;
				$UIData['section_title']="Reporte de ventas";
				$this->load->view('template', $UIData);
			}
			else{
				$data['configs']=$this->configuraciones;
				$especific_cobro=false;
				$where="";
				/*Ordenar wheres*/
				$wheres=json_decode(base64_decode($this->input->get("w")));	
				foreach($wheres as $field=>$val){
					if($field=="DATE(`fecha_venta`)>="){
						$fecha_inicio=$val;
					}
					if($field=="DATE(`fecha_venta`)<="){
						$fecha_fin=$val;
					}
					if($field=="cobro_venta"){
						$especific_cobro=true;
					}
					$where.=" ".$field."'".$val."' AND";
				}
				if($where!=""){$where=substr($where,0,-3);}
				if(!$especific_cobro){$where.=" AND (cobro_venta=1 OR cobro_venta=3)";}
				/*Consulta ventas*/
				$SQLStmt="(SELECT id_venta as referencia,fecha_venta as fecha,vendedores.nombre_usuario as vendedor,cajeros.nombre_usuario as cajero, nombre_cliente as cliente, cobro_venta as tipo,documento_venta as documento,num_documento_venta as numero,estado_cobro as estado, (subtotal_venta + total_nosujeto_venta + total_exento_venta + iva_venta-retencion_venta+percepcion_venta) as total";
				$SQLStmt.=" FROM ventas";
				$SQLStmt.=" LEFT JOIN usuarios as vendedores on vendedores.id_usuario=ventas.id_vendedor";
				$SQLStmt.=" LEFT JOIN usuarios as cajeros on cajeros.id_usuario=ventas.id_cajero";
				$SQLStmt.=" WHERE ".$where." AND origen_venta='0' ORDER BY fecha_venta ASC)";
			
				$transacciones=$this->Generic_model->sql_custom($SQLStmt);
				$data['documentos']=$this->config->item("documentos_venta");
				$data['transacciones']=$transacciones;
				$data['fechadesde']=$fecha_inicio;
				$data['fechahasta']=$fecha_fin;
				$this->load->view('reportes/reporte_ventas_credito_pdf',$data);
				/* echo "<pre>";
				print_r($transacciones);
				echo "</pre>"; */
			}
		}
		/*----------------- Reporte de utilidades ---------------*/
		function reporte_utilidades(){
			$data['configs']=$this->configuraciones;
			$data['condicion']="Todas";
			$data['caja']="Todas";
			$data['vendedor']="Todos";
			ini_set('max_execution_time', 300);
			$fields=json_decode(base64_decode($this->input->get("w")));
			/*Ordenar wheres*/
			$where="";
			$metodo=0;
			foreach($fields as $field=>$val){
				switch($field){
					case "inicio":
						$where.=" DATE(`fecha_venta`)>='".$val."' AND";
						$inicio=$val;
						$data["fecha_inicio"]=$val;
					break;
					case "final":
						$where.=" DATE(`fecha_venta`)<='".$val."' AND";
						$data["fecha_fin"]=$val;
					break;
					case "metodo":
						$metodo=$val;
						$data["metodo"]=($metodo==0)?"Costo promedio":"Costo segun ultima compra";
					break;
					case "condicion":
						$where.=" ventas.cobro_venta='".$val."' AND";
						$data["condicion"]=($val==0)?"Contado":"Credito";
					break;
					case "caja":
						$where.=" ventas.id_caja='".$val."' AND";
						$data["caja"]=$this->Generic_model->get("cajas","nombre_caja",array("id_caja"=>$val));
					break;
					case "vendedor":
						$where.=" ventas.id_vendedor='".$val."' AND";
						$data["vendedor"]=$this->Generic_model->get("usuarios","nombre_usuario",array("id_usuario"=>$val));
					break;
				}
			}
			$where=($where!=""?$where=substr($where,0,-3):"");
			/*Consultar ventas*/
			$SQLStmt="SELECT id_venta as id,fecha_venta as fecha,documento_venta as documento,num_documento_venta as numero, serie_autorizada as serie";			
			$SQLStmt.=" FROM ventas";
			$SQLStmt.=" LEFT JOIN resoluciones_caja on resoluciones_caja.id_resolucion=ventas.id_resolucion";
			$SQLStmt.=" WHERE ".$where." AND estado_venta=1";
			$SQLStmt.=" ORDER BY fecha ASC";
			$ventas=$this->Generic_model->sql_custom($SQLStmt);
			$productos=array();
			if(count($ventas)){
				/*Obtener productos por ventas*/
				foreach($ventas as $venta){
					$prodxventa=$this->Generic_model->get('salida_productos','salida_productos.id_producto as producto,salida_productos.id_presentacion as presentacion,presentaciones.desc_presentacion as desc,salida_productos.costo_salida as preciov,salida_productos.cant_salida as cantidad,unidades_representativas as uequiv, (costo_salida/unidades_representativas) as precio_equivalente,ultimocosto_producto',array('id_venta'=>$venta->id),'','',array('presentaciones'=>'presentaciones.id_presentacion = salida_productos.id_presentacion','productos'=>'productos.id_producto = salida_productos.id_producto'));
					if(count($prodxventa)){
						foreach($prodxventa as $prod){
							$prod->ref=$venta->id;
							$prod->fecha=$venta->fecha;
							$prod->documento=$venta->documento;
							$prod->serie=$venta->serie;
							$prod->numero=$venta->numero;
							$prod->totalUnitaroNeto=($venta->documento==2?$prod->preciov:$prod->preciov);
							$prod->totalUnitaroEquivNeto=($venta->documento==2?$prod->precio_equivalente:$prod->precio_equivalente);
							$costo=$prod->ultimocosto_producto;
							switch($metodo){
								case 0:
									$sqlcosto="(SELECT  'entrada' as trans,fecha_entrada as fecha,concepto_entrada as concepto,(cant_entrada*unidades_representativas) as entrada, '0' as salida,(costo_entrada/unidades_representativas) as costo FROM entrada_productos LEFT JOIN presentaciones ON presentaciones.id_presentacion=entrada_productos.id_presentacion WHERE entrada_productos.id_producto = '".$prod->producto. "' AND fecha_entrada < '".$venta->fecha."')";
									$sqlcosto.=" UNION ALL "; 
									$sqlcosto.="(SELECT  'salida' as trans,fecha_salida as fecha,concepto_salida as concepto,'0' as entrada,(cant_salida*unidades_representativas) as salida,0 as costo FROM salida_productos LEFT JOIN presentaciones ON presentaciones.id_presentacion=salida_productos.id_presentacion WHERE salida_productos.id_producto = '".$prod->producto. "' AND fecha_salida < '".$venta->fecha."')";
									$sqlcosto.=" ORDER BY fecha"; 
									$trans=$this->Generic_model->sql_custom($sqlcosto);
									$costoPromedio=0;
									$inventarioInicial=0;
									if(count($trans)){
										$saldo=0;
										foreach($trans as $tran){
											$saldo=$saldo+$tran->entrada-$tran->salida;
											if($tran->trans=="entrada"){
												if((int)$tran->concepto==0){/*Inventario inicial*/
													if($inventarioInicial==0){
														$inventarioInicial=1;
														$costoPromedio=$tran->costo;
													}
												}
												else if((int)$tran->concepto==1){/*compras*/
													if($saldo-$tran->entrada>0){
														$costoPromedio=((($saldo-$tran->entrada)*$costoPromedio)+($tran->entrada*$tran->costo))/$saldo;
														if($costoPromedio<0)
															$costoPromedio=$tran->costo;
													}else{
														$costoPromedio=$tran->costo;
													}
												}
											}
										}
									}
									$costo=$costoPromedio;
								break;
								case 1:
									$costo=$this->Generic_model->get("entrada_productos","(costo_entrada/unidades_representativas) as costo_equivalente",array("entrada_productos.id_producto"=>$prod->producto,"fecha_entrada <="=>$venta->fecha,"concepto_entrada"=>1),array("fecha_entrada"=>"DESC"),"",array("presentaciones"=>"presentaciones.id_presentacion=entrada_productos.id_presentacion"),1);
									if(count($costo)){
										$costo=$costo[0]->costo_equivalente;
									}else{
									    $costo=$this->Generic_model->get("entrada_productos","(costo_entrada/unidades_representativas) as costo_equivalente",array("entrada_productos.id_producto"=>$prod->producto,"fecha_entrada <="=>$venta->fecha,"concepto_entrada"=>0),array("fecha_entrada"=>"DESC"),"",array("presentaciones"=>"presentaciones.id_presentacion=entrada_productos.id_presentacion"),1);
									    
									    if(count($costo)){
										    $costo=$costo[0]->costo_equivalente;
									    }else{
									        $costo=$this->Generic_model->get("entrada_productos","(costo_entrada/unidades_representativas) as costo_equivalente",array("entrada_productos.id_producto"=>$prod->producto,"fecha_entrada <="=>$venta->fecha,"concepto_entrada"=>9),array("fecha_entrada"=>"DESC"),"",array("presentaciones"=>"presentaciones.id_presentacion=entrada_productos.id_presentacion"),1);
									    
									        if(count($costo)){
    										    $costo=$costo[0]->costo_equivalente;
    									    }
									    }
									}
								break;
							}
                            if($costo>0){
                                $prod->costo=$costo;
                            }else{
                                $prod->costo=$prod->ultimocosto_producto;
                            }
							$productos[]=$prod;
						}
					}
				}
			}
			$documentos=$this->config->item("documentos_venta");
			$ventasNetasTotales=0;
			$costosNetosTotales=0;
			$utilidadNetaTotales=0;
			
			$data['productos']=$productos;
			$data['documentos']=$this->config->item("documentos_venta");
			
			$this->load->view('reportes/reporte_nuevo_ganancias_pdf',$data);
		}		
		/*---------------- Reporte de comisiones --------------*/
		function reporte_comisiones(){
			$totalcomi=$totalventa=0;
			/*Decodificar campos*/
			$fields=json_decode(base64_decode($this->input->get("w")));
			/*Ordenar wheres & obtener vendedor*/
			$vendedor=null;
			$where="";
			foreach($fields as $field=>$val){
				switch($field){
					case "vendedor":
						$where.=" id_vendedor='".$val."' AND";
						$vendedor=$val;
					break;
					case "inicio":
						$where.=" DATE(`fecha_venta`)>='".$val."' AND";
						$fechaInicio=$val;
					break;
					case "final":
						$where.=" DATE(`fecha_venta`)<='".$val."' AND";
						$fechaFin=$val;
					break;
				}
			}
			$data["vendedor"]=$this->Generic_model->get('usuarios','nombre_usuario as nombre',array('id_usuario'=>$vendedor));
			$data["fechadesde"]=$fechaInicio;
			$data["fechahasta"]=$fechaFin;
			$data["meta"]="No aplica";
			$where=($where!=""?$where=substr($where,0,-3):"");
			/*Verificar permisos*/
			$permiso=(($vendedor!=null && $vendedor==$this->session_['userid']) || filter_var($this->permisos['reportesventas']['reportesventas-comisiones'],FILTER_VALIDATE_BOOLEAN));
			if(!$permiso){
				$UIData['main_view']="error_noacceso_view";
				$UIData['structure_only']=true;
				$UIData['section_title']="Reporte de compras";
				$this->load->view('template', $UIData);
			}
			else{
				/*Consultar ventas*/
				$SQLStmt="SELECT id_venta as id,fecha_venta as fecha,documento_venta as documento,num_documento_venta as numero, serie_autorizada as serie";			
				$SQLStmt.=" FROM ventas";
				$SQLStmt.=" LEFT JOIN resoluciones_caja on resoluciones_caja.id_resolucion=ventas.id_resolucion";
				$SQLStmt.=" WHERE ".$where."";
				$SQLStmt.=" ORDER BY fecha ASC";
				$ventas=$this->Generic_model->sql_custom($SQLStmt);
				if(count($ventas)>0){
					/*Obtener productos por ventas*/
					$productos=array();
					foreach($ventas as $venta){
						$prodxventa=$this->Generic_model->get('salida_productos','salida_productos.id_producto as producto,salida_productos.id_presentacion as presentacion,presentaciones.desc_presentacion as desc,salida_productos.costo_salida as preciov,salida_productos.cant_salida as cantidad, (salida_productos.cant_salida * salida_productos.costo_salida) as total',array('id_venta'=>$venta->id),'','',array('presentaciones'=>'presentaciones.id_presentacion = salida_productos.id_presentacion'));
						if($prodxventa){
							foreach($prodxventa as $prod){
								$productos[]=$prod;
							}
						}
					}
					/*Recorrer productos por venta*/
					foreach($productos as $i=>$producto){
						$preciosxpre1=$this->Generic_model->get('preciosxpresentacion','precio_presentacion as precio,comision_minorista as comision',array('id_presentacion'=>$producto->presentacion,'precio_identificador'=>1));
						$preciosxpre2=$this->Generic_model->get('preciosxpresentacion','precio_presentacion as precio,comision_minorista as comision',array('id_presentacion'=>$producto->presentacion,'precio_identificador'=>2));
						$preciosxpre3=$this->Generic_model->get('preciosxpresentacion','precio_presentacion as precio,comision_minorista as comision',array('id_presentacion'=>$producto->presentacion,'precio_identificador'=>3));
						$preciosxpre4=$this->Generic_model->get('preciosxpresentacion','precio_presentacion as precio,comision_mayorista as comision',array('id_presentacion'=>$producto->presentacion,'precio_identificador'=>4));
						$preciosxpre5=$this->Generic_model->get('preciosxpresentacion','precio_presentacion as precio,comision_mayorista as comision',array('id_presentacion'=>$producto->presentacion,'precio_identificador'=>5));
						$preciosxpre6=$this->Generic_model->get('preciosxpresentacion','precio_presentacion as precio,comision_mayorista as comision',array('id_presentacion'=>$producto->presentacion,'precio_identificador'=>6));
						
						$productos[$i]->precio1=$preciosxpre1[0]->precio;
						$productos[$i]->precio2=$preciosxpre2[0]->precio;
						$productos[$i]->precio3=$preciosxpre3[0]->precio;
						$productos[$i]->precio4=$preciosxpre4[0]->precio;
						$productos[$i]->precio5=$preciosxpre5[0]->precio;
						
						$costo_neto=0;
						$costosql="select costo_entrada from entrada_productos where id_presentacion=".$producto->presentacion." AND date(`fecha_entrada`) <= '".$fechaInicio."' AND concepto_entrada=1 order by fecha_entrada desc limit 1";
						$costo = $this->Generic_model->sql_custom($costosql);
						if($costo){
							$costo_neto=$producto->cantidad*$costo[0]->costo_entrada;								
						}
						$productos[$i]->costo_neto=$costo_neto;
						if($producto->preciov >= $preciosxpre1[0]->precio){
							$productos[$i]->aplicable="precio 1";
							$productos[$i]->comisionapli=$preciosxpre1[0]->comision;
							$comision = ($productos[$i]->total/1.13) - $costo_neto;
							$productos[$i]->comision=$comision*($preciosxpre1[0]->comision/100);
						}
						else if($producto->preciov >= $preciosxpre2[0]->precio && $producto->preciov < $preciosxpre1[0]->precio){
							$productos[$i]->aplicable="precio 2";
							$productos[$i]->comisionapli=$preciosxpre2[0]->comision;
							$comision = ($productos[$i]->total/1.13) - $costo_neto;
							$productos[$i]->comision=$comision*($preciosxpre2[0]->comision/100);
						}
						else if($producto->preciov >= $preciosxpre3[0]->precio && $producto->preciov < $preciosxpre2[0]->precio){
							$productos[$i]->aplicable="precio 3";
							$productos[$i]->comisionapli=$preciosxpre3[0]->comision;
							$comision = ($productos[$i]->total/1.13) - $costo_neto;
							$comision = ($productos[$i]->total/1.13) - $costo_neto;
							$productos[$i]->comision=$comision*($preciosxpre3[0]->comision/100);
						}
						else if($producto->preciov >= $preciosxpre4[0]->precio && $producto->preciov < $preciosxpre3[0]->precio){
							$productos[$i]->aplicable="precio 4";
							$productos[$i]->comisionapli=$preciosxpre4[0]->comision;
							$comision = ($productos[$i]->total/1.13) - $costo_neto;
							$productos[$i]->comision=$comision*($preciosxpre4[0]->comision/100);
						}
						else if($producto->preciov >= $preciosxpre5[0]->precio && $producto->preciov < $preciosxpre4[0]->precio){
							$productos[$i]->aplicable="precio 5";
							$productos[$i]->comisionapli=$preciosxpre5[0]->comision;
							$comision = ($productos[$i]->total/1.13) - $costo_neto;
							$productos[$i]->comision=$comision*($preciosxpre5[0]->comision/100);
						}
						else if($producto->preciov < $preciosxpre4[0]){
							$productos[$i]->aplicable="N/A";
							$productos[$i]->comisionapli=0;
							$productos[$i]->comision=0;
						}
						$totalcomi+=$productos[$i]->comision;
						$totalventa+=$productos[$i]->total; 
					}
					$data["productos"] = $productos;
					$data["totalventa"] = round($totalventa,2);
					$data["totalcomi"] = round($totalcomi,2);
				}
				$data['configs'] = $this->configuraciones;
				$this->load->view('reportes/reporte_comisiones_pdf',$data);
			}
		}
		/*-------------- Reporte de ventas por linea ----------*/
		function reporte_lineas(){
			if(!filter_var($this->permisos['reportesventas']['reportesventas-ventaslinea'],FILTER_VALIDATE_BOOLEAN)){
				$UIData['main_view']="error_noacceso_view";
				$UIData['structure_only']=true;
				$UIData['section_title']="Reporte de lineas";
				$this->load->view('template', $UIData);
			}
			else{			
				$includeProducts=filter_var($this->input->get("prods"),FILTER_VALIDATE_BOOLEAN);
				/*Ordenar wheres*/
				$fields=json_decode(base64_decode($this->input->get("w")));	
				$printprod=$this->input->get("prods");
				$where="";
				foreach($fields as $field=>$val){
					switch($field){
						case "inicio":
							$where.=" DATE(`fecha_venta`)>='".$val."' AND";
							$fechaInicio=$val;
						break;
						case "final":
							$where.=" DATE(`fecha_venta`)<='".$val."' AND";
							$fechaFin=$val;
						break;
					}
				}
				$where=($where!=""?$where=substr($where,0,-3):"");
				$SQLStmt="SELECT id_venta as id,documento_venta as documento";			
				$SQLStmt.=" FROM ventas";
				$SQLStmt.=" WHERE ".$where." AND estado_venta=1";
				$ventas=$this->Generic_model->sql_custom($SQLStmt);
				$lineas=array();
				if(count($ventas)){
					/*Obtener productos por ventas*/
					foreach($ventas as $venta){
						$prodxventa=$this->Generic_model->get('salida_productos','salida_productos.id_producto as producto,salida_productos.id_presentacion as presentacion,presentaciones.desc_presentacion as desc,(salida_productos.cant_salida*unidades_representativas) as cantidad_equivalente, (costo_salida/unidades_representativas) as precio_equivalente,productos.id_grupo,productos.id_subgrupo,grupos.nombre_grupo,subgrupos.nombre_subgrupo',array('id_venta'=>$venta->id),'','',array('presentaciones'=>'presentaciones.id_presentacion = salida_productos.id_presentacion','productos'=>'productos.id_producto = salida_productos.id_producto','grupos'=>'grupos.id_grupo=productos.id_grupo,LEFT','subgrupos'=>'subgrupos.id_subgrupo=productos.id_subgrupo,LEFT'));
						if(count($prodxventa)){
							foreach($prodxventa as $prod){
								if(array_key_exists($prod->id_grupo,$lineas)){/*Si ya existe una clave para el grupo*/
									if(array_key_exists($prod->id_subgrupo,$lineas[$prod->id_grupo]['subgrupos'])){/*Si ya existe una clave para el sub grupo*/
										if(array_key_exists($prod->producto,$lineas[$prod->id_grupo]['subgrupos'][$prod->id_subgrupo]['productos'])){/*Si ya existe una clave para el producto*/
											$lineas[$prod->id_grupo]['subgrupos'][$prod->id_subgrupo]['productos'][$prod->producto]['cantidad']+=$prod->cantidad_equivalente;
											$lineas[$prod->id_grupo]['subgrupos'][$prod->id_subgrupo]['productos'][$prod->producto]['total']+=($prod->cantidad_equivalente*$prod->precio_equivalente);
											
											$lineas[$prod->id_grupo]['subgrupos'][$prod->id_subgrupo]['total']+=$prod->cantidad_equivalente*$prod->precio_equivalente;
											$lineas[$prod->id_grupo]["total"]+=$prod->cantidad_equivalente*$prod->precio_equivalente;
										}
										else{/*Si no existe una clave para el producto*/
											/*obtener presentacion principal*/
											$pres_primaria=$this->Generic_model->get('presentaciones','desc_presentacion as desc',array('id_producto'=>$prod->producto,'tipo_presentacion'=>0));
											/*Agregar producto a linea*/
											 $lineas[$prod->id_grupo]['subgrupos'][$prod->id_subgrupo]['productos'][$prod->producto]=array(
												'id'=>$prod->producto,
												'desc'=>$pres_primaria[0]->desc,
												'cantidad'=>$prod->cantidad_equivalente,
												'total'=>$prod->cantidad_equivalente*$prod->precio_equivalente
											);
											$lineas[$prod->id_grupo]['subgrupos'][$prod->id_subgrupo]['total']+=$prod->cantidad_equivalente*$prod->precio_equivalente;
											$lineas[$prod->id_grupo]["total"]+=$prod->cantidad_equivalente*$prod->precio_equivalente;
										}
									}
									else{/*Si no existe una clave para el sub grupo*/
										/*Crear clave para subgrupo*/
										$lineas[$prod->id_grupo]['subgrupos'][$prod->id_subgrupo]=array(
											'nombre'=>($prod->id_subgrupo==0?"PRODUCTOS SIN SUBGRUPO":$prod->nombre_subgrupo),
											'total'=>$prod->cantidad_equivalente*$prod->precio_equivalente,
											'productos'=>array()
										);
										/*obtener presentacion principal*/
										$pres_primaria=$this->Generic_model->get('presentaciones','desc_presentacion as desc',array('id_producto'=>$prod->producto,'tipo_presentacion'=>0));
										/*Agregar producto a linea*/
										 $lineas[$prod->id_grupo]['subgrupos'][$prod->id_subgrupo]['productos'][$prod->producto]=array(
											'desc'=>$pres_primaria[0]->desc,
											'cantidad'=>$prod->cantidad_equivalente,
											'total'=>$prod->cantidad_equivalente*$prod->precio_equivalente
										);
										$lineas[$prod->id_grupo]["total"]+=$prod->cantidad_equivalente*$prod->precio_equivalente;
									}
								}
								else{/*Si no existe una clave para el grupo*/
									/*Crear clave para grupo*/
									$lineas[$prod->id_grupo]=array(
										'nombre'=>($prod->id_grupo==0?"PRODUCTOS SIN GRUPO":$prod->nombre_grupo),
										'total'=>$prod->cantidad_equivalente*$prod->precio_equivalente,
										'subgrupos'=>array()
									);
									/*Crear clave para subgrupo*/
									$lineas[$prod->id_grupo]['subgrupos'][$prod->id_subgrupo]=array(
										'nombre'=>($prod->id_subgrupo==0?"PRODUCTOS SIN SUBGRUPO":$prod->nombre_subgrupo),
										'total'=>$prod->cantidad_equivalente*$prod->precio_equivalente,
										'productos'=>array()
									);
									/*obtener presentacion principal*/
									$pres_primaria=$this->Generic_model->get('presentaciones','desc_presentacion as desc',array('id_producto'=>$prod->producto,'tipo_presentacion'=>0));
									/*Agregar producto a linea*/
									 $lineas[$prod->id_grupo]['subgrupos'][$prod->id_subgrupo]['productos'][$prod->producto]=array(
										'desc'=>$pres_primaria[0]->desc,
										'cantidad'=>$prod->cantidad_equivalente,
										'total'=>$prod->cantidad_equivalente*$prod->precio_equivalente
									);
								}
							}
						}
					}
				}
				/* echo "<pre>";
				print_r($lineas);
				echo "</pre>"; */
				$data['configs'] = $this->configuraciones;
				$data['printprod'] = $printprod;
				$data['lineas'] = $lineas;
				$this->load->view('reportes/reporte_lineas_pdf',$data);
			}
		}
		/*----------- Reporte productos estrellas -------------*/
		function reporte_productos_estrellas(){
			if(!filter_var($this->permisos['reportesventas']['reportesventas-ventasestrellas'],FILTER_VALIDATE_BOOLEAN)){
				$UIData['main_view']="error_noacceso_view";
				$UIData['structure_only']=true;
				$UIData['section_title']="Reporte de productos estrellas";
				$this->load->view('template', $UIData);
			}
			else{
				/*Ordenar wheres*/
				$fields=json_decode(base64_decode($this->input->get("w")));
				$orderable_key='cantidad';
				$limit=25;
				$where="";
				foreach($fields as $field=>$val){
					switch($field){
						case "inicio":
							$where.=" DATE(`fecha_venta`)>='".$val."' AND";
							$fechaInicio=$val;
						break;
						case "final":
							$where.=" DATE(`fecha_venta`)<='".$val."' AND";
							$fechaFin=$val;
						break;
						case "criterio":
							$orderable_key=($val==0?"cantidad":"total");
						break;
						case "limite":
							$limit=(int)$val;
						break;
					}
				}
				$where=($where!=""?$where=substr($where,0,-3):"");
				$SQLStmt="SELECT id_venta as id,documento_venta as documento";			
				$SQLStmt.=" FROM ventas";
				$SQLStmt.=" WHERE ".$where." AND estado_venta=1";
				$ventas=$this->Generic_model->sql_custom($SQLStmt);
				$productos=array();
				if(count($ventas)){
					/*Obtener productos por ventas*/
					foreach($ventas as $venta){
						$prodxventa=$this->Generic_model->get('salida_productos','salida_productos.id_producto as producto,salida_productos.id_presentacion as presentacion,presentaciones.desc_presentacion as desc,(salida_productos.cant_salida*unidades_representativas) as cantidad_equivalente, (costo_salida/unidades_representativas) as precio_equivalente',array('id_venta'=>$venta->id),'','',array('presentaciones'=>'presentaciones.id_presentacion = salida_productos.id_presentacion'));
						if(count($prodxventa)){
							foreach($prodxventa as $prod){
								if(array_key_exists($prod->producto,$productos)){/*Si ya existe una clave para el producto*/
									$productos[$prod->producto]['cantidad']+=$prod->cantidad_equivalente;
									$productos[$prod->producto]['total']+=($prod->cantidad_equivalente*$prod->precio_equivalente);
								}else{
									/*obtener presentacion principal*/
									$pres_primaria=$this->Generic_model->get('presentaciones','desc_presentacion as desc',array('id_producto'=>$prod->producto,'tipo_presentacion'=>0));
									$productos[$prod->producto]=array(
										'desc'=>$pres_primaria[0]->desc,
										'cantidad'=>$prod->cantidad_equivalente,
										'total'=>$prod->cantidad_equivalente*$prod->precio_equivalente
									);
								}
							}
						}
					}
				}
				$orderable=array();
				foreach($productos as $key=>$row){
					$orderable[$key]=$row[$orderable_key];
				}
				array_multisort($orderable, SORT_DESC, $productos);
				$productos_estrellas=array();
				for($i=0;$i<$limit;$i++){
					$productos_estrellas[]=$productos[$i];
				}
				/* echo "<pre>";
				print_r($productos_estrellas);
				echo "</pre>"; */
				$data['configs'] = $this->configuraciones;
				$data['productos_estrellas'] = $productos_estrellas;
				$this->load->view('reportes/reporte_estrellas_pdf',$data);
			}
		}
/*------------------------------------- REPORTES DE ENTRADAS -------------------------------------*/
	function reportes_entradas(){
		$UIData['user_info']=$this->usuario;
		$UIData['main_view']	= "reportes_entradas_view";
		$UIData['section_title']	= "Reportes de entradas";
		$UIData['jsfiles']=array("miracle.reportes_entradas","miracle.transacciones.tools","miracle.productos_inventario_buscar.min");
		$UIData['plugins']=array(
			array(
				"nombre"=>"datapicker",
				"css"=>array('datepicker3'),
				"js"=>array('bootstrap-datepicker','locales/bootstrap-datepicker.es')
			),
			array(
				"nombre"=>"iCheck",
				"css"=>array('custom'),
				"js"=>array('icheck.min')
			),
			array(
				"nombre"=>"datatables",
				"css"=> array('dataTables.bootstrap','dataTables.responsive','dataTables.tableTools.min'),
				"js"=> array('jquery.dataTables','dataTables.bootstrap.min','dataTables.responsive','dataTables.tableTools.min')
			),
			array(
				"nombre"=>"chosen",
				"css"=> array('chosen'),
				"js"=> array('chosen.jquery')
			),
		);
		$UIData['proveedores']=$this->Generic_model->get("proveedores","*");
		$UIData['usuarios']=$this->Generic_model->get("usuarios","*",array("id_usuario >=" => 0));
		$UIData['cajas']=$this->Generic_model->get("cajas");
		$UIData['documentos']=$this->config->item("documentos_venta");
		$this->load->view('template', $UIData);
	}
		/*-------------- Reporte devoluciones ----------------*/
		function reporte_devoluciones(){
			if(!filter_var($this->permisos['reportesentradas']['reportesentradas-devoluciones'],FILTER_VALIDATE_BOOLEAN)){
				$UIData['main_view']="error_noacceso_view";
				$UIData['structure_only']=true;
				$UIData['section_title']="Reporte de devoluciones";
				$this->load->view('template', $UIData);
			}else{		
				$data['configs']=$this->configuraciones;
				$wheres=json_decode(base64_decode($this->input->get("w")));
				$includeProducts=filter_var($this->input->get("prods"),FILTER_VALIDATE_BOOLEAN);
				$where="";
				foreach($wheres as $field=>$val){
					switch($field){
						case "inicio":
							$where.=" DATE(`fecha_devolucion`)>='".$val."' AND";
								$fecha_inicio=$val;
						break;
						case "final":
							$where.=" DATE(`fecha_devolucion`)<='".$val."' AND";
							$fecha_fin=$val;
						break;
						case "documento":
							$where.=" doc_devolucion='".$val."' AND";
						break;
						case "caja":
							$where.=" devoluciones.id_caja='".$val."' AND";
						break;
						case "cajero":
							$where.=" devoluciones.id_usuario='".$val."' AND";
						break;
					}
				}
				$where=($where!=""?$where=substr($where,0,-3):"");
				/*Consultar ventas*/
				$SQLStmt="SELECT id_devolucion, motivo_devolucion, forma_devolucion, doc_devolucion, num_doc_devolucion, nombre_usuario, ventas.nombre_cliente as cliente, ventas.id_venta,ventas.documento_venta,ventas.num_documento_venta, clientes.nombre_cliente, fecha_devolucion,(grabado_devolucion+exento_devolucion+nosujeto_devolucion+iva_devolucion-retencion_devolucion+percepcion_devolucion) as total";
				$SQLStmt.=" FROM devoluciones";
				$SQLStmt.=" LEFT JOIN usuarios on usuarios.id_usuario=devoluciones.id_usuario LEFT JOIN ventas on ventas.id_venta=devoluciones.id_venta LEFT JOIN clientes on clientes.id_cliente = ventas.id_cliente";
				$SQLStmt.=" WHERE ".$where;
				$SQLStmt.=" ORDER BY fecha_devolucion ASC";
				$devoluciones=$this->Generic_model->sql_custom($SQLStmt);
				
				if($includeProducts && count($devoluciones)){
					foreach($devoluciones as $dev){
						 $dev->productos=$this->Generic_model->get('entrada_productos','desc_presentacion,cant_entrada,costo_entrada,sku_presentacion,entrada_productos.id_presentacion',array("id_devolucion" => $dev->id_devolucion),"","",array('presentaciones'=>'presentaciones.id_presentacion=entrada_productos.id_presentacion'));
					}
				}
				$data['devoluciones']=$devoluciones;
				$data['includeProducts']=$includeProducts;
				$this->load->view('reportes/reporte_devoluciones_nuevo_pdf',$data);
			}
		}
		/*---------------- Reporte compras ------------------*/
		function reporte_compras(){
			if(!filter_var($this->permisos['reportesentradas']['reportesentradas-compras'],FILTER_VALIDATE_BOOLEAN)){
				$UIData['main_view']="error_noacceso_view";
				$UIData['structure_only']=true;
				$UIData['section_title']="Reporte de compras";
				$this->load->view('template', $UIData);
			}else{
				$data['configs']=$this->configuraciones;
				$wheres=json_decode(base64_decode($this->input->get("w")));
				$where="";
				$includeProducts=filter_var($this->input->get("prods"),FILTER_VALIDATE_BOOLEAN);
				$data['includeProducts']=$includeProducts;
				foreach($wheres as $field=>$val){
					switch($field){
						case "inicio":
							$where.=" DATE(`fecha_compra`)>='".$val."' AND";
							$fecha_inicio=$val;
						break;
						case "final":
							$where.=" DATE(`fecha_compra`)<='".$val."' AND";
							$fecha_fin=$val;
						break;
						case "proveedor":
							$where.=" compras.id_proveedor='".$val."' AND";
						break;
						case "usuario":
							$where.=" compras.id_usuario='".$val."' AND";
						break;
					}
				}
				$where=($where!=""?$where=substr($where,0,-3):"");
				/*Consultar compras*/
				$SQLStmt="SELECT id_compra,fecha_compra,nombre_proveedor,documento_compra,num_doc_compra,forma_pago_compra,nombre_usuario,(subtotal_compra+total_exento_compra+total_nosujeto_compra+iva_compra-retencion_compra+percepcion_compra) as total";
				$SQLStmt.=" FROM compras";
				$SQLStmt.=" LEFT JOIN usuarios on usuarios.id_usuario=compras.id_usuario LEFT JOIN proveedores on proveedores.id_proveedor=compras.id_proveedor";
				$SQLStmt.=" WHERE ".$where;
				$SQLStmt.=" ORDER BY fecha_compra ASC;";
				$compras=$this->Generic_model->sql_custom($SQLStmt);
				$data['fechadesde']=$fecha_inicio;
				$data['fechahasta']=$fecha_fin;
				/* echo "<pre>";
				print_r($compras);
				echo "</pre>"; */
				$data['configs'] = $this->configuraciones;
				if($includeProducts && count($compras)){
					foreach($compras as $compra){
						 $compra->productos=$this->Generic_model->get('entrada_productos','desc_presentacion,cant_entrada,costo_entrada,sku_presentacion,entrada_productos.id_presentacion',array("id_compra" => $compra->id_compra),"","",array('presentaciones'=>'presentaciones.id_presentacion=entrada_productos.id_presentacion'));
					}
				}
				$data['compras'] = $compras;
				$this->load->view('reportes/reporte_compras_pdf',$data);
			}
		}
		function reporte_historico_compras(){
			if(!filter_var($this->permisos['reportesentradas']['reportesentradas-compras'],FILTER_VALIDATE_BOOLEAN)){
				$UIData['main_view']="error_noacceso_view";
				$UIData['structure_only']=true;
				$UIData['section_title']="Reporte de compras";
				$this->load->view('template', $UIData);
			}else{
				$data['configs']=$this->configuraciones;
				$wheres=json_decode(base64_decode($this->input->get("w")));
				$where="";
				foreach($wheres as $field=>$val){
					switch($field){
						case "inicio":
							$where.=" DATE(`fecha_entrada`)>='".$val."' AND";
							$fecha_inicio=$val;
						break;
						case "final":
							$where.=" DATE(`fecha_entrada`)<='".$val."' AND";
							$fecha_fin=$val;
						break;
						case "producto_id":
							$where.=" entrada_productos.id_producto='".$val."' AND";
						break;
						case "proveedor":
							$where.=" compras.id_proveedor='".$val."' AND";
						break;
					}
				}
				$where=($where!=""?$where=substr($where,0,-3):"");
				$SQLStmt="SELECT entrada_productos.id_producto,fecha_entrada,desc_presentacion,documento_compra,num_doc_compra,nombre_proveedor,cant_entrada,costo_entrada";
				$SQLStmt.=" FROM entrada_productos";
				$SQLStmt.=" LEFT JOIN presentaciones ON presentaciones.id_presentacion=entrada_productos.id_presentacion LEFT JOIN compras ON compras.id_compra=entrada_productos.id_compra LEFT JOIN proveedores ON proveedores.id_proveedor=compras.id_proveedor";
				$SQLStmt.=" WHERE ".$where." AND concepto_entrada=1";
				$SQLStmt.=" ORDER BY fecha_entrada ASC;";
				$costos=$this->Generic_model->sql_custom($SQLStmt);
				$data['fechadesde']=$fecha_inicio;
				$data['fechahasta']=$fecha_fin;
				/* echo "<pre>";
				print_r($costos);
				echo "</pre>"; */
				$data['configs'] = $this->configuraciones;
				$data['costos'] = $costos;
				$this->load->view('reportes/reporte_historico_costos_pdf',$data);
			}
		}
	
	/*-------------------------------------	REPORTES DE CORTES -------------------------------------*/
	function cortes(){
		$dataPrint['configs'] = $this->configuraciones;
		$corte=$this->Generic_model->get("cortes","*",array("id_corte"=>$this->input->get("id")),"","",array("usuarios"=>"usuarios.id_usuario=cortes.id_usuario,LEFT","cajas"=>"cajas.id_caja=cortes.id_corte,LEFT","resoluciones_caja"=>"resoluciones_caja.id_resolucion=cortes.id_resolucion,LEFT"));
		$corte=$corte[0];
					
		$dataPrint['tipo_corte']=($corte->tipo_corte==0?"X":($corte->tipo_corte==1?"X PARCIAL":($corte->tipo_corte==2?"Z":($corte->tipo_corte==3?"Z MENSUAL":""))));
		$dataPrint['numero_corte']=$corte->correlativo_corte;
		$dataPrint['caja']=$corte->nombre_caja;
		$dataPrint['cajero']=$corte->nombre_usuario;
		$dataPrint['fecha']=$corte->fecha_corte;
		
		$dataPrint['dataCorteFiscal']=unserialize($corte->corte_fiscal);
		$dataPrint['dataAnexoMedio']=unserialize($corte->corte_anexo1);
		$dataPrint['dataAnexoDocumento']=unserialize($corte->corte_anexo2);
		$dataPrint['dataAnexoTipo']=unserialize($corte->corte_anexo3);
		$dataPrint['printCorteFiscal']=filter_var($this->input->get("corte"),FILTER_VALIDATE_BOOLEAN);
		$dataPrint['printAnexoMedio']=filter_var($this->input->get("anexo1"),FILTER_VALIDATE_BOOLEAN);
		$dataPrint['printAnexoDocumento']=filter_var($this->input->get("anexo2"),FILTER_VALIDATE_BOOLEAN);
		$dataPrint['printAnexoTipo']=filter_var($this->input->get("anexo3"),FILTER_VALIDATE_BOOLEAN);
		
		$this->load->view('reportes/cortes_pdf',$dataPrint);			
	}
	function is_logged_in(){
		$session = $this->session->userdata('userInfo');
		$is_logged_in =$session['is_logged_in'];
		if(!isset($is_logged_in) || $is_logged_in !== true){
			redirect(base_url("login"));
			die();
		}
	}
}
?>